/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import java.util.ArrayList;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Voxel3D;

public class MereoObject3D {
    private Object3D A;
    private Object3D Adilated = null;
    private Object3D B;
    private Object3D Bdilated = null;
    private Object3DVoxels inter = null;
    private float RadX;
    private float RadY;
    private float RadZ;
    public double distBB = Double.NaN;
    private boolean disjoint = true;
    private static final double SQRT3 = Math.sqrt(3.0);
    private static final double SMALL = 0.001;
    private boolean canonicRadii = false;
    public static final String DC = "DC";
    public static final String EC = "EC";
    public static final String PO = "PO";
    public static final String EQ = "EQ";
    public static final String TPP = "TPP";
    public static final String NTPP = "NTPP";
    public static final String TPPi = "TPPi";
    public static final String NTPPi = "NTPPi";
    public static final String EMPTY = "EMPTY";
    public static final String UNKNOWN = "UNKNOWN";

    public MereoObject3D(Object3D object3D, Object3D object3D2) {
        this.A = object3D;
        this.B = object3D2;
        this.RadX = 1.0f;
        this.RadY = 1.0f;
        this.RadZ = 1.0f;
        this.checkCanonicRadii();
        this.buildInterObject(false);
    }

    public MereoObject3D(Object3D object3D, Object3D object3D2, float f, float f2, float f3) {
        this.A = object3D;
        this.B = object3D2;
        this.RadX = f;
        this.RadY = f2;
        this.RadZ = f3;
        this.checkCanonicRadii();
        this.buildInterObject(false);
    }

    public MereoObject3D(Object3D object3D, Object3D object3D2, float f, float f2) {
        this.A = object3D;
        this.B = object3D2;
        this.RadX = f;
        this.RadY = f;
        this.RadZ = f2;
        this.checkCanonicRadii();
        this.buildInterObject(false);
    }

    public MereoObject3D(Object3D object3D, Object3D object3D2, float f) {
        this.A = object3D;
        this.B = object3D2;
        this.RadX = f;
        this.RadY = f;
        this.RadZ = f;
        this.checkCanonicRadii();
        this.buildInterObject(false);
    }

    public Object3D getA() {
        return this.A;
    }

    public void setA(Object3D object3D) {
        this.A = object3D;
        this.Adilated = null;
        this.buildInterObject(false);
    }

    public Object3D getB() {
        return this.B;
    }

    public void setB(Object3D object3D) {
        this.B = object3D;
        this.Bdilated = null;
        this.buildInterObject(false);
    }

    public float getRadX() {
        return this.RadX;
    }

    public void setRadX(float f) {
        this.RadX = f;
        this.Adilated = null;
        this.Bdilated = null;
        this.checkCanonicRadii();
    }

    public float getRadY() {
        return this.RadY;
    }

    public void setRadY(float f) {
        this.RadY = f;
        this.Adilated = null;
        this.Bdilated = null;
        this.checkCanonicRadii();
    }

    public float getRadZ() {
        return this.RadZ;
    }

    public void setRadZ(float f) {
        this.RadZ = f;
        this.Adilated = null;
        this.Bdilated = null;
        this.checkCanonicRadii();
    }

    private void checkCanonicRadii() {
        if (this.RadX == 1.0f && this.RadY == 1.0f && this.RadZ == 1.0f) {
            this.canonicRadii = true;
        }
    }

    private void buildInterObject(boolean bl) {
        this.inter = this.A.getIntersectionObject(this.B);
        if (bl && this.inter != null) {
            for (Voxel3D voxel3D : this.inter.getVoxels()) {
                boolean bl2 = this.A.isContour(voxel3D);
                boolean bl3 = this.B.isContour(voxel3D);
                int n = 0;
                if (bl2) {
                    n = 1;
                }
                if (bl3) {
                    n += 2;
                }
                voxel3D.setValue(n);
            }
        }
        if (this.inter != null) {
            this.disjoint = this.inter.getVolumePixels() == 0;
        }
        this.distBB = !this.A.isEmpty() && !this.B.isEmpty() ? this.A.distBorderUnit(this.B) : Double.NaN;
    }

    private boolean Overlap() {
        return !this.disjoint;
    }

    private boolean Parthood() {
        if (this.disjoint) {
            return false;
        }
        boolean bl = this.A.getVolumePixels() > 0;
        boolean bl2 = this.B.includes(this.A);
        return bl && bl2;
    }

    private boolean ParthoodInverse() {
        if (this.disjoint) {
            return false;
        }
        boolean bl = this.B.getVolumePixels() > 0;
        boolean bl2 = this.A.includes(this.B);
        return bl && bl2;
    }

    public boolean Equality() {
        if (this.disjoint) {
            return false;
        }
        return this.Parthood() && this.ParthoodInverse();
    }

    public boolean ProperParthood() {
        if (this.disjoint) {
            return false;
        }
        return this.Parthood() && !this.Equality();
    }

    public boolean ProperParthoodInverse() {
        if (this.disjoint) {
            return false;
        }
        return this.ParthoodInverse() && !this.Equality();
    }

    public boolean Discrete() {
        return this.disjoint;
    }

    public boolean PartialOverlap() {
        if (this.disjoint) {
            return false;
        }
        return this.Overlap() && !this.Parthood() && !this.ParthoodInverse();
    }

    public boolean Disconnection() {
        if (this.canonicRadii) {
            return this.Disconnection1();
        }
        return this.DisconnectionRad();
    }

    public boolean ExternalConnection() {
        if (this.canonicRadii) {
            return this.ExternalConnection1();
        }
        return this.ExternalConnectionRad();
    }

    public boolean TangentialProperParthood() {
        if (this.canonicRadii) {
            return this.TangentialProperParthood1();
        }
        return this.TangentialProperParthoodRad();
    }

    public boolean NonTangentialProperParthood() {
        if (this.canonicRadii) {
            return this.NonTangentialProperParthood1();
        }
        return this.NonTangentialProperParthoodRad();
    }

    public boolean TangentialProperParthoodInverse() {
        if (this.canonicRadii) {
            return this.TangentialProperParthoodInverse1();
        }
        return this.TangentialProperParthoodInverseRad();
    }

    public boolean NonTangentialProperParthoodInverse() {
        if (this.canonicRadii) {
            return this.NonTangentialProperParthoodInverse1();
        }
        return this.NonTangentialProperParthoodInverseRad();
    }

    public String getRCC8Relationship() {
        if (this.A.isEmpty() || this.B.isEmpty()) {
            return EMPTY;
        }
        if (this.Disconnection()) {
            return DC;
        }
        if (this.ExternalConnection()) {
            return EC;
        }
        if (this.PartialOverlap()) {
            return PO;
        }
        if (this.Equality()) {
            return EQ;
        }
        if (this.TangentialProperParthood()) {
            return TPP;
        }
        if (this.NonTangentialProperParthood()) {
            return NTPP;
        }
        if (this.TangentialProperParthoodInverse()) {
            return TPPi;
        }
        if (this.NonTangentialProperParthoodInverse()) {
            return NTPPi;
        }
        return UNKNOWN;
    }

    private boolean Disconnection1() {
        return this.Discrete() && this.distBB > SQRT3;
    }

    private boolean ExternalConnection1() {
        return this.Discrete() && this.distBB <= SQRT3;
    }

    private boolean TangentialProperParthood1() {
        return this.ProperParthood() && this.distBB <= 0.001;
    }

    private boolean NonTangentialProperParthood1() {
        return this.ProperParthood() && this.distBB > 0.001;
    }

    private boolean TangentialProperParthoodInverse1() {
        return this.ProperParthoodInverse() && this.distBB <= 0.001;
    }

    private boolean NonTangentialProperParthoodInverse1() {
        return this.ProperParthoodInverse() && this.distBB > 0.001;
    }

    private Object3D getDilatedA() {
        if (this.Adilated == null) {
            this.Adilated = this.A.getDilatedObject(this.RadX, this.RadY, this.RadZ, false);
        }
        return this.Adilated;
    }

    private Object3D getDilatedB() {
        if (this.Bdilated == null) {
            this.Bdilated = this.B.getDilatedObject(this.RadX, this.RadY, this.RadZ, false);
        }
        return this.Bdilated;
    }

    private boolean DisconnectionRad() {
        if (!this.Discrete()) {
            return false;
        }
        MereoObject3D mereoObject3D = new MereoObject3D(this.getDilatedA(), this.B);
        return !mereoObject3D.Overlap();
    }

    private boolean ExternalConnectionRad() {
        if (!this.Discrete()) {
            return false;
        }
        MereoObject3D mereoObject3D = new MereoObject3D(this.getDilatedA(), this.B);
        return mereoObject3D.Overlap();
    }

    private boolean TangentialProperParthoodRad() {
        if (!this.ProperParthood()) {
            return false;
        }
        MereoObject3D mereoObject3D = new MereoObject3D(this.getDilatedA(), this.B);
        return !mereoObject3D.ProperParthood();
    }

    private boolean NonTangentialProperParthoodRad() {
        if (!this.ProperParthood()) {
            return false;
        }
        MereoObject3D mereoObject3D = new MereoObject3D(this.getDilatedA(), this.B);
        return mereoObject3D.ProperParthood();
    }

    private boolean TangentialProperParthoodInverseRad() {
        if (!this.ProperParthoodInverse()) {
            return false;
        }
        MereoObject3D mereoObject3D = new MereoObject3D(this.A, this.getDilatedB());
        return !mereoObject3D.ProperParthoodInverse();
    }

    private boolean NonTangentialProperParthoodInverseRad() {
        if (!this.ProperParthoodInverse()) {
            return false;
        }
        MereoObject3D mereoObject3D = new MereoObject3D(this.A, this.getDilatedB());
        return mereoObject3D.ProperParthoodInverse();
    }

    public Object3DVoxels getInterObject() {
        return this.inter;
    }

    public double pcColocA() {
        if (this.Discrete()) {
            return 0.0;
        }
        return 100.0 * ((double)this.inter.getVolumePixels() / (double)this.A.getVolumePixels());
    }

    public double pcColocB() {
        if (this.Discrete()) {
            return 0.0;
        }
        return 100.0 * ((double)this.inter.getVolumePixels() / (double)this.B.getVolumePixels());
    }

    public int nbVoxContourOverlap(boolean bl, boolean bl2) {
        if (this.Discrete()) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (bl) {
            n2 = 1;
        }
        if (bl2) {
            n2 = 2;
        }
        if (bl && bl2) {
            n2 = 3;
        }
        if (bl || bl2) {
            n3 = 3;
        }
        ArrayList<Voxel3D> arrayList = this.inter.getVoxels();
        for (Voxel3D voxel3D : arrayList) {
            if (voxel3D.getValue() != (double)n2 && voxel3D.getValue() != (double)n3) continue;
            ++n;
        }
        return n;
    }
}

