package plugins.fab.trackmanager.processors;

import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.gui.viewer.ViewerEvent.ViewerEventType;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import plugins.fab.trackmanager.PluginTrackManagerProcessor;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class TrackProcessorZeroOrigin extends PluginTrackManagerProcessor {

	JTextField clipTextField = new JTextField("  3");
	JCheckBox futureCheckBox = new JCheckBox( "Display future.",false );
	JCheckBox nonActiveTracksCheckBox  = new JCheckBox("Display non active tracks", true );
		
	public TrackProcessorZeroOrigin() {
		
		setName( "Zero Origin" );

	}

	@Override
	public void Compute() {
		
		if ( isEnabled() )
		{
			
			for (TrackSegment ts:trackPool.getTrackSegmentList())
			{
				ArrayList<Detection> detections = ts.getDetectionList();

				Detection initialDetection = null;
				initialDetection = ts.getFirstDetection();

				double ix = initialDetection.getX();
				double iy = initialDetection.getY();
				double iz = initialDetection.getZ();				

				for (Detection d: detections )
				{
					double x = d.getX();
					double y = d.getY();
					double z = d.getZ();

					d.setX( x - ix );
					d.setY( y - iy );
					d.setZ( z - iz );
				}
			}			
			
		}
		
	}

	@Override
	public void Close() {}

@Override
public void displaySequenceChanged() {
	
}

	
}
