package plugins.tprovoost.box3d;

import icy.gui.component.button.ColorChooserButton;
import icy.gui.frame.IcyFrame;
import icy.preferences.PluginsPreferences;
import icy.preferences.XMLPreferences;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class Box3dProps extends IcyFrame implements ActionListener
{
	private XMLPreferences prefs = PluginsPreferences.root(Box3D.class);

	private JCheckBox cboxDisplayGrid;
	private JCheckBox cboxDisplayBoundingBox;
	private JCheckBox cboxAxesAbsolute;
	private JCheckBox cboxAxesValues;
	private ColorChooserButton colorChooser;

	private static final String PREF_DISPLAY_GRID = "grid";
	private static final String PREF_AXES_ABSOLUTE = "axes";
	private static final String PREF_AXES_VALUES = "axes_values";
	private static final String PREF_BBOX = "bbox";
	private static Box3dProps singleton;

	private JPanel panelOptions;

	/**
	 * Singleton.
	 */
	private Box3dProps()
	{
		super("BBox 3d Properties", false, true, false, true);

		JPanel mainPanel = new JPanel();
		mainPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
		mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));

		panelOptions = new JPanel();
		panelOptions.setBorder(new TitledBorder(null, "Options", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		mainPanel.add(panelOptions);
		panelOptions.setLayout(new GridLayout(5, 1, 0, 0));

		cboxDisplayGrid = new JCheckBox("Display Grid");
		panelOptions.add(cboxDisplayGrid);

		cboxAxesAbsolute = new JCheckBox("Display Absolute Axes");
		panelOptions.add(cboxAxesAbsolute);

		cboxAxesValues = new JCheckBox("Display Axes Values");
		panelOptions.add(cboxAxesValues);

		cboxDisplayBoundingBox = new JCheckBox("Display Bounding Box");
		panelOptions.add(cboxDisplayBoundingBox);

		colorChooser = new ColorChooserButton(Color.GRAY);
		panelOptions.add(colorChooser);

		setContentPane(mainPanel);

		loadPrefs();
		pack();

		cboxDisplayGrid.addActionListener(this);
		cboxAxesAbsolute.addActionListener(this);
		cboxAxesValues.addActionListener(this);
		cboxDisplayBoundingBox.addActionListener(this);
	}

	public static Box3dProps getInstance()
	{
		if (singleton == null)
			singleton = new Box3dProps();
		return singleton;
	}

	public boolean isGridVisible()
	{
		return cboxDisplayGrid.isSelected();
	}

	public boolean isBBoxVisible()
	{
		return cboxDisplayBoundingBox.isSelected();
	}

	public boolean areAxesAbsolute()
	{
		return cboxAxesAbsolute.isSelected();
	}

	public boolean areAxesValuesVisible()
	{
		return cboxAxesValues.isSelected();
	}

	private void savePrefs()
	{
		prefs.putBoolean(PREF_DISPLAY_GRID, cboxDisplayGrid.isSelected());
		prefs.putBoolean(PREF_BBOX, cboxAxesValues.isSelected());
		prefs.putBoolean(PREF_AXES_ABSOLUTE, cboxAxesAbsolute.isSelected());
		prefs.putBoolean(PREF_AXES_VALUES, cboxAxesValues.isSelected());
	}

	private void loadPrefs()
	{
		cboxDisplayGrid.setSelected(prefs.getBoolean(PREF_DISPLAY_GRID, true));
		cboxDisplayBoundingBox.setSelected(prefs.getBoolean(PREF_BBOX, false));
		cboxAxesAbsolute.setSelected(prefs.getBoolean(PREF_AXES_ABSOLUTE, false));
		cboxAxesValues.setSelected(prefs.getBoolean(PREF_DISPLAY_GRID, false));
	}

	@Override
	public void onClosed()
	{
		savePrefs();
		singleton = null;
	}

	@Override
	public void actionPerformed(ActionEvent e)
	{
		savePrefs();
	}

	public Color getColor()
	{
		return colorChooser.getColor();
	}

}
