/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.blobplugin.misc;

/**
 * @class ParametersCategory
 * 
 *        Describe the step of the algorithm related to a parameter.
 * 
 */
public enum ParametersCategory {
	/**
	 * Global parameter. This category contains:
	 * 
	 * @ul
	 * @li @ref Parameters::sequence()
	 * @li @ref Parameters::rMin()
	 */
	Global,

	/**
	 * Parameters used during the binarization step. This category contains:
	 * 
	 * @ul
	 * @li @ref Parameters::sigma()
	 * @li @ref Parameters::targetBrightness()
	 * @li @ref Parameters::thresholdMethod()
	 * @li @ref Parameters::threshold1()
	 * @li @ref Parameters::threshold2()
	 * @li @ref Parameters::clusterCount()
	 * 
	 * @see @ref Morphology::binarizeImage
	 */
	Binarization,

	/**
	 * Parameters used during the final optimization step. This category
	 * contains:
	 * 
	 * @ul
	 * @li @ref Parameters::maxIter()
	 * @li @ref Parameters::minimalEnergyDelta()
	 * @li @ref Parameters::gradientStepSize()
	 * @li @ref Parameters::gradientFactor()
	 * 
	 * @see @ref Optimization::optimize
	 */
	Optimization
}
