package plugins.fab.fileextension;

import icy.plugin.abstract_.Plugin;

import java.io.File;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.lang.VarString;

//public class FileExtension extends Plugin implements PluginImageAnalysis {

public class FileExtension extends Plugin implements Block {

	VarSequence inputSequenceVar = new VarSequence("input Sequence", null );
	VarString extension = new VarString("extension", "extension");
	VarFile outputFile = new VarFile( "File", null );
	
	@Override
	public void declareInput(VarList inputMap) {

		inputMap.add( inputSequenceVar );
		inputMap.add( extension );
		
	}

	@Override
	public void declareOutput(VarList outputMap) {

		outputMap.add( outputFile );

	}

	@Override
	public void run() {

		File file = new File( inputSequenceVar.getValue().getFilename() + extension.getValue() );
		outputFile.setValue( file );
	}

}
