package plugins.fab.manualtnt;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.collection.array.ArrayUtil;

import java.awt.image.DataBuffer;
import java.util.ArrayList;

import plugins.fab.manualtnt.toremove.WaveletTransform2DTabThread;

public class Utils {

	public IcyBufferedImage projectStackDenoised( Sequence sequenceIn )
	{	        

		final int width = sequenceIn.getWidth();
		final int height = sequenceIn.getHeight();

		final Sequence sequenceOut = new Sequence();

		if (sequenceIn.getSizeZ() == 1)
		{
			System.err.println("The stack has a depth of 1 ? sure ?");
		}

		ArrayList<Thread> threadList = new ArrayList<Thread>();

		try
		{
			System.out.print("starting threads");
			sequenceIn.beginUpdate();

			// int runningThread = 0;

			for (int z = 0; z < sequenceIn.getSizeZ(); z++)
			{

				Thread thread = new ComputeDenoise(sequenceIn.getImage(0, z), sequenceOut, z);
				threadList.add(thread);
				thread.start();
				// runningThread++;

				boolean stayHere = true;
				while (stayHere)
				{
					int nbThreadRunning = 0;
					for (Thread th : threadList)
					{
						if (th.isAlive())
							nbThreadRunning++;
						if (nbThreadRunning > 10)
						{
							try
							{
								Thread.sleep(200);
								System.out.print(".");
							}
							catch (InterruptedException e)
							{
								e.printStackTrace();
							}
						}
						else
						{
							stayHere = false;
						}
					}
				}

			}
			System.out.println();

			System.out.println("waiting for thread");
			for (Thread thread : threadList)
			{
				try
				{
					thread.join();
				}
				catch (InterruptedException e)
				{
					e.printStackTrace();
				}
				// System.out.print("-");
			}
		}
		finally
		{
			sequenceIn.endUpdate();
		}

		// projection

		sequenceIn = sequenceOut;

		// Calcul d'une projection MAX.

		IcyBufferedImage bufferedImageOut = new IcyBufferedImage(sequenceIn.getWidth(), sequenceIn.getHeight(), 1,
				DataBuffer.TYPE_DOUBLE );

		// creation des buffers In
		ArrayList<double[]> bufferInList = new ArrayList<double[]>();
		for (int z = 0; z < sequenceIn.getSizeZ(); z++)
		{
			bufferInList.add(sequenceIn.getDataXYAsDouble(0, z, 0));
		}

		double[] bufferOut = bufferedImageOut.getDataXYAsDouble(0);
		int bufferLength = bufferOut.length;
		for (int i = 0; i < bufferLength; i++)
		{
			double maxValue = 0;
			for (double[] input : bufferInList)
			{
				double red = input[i];
				if ( red > maxValue )
				{
					maxValue = red;
				}
			}
			bufferOut[i] = maxValue;
		}

		bufferedImageOut.dataChanged();
		return bufferedImageOut;


	}

	public IcyBufferedImage denoiseImage(IcyBufferedImage bi)
	{

		final int width = bi.getWidth();
		final int height = bi.getHeight();

		final double[] red = ArrayUtil.arrayToDoubleArray1D(bi.getDataXY(0), bi.isSignedDataType());

		final WaveletTransform2DTabThread waveletThread = new WaveletTransform2DTabThread(red, width, height, 1, 3);

		waveletThread.run(); // pas appele en thread mais bien en appel direct

		double resultat[] = waveletThread.imageDetail[1];

		int resultatLength = resultat.length;
		for (int x = 0; x < resultatLength; x++)
		{
			if (resultat[x] < 0)
			{
				resultat[x] = 0;
			}
			else
			{
				resultat[x] *= 10d;
			}
		}

		IcyBufferedImage icyBufferedImage = new IcyBufferedImage( bi.getWidth(), bi.getHeight(), 1, DataBuffer.TYPE_DOUBLE );

		//      IcyBufferedImage icyBufferedImage = new IcyBufferedImage(getFocusedSequence().getWidth(), getFocusedSequence()
		//      .getHeight(), 1, DataBuffer.TYPE_BYTE);

//		icyBufferedImage.setDataXY(0, ArrayUtil.arrayToByteArray(resultat));
		icyBufferedImage.setDataXY(0, ArrayUtil.arrayToDoubleArray( resultat, true ) );

		return icyBufferedImage;

	}

	class ComputeDenoise extends Thread
	{
		IcyBufferedImage bi;
		Sequence seqOut;
		int z;

		public ComputeDenoise(IcyBufferedImage bi, Sequence seqOut, int z)
		{
			this.bi = bi;
			this.seqOut = seqOut;
			this.z = z;
		}

		@Override
		public void run()
		{
			// System.out.println("start");
			seqOut.setImage(0, z, denoiseImage(bi));
			// System.out.println("terminate");
		}
	}


}
