package plugins.fab.manualtnt.toremove;

public class WaveletTransform2DTabThread extends Thread
{
	final double[] originalImage;
	final int z;
	final int width;
	final int height;
	final int maxScale;
	int pad[] = {2, 4, 8, 16, 32, 64, 128, 256, 512};
	int step[] = {1, 2, 4, 8, 16, 32, 64, 128, 256};
	double w2 = (double)1/16;
	double w1 = (double)1/4;
	double w0 = (double)3/8;

	/**
	 * resultat = [echelle][data]
	 */
	public double[][] imageScale;
	
	/**
	 * fait a partir des images d echelle
	 * [detail][data]
	 * 0 : original - echelle0
	 * 1 : echelle0 - echelle1
	 * 2 : echelle1 - echelle2
	 */
	public double[][] imageDetail;
	
	
	public WaveletTransform2DTabThread(double[] data, int width, int height, int z, int maxScale)
	{
		this.z = z;
		imageScale = new double[maxScale][];
		this.width = width;
		this.height = height;
		this.maxScale = maxScale;
		this.originalImage = data;
	}
	
	@Override
	public void run()
	{
		int cntX, cntY;
		int stepS;
		int wh = width*height;
		double[] arrayX = new double[wh];
		double[] arrayY = new double[wh];
		double[] array1 =originalImage;
		
		for (int s = 1; s <= maxScale; s++)//for each scale
		{
			stepS = step[s-1];
			int idx0 = 0;
			int w2idx1;
			int w1idx1;
			int w1idx2;
			int w2idx2;
			
			for (int y=0; y<height; y++)
				{
					w1idx1 = idx0 + stepS-1;
					w2idx1 = w1idx1+stepS;
					w1idx2 = idx0+stepS;
					w2idx2 = w1idx2+stepS;

					cntX = 0;
					while(cntX < stepS)
					{
						//arrayX.set(idx0, w2* (array1.get(w2idx1)+ array1.get(w2idx2))+ w1*(array1.get(w1idx1)+array1.get(w1idx2)) + w0*array1.get(idx0));						
						arrayX[idx0]  = w2* (array1[w2idx1]+ array1[w2idx2])+ w1*(array1[w1idx1]+array1[w1idx2]) + w0*array1[idx0];													
						w1idx1--;
						w2idx1--;
						w1idx2++;
						w2idx2++;
						idx0++;
						cntX++;
					}
					w1idx1++;
					while(cntX < 2*stepS)
					{
//						arrayX.set(idx0, w2* (array1.get(w2idx1) + array1.get(w2idx2))+ w1*(array1.get(w1idx1) +array1.get(w1idx2))+ w0*array1.get(idx0));						
						arrayX[idx0] =  w2* (array1[w2idx1] + array1[w2idx2])+ w1*(array1[w1idx1] +array1[w1idx2])+ w0*array1[idx0];													
						w1idx1++;
						w2idx1--;
						w1idx2++;
						w2idx2++;
						idx0++;
						cntX++;
					}
					w2idx1++;
					while(cntX < width - 2*stepS)
					{	
						arrayX[idx0] = w2*(array1[w2idx1] + array1[w2idx2])+ w1*(array1[w1idx1]+ array1[w1idx2])+ w0*array1[idx0];						
						w1idx1++;
						w2idx1++;
						w1idx2++;
						w2idx2++;
						idx0++;
						cntX++;
					}
					w2idx2--;
					while (cntX < width - stepS)
					{
						arrayX[idx0] =  w2*(array1[w2idx1]+array1[w2idx2])+ w1*(array1[w1idx1]+array1[w1idx2]) + w0*array1[idx0];						
						w1idx1++;
						w2idx1++;
						w1idx2++;
						w2idx2--;
						idx0++;
						cntX++;
					}
					w1idx2--;
					while (cntX < width)
					{
						arrayX[idx0] =  w2*(array1[w2idx1]+array1[w2idx2]) + w1*(array1[w1idx1]+array1[w1idx2]) + w0*array1[idx0];						
						w1idx1++;
						w2idx1++;
						w1idx2--;
						w2idx2--;
						idx0++;
						cntX++;
					}
				}
			//Y axis transforms
			idx0 = 0;
			int sw = stepS*width;
				for (int x=0; x<width; x++)
				{
					idx0 = x;// + z * wh;
					w1idx1 = idx0 + sw-width;
					w2idx1 = w1idx1 + sw;
					w1idx2 = idx0+sw;
					w2idx2 = w1idx2+sw;
					cntY = 0;
					while(cntY < stepS)
					{
						arrayY[idx0] =  w2* (arrayX[w2idx1]+arrayX[w2idx2])+ w1*(arrayX[w1idx1]+ arrayX[w1idx2])+ w0*arrayX[idx0];						
						w1idx1-=width;
						w2idx1-=width;
						w1idx2+=width;
						w2idx2+=width;
						idx0+=width;
						cntY++;
					}
					w1idx1+=width;
					while(cntY < 2*stepS)
					{
						arrayY[idx0] =  w2* (arrayX[w2idx1]+ arrayX[w2idx2])+ w1*(arrayX[w1idx1]+arrayX[w1idx2])+ w0*arrayX[idx0];						
						w1idx1+=width;
						w2idx1-=width;
						w1idx2+=width;
						w2idx2+=width;
						idx0+=width;
						cntY++;
					}
					w2idx1+=width;
					while(cntY < height - 2*stepS)
					{	
						arrayY[idx0] = w2* (arrayX[w2idx1]+arrayX[w2idx2] )+ w1*(arrayX[w1idx1]+arrayX[w1idx2])+ w0*arrayX[idx0];						
						w1idx1+=width;
						w2idx1+=width;
						w1idx2+=width;
						w2idx2+=width;
						idx0+=width;
						cntY++;
					}
					w2idx2-=width;
					while (cntY < height - stepS)
					{
						arrayY[idx0] =  w2* (arrayX[w2idx1]+arrayX[w2idx2])+ w1*(arrayX[w1idx1]+arrayX[w1idx2])+ w0*arrayX[idx0];						
						w1idx1+=width;
						w2idx1+=width;
						w1idx2+=width;
						w2idx2-=width;
						idx0+=width;
						cntY++;
					}
					w1idx2-=width;
					while (cntY < height)
					{
						arrayY[idx0] =  w2*( arrayX[w2idx1]+arrayX[w2idx2])+ w1*(arrayX[w1idx1]+ arrayX[w1idx2])+ w0*arrayX[idx0];						
						w1idx1+=width;
						w2idx1+=width;
						w1idx2-=width;
						w2idx2-=width;
						idx0+=width;
						cntY++;
					}
				}
				imageScale[s-1] = arrayY;
				array1 = arrayY;
				arrayY = new double[wh];
		}
		
		// Calcul des images de detail.
		
		// image a - image b
		/*
		 * [detail][data]
		 * 0 : original - echelle0
		 * 1 : echelle0 - echelle1
		 * 2 : echelle1 - echelle2
		 */
		imageDetail = new double[ maxScale ][];
		for ( int index = 0 ; index < maxScale ; index++ )
		{
			double resultat[] = new double[height*width];
				double[] imageA;
				if ( index == 0 )
				{
					imageA = originalImage;
				}else
				{
					imageA = imageScale[index-1];
				}
				for ( int i = 0 ; i< height*width ; i++ )
				{
					resultat[i] = imageA[i] - imageScale[index][i];
				}
				imageDetail[index] = resultat;
		}

		
		
		
		
		
		
		
		
		
	}
}