/*
 * Decompiled with CFR 0.152.
 */
package plugins.lagache.anisotropyProfiler;

import icy.gui.util.ComponentUtil;
import icy.gui.util.GuiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import plugins.nchenouard.particleTracking.DetectionChooser;
import plugins.nchenouard.spot.DetectionResult;

public class PanelAnisotropy
extends JPanel {
    private static final long serialVersionUID = 1480638258136975891L;
    public JButton anisotropyStartButton = new JButton("Start");
    public JButton anisotropyStopButton = new JButton("Stop");
    Dimension boxDim = new Dimension(127, 23);
    JButton startButton = new JButton("Start");
    JCheckBox saveResults = new JCheckBox("Save results in XLS files", false);
    JRadioButton Morton = new JRadioButton("Morton criterion");
    JRadioButton Compacity = new JRadioButton("Compacity criterion");
    JTextField anisotropyTextField = new JTextField("0.5");
    JLabel errorLabel = new JLabel("");
    JLabel anisotropyNumber = new JLabel("Morton coefficient");
    JTextField compacityTextField = new JTextField("0.5");
    JLabel compacityNumber = new JLabel("compacity coefficient");
    JTextField resultTextField = new JTextField("");
    JLabel Result = new JLabel("Result");
    static DetectionChooser detectionChooser;
    JCheckBox erasePreExistingTrackCheckBox = new JCheckBox("Erase pre-exisiting tracks", true);

    public DetectionResult getDetectionResult() {
        return detectionChooser.getSelectedDetectionResult();
    }

    public PanelAnisotropy() {
        this.setLayout(new BorderLayout());
        JPanel buttonPane = new JPanel(new FlowLayout(4));
        buttonPane.add(this.anisotropyStartButton);
        buttonPane.add(this.anisotropyStopButton);
        detectionChooser = new DetectionChooser();
        JPanel detectionChooserPanel = new JPanel();
        detectionChooserPanel.setLayout(new BoxLayout(detectionChooserPanel, 3));
        detectionChooserPanel.setBorder(new TitledBorder("Detection source"));
        detectionChooserPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{detectionChooser}));
        detectionChooserPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.erasePreExistingTrackCheckBox}));
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        ComponentUtil.setFixedHeight((Component)this.anisotropyTextField, (int)22);
        ComponentUtil.setFixedHeight((Component)this.compacityTextField, (int)22);
        ComponentUtil.setFixedHeight((Component)this.resultTextField, (int)22);
        this.errorLabel.setAlignmentX(0.0f);
        this.errorLabel.setForeground(Color.red);
        centerPanel.add(Box.createVerticalStrut(5));
        centerPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), this.Morton, Box.createHorizontalGlue()}));
        centerPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), this.Compacity, Box.createHorizontalGlue()}));
        centerPanel.add(Box.createVerticalStrut(5));
        centerPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), this.anisotropyNumber, this.anisotropyTextField, this.errorLabel, Box.createHorizontalGlue()}));
        centerPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), this.compacityNumber, this.compacityTextField, this.errorLabel, Box.createHorizontalGlue()}));
        centerPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), this.Result, this.resultTextField, this.errorLabel, Box.createHorizontalGlue()}));
        centerPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.saveResults}));
        this.setLayout(new BoxLayout(this, 3));
        this.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{detectionChooserPanel}));
        this.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{centerPanel}));
        this.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{buttonPane}));
        this.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
    }

    public boolean erasePreExistingTrack() {
        return this.erasePreExistingTrackCheckBox.isSelected();
    }

    public double getanisotropyNumber() {
        double number;
        try {
            number = Double.parseDouble(this.anisotropyTextField.getText());
            if (this.errorLabel.getText().length() > 0) {
                this.errorLabel.setText("");
            }
        }
        catch (NumberFormatException nfe) {
            number = 0.8;
            this.errorLabel.setText("value not recognized");
        }
        return number;
    }

    public double getcompacityNumber() {
        double number;
        try {
            number = Double.parseDouble(this.compacityTextField.getText());
            if (this.errorLabel.getText().length() > 0) {
                this.errorLabel.setText("");
            }
        }
        catch (NumberFormatException nfe) {
            number = 0.8;
            this.errorLabel.setText("value not recognized");
        }
        return number;
    }
}

