package plugins.fab.trackgenerator;

import flanagan.math.PsRandom;

public class BrownianMotionModel extends MotionModel {

	double sigma;
	PsRandom ran;
	boolean isMotionPureIn2D;
	
	public BrownianMotionModel( TGDetection firstDetection, double sigma, PsRandom ran, boolean isMotionPureIn2D)
	{
		super( firstDetection );
		this.ran = ran;
		this.sigma = sigma;
		this.isMotionPureIn2D = isMotionPureIn2D;
	}
	
	@Override
	public TGDetection getNextDetection( )
	{
		TGDetection newDetection = new TGDetection(ran.nextGaussian(currentDetection.x, sigma), 
				ran.nextGaussian(currentDetection.y, sigma), 
				(isMotionPureIn2D) ? currentDetection.z : ran.nextGaussian(currentDetection.z, sigma), currentDetection.t+1);
		currentDetection = newDetection;
		return newDetection;
	}
}
