package plugins.fab.trackgenerator;

import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDoubleArray;
import plugins.adufour.ezplug.EzVarFolder;
import plugins.adufour.ezplug.EzVarInteger;

public class TrackingBenchmarkGeneratorGUI extends EzPlug  //implements EzStoppable 
{

	EzVarFolder varFolder = new EzVarFolder("Export folder", "" );
	
	EzVarBoolean enableMicrotubuleComputation = new EzVarBoolean( "Enable Microtubule computation" , true );
	EzVarDoubleArray snrArrayMicrotubule ;
	EzVarDoubleArray densityArrayMicrotubule ;
	EzVarInteger depthMicrotubule = new EzVarInteger("Image depth microtubule" , 1 , 1 , 100 , 1 );	
	
	EzVarBoolean enableVesicleComputationCheckBox = new EzVarBoolean( "Enable Vesicle computation" , true );
	EzVarDoubleArray snrArrayVesicle ;
	EzVarDoubleArray densityArrayVesicle ;
	EzVarInteger depthVesicle = new EzVarInteger("Image depth vesicle" , 1 , 1 , 100 , 1 );
	
	EzVarBoolean enableVirusComputationCheckBox = new EzVarBoolean( "Enable Virus computation" , true );
	EzVarDoubleArray snrArrayVirus ;
	EzVarDoubleArray densityArrayVirus ;
	EzVarInteger depthVirus = new EzVarInteger("Image depth virus" , 10 , 1 , 100 , 1 );
	
	EzVarBoolean enableReceptorComputationCheckBox = new EzVarBoolean( "Enable Receptor computation" , true );
	EzVarDoubleArray snrArrayReceptor ;
	EzVarDoubleArray densityArrayreceptor ;
	EzVarInteger depthReceptor = new EzVarInteger("Image depth receptor" , 1 , 1 , 100 , 1 );
	
	
	
	EzVarInteger randomSeed = new EzVarInteger("Seed", 123456 , 0, 1000000 , 1 );
	EzVarInteger width = new EzVarInteger("Image width" , 512 , 2 , 512*20 , 1 );
	EzVarInteger height =  new EzVarInteger("Image height", 512 , 2 , 512*20 , 1 );
	EzVarInteger length =  new EzVarInteger("Sequence length", 100 , 1 , 100000 , 1 );
	
	@Override
	protected void initialize() {
		
		//varFolder.setToolTipText("Main folder where all benchmark will be exported.");

		Double[][] snrDefaultValues = { new Double[] {1d, 2d, 4d, 7d} };

		Double[][] densityDefaultValues = { new Double[] {100d, 500d, 1000d} };
		Double[][] densityMicrotubuleDefaultValues = { new Double[] { 67d, 430d , 760d } };

		snrArrayMicrotubule = new EzVarDoubleArray("SNR Array microtubule", snrDefaultValues, 0 , true  );
		densityArrayMicrotubule = new EzVarDoubleArray("Density Array microtubule", densityMicrotubuleDefaultValues, 0 , true  );

		snrArrayVesicle = new EzVarDoubleArray("SNR Array Vesicle", snrDefaultValues, 0 , true  );
		densityArrayVesicle = new EzVarDoubleArray("Density Array Vesicle", densityDefaultValues, 0 , true  );

		snrArrayVirus = new EzVarDoubleArray("SNR Array Virus", snrDefaultValues, 0 , true  );
		densityArrayVirus = new EzVarDoubleArray("Density Array Virus", densityDefaultValues, 0 , true  );

		snrArrayReceptor = new EzVarDoubleArray("SNR Array Receptor", snrDefaultValues, 0 , true  );
		densityArrayreceptor = new EzVarDoubleArray("Density Array Receptor", densityDefaultValues, 0 , true  );

		
		
		super.addEzComponent( varFolder );
		
		EzGroup groupCommonValues = new EzGroup("Common values",
				randomSeed, width, height, length 				
				);		
		
		super.addEzComponent(groupCommonValues);

		EzGroup groupBench1 = new EzGroup("Microtubule Scenario", enableMicrotubuleComputation , snrArrayMicrotubule , densityArrayMicrotubule , depthMicrotubule );		
		super.addEzComponent(groupBench1);

		EzGroup groupBench2 = new EzGroup("Vesicle scenario", enableVesicleComputationCheckBox , snrArrayVesicle , densityArrayVesicle , depthVesicle );
		super.addEzComponent(groupBench2);

		EzGroup groupBench3 = new EzGroup("Virus scenario", enableVirusComputationCheckBox , snrArrayVirus , densityArrayVirus ,  depthVirus );
		super.addEzComponent(groupBench3);

		EzGroup groupBench4 = new EzGroup("Receptor scenario", enableReceptorComputationCheckBox , snrArrayReceptor , densityArrayreceptor , depthReceptor );
		super.addEzComponent(groupBench4);		
		
	}

	@Override
	protected void execute() {

		BenchmarkGenerationUtil.startBenchmarkComputation( varFolder.getValue() , 
				
				enableMicrotubuleComputation.getValue(),
				snrArrayMicrotubule.getValue(),
				densityArrayMicrotubule.getValue(),
				depthMicrotubule.getValue(),
				
				enableVesicleComputationCheckBox.getValue(),
				snrArrayVesicle.getValue(),
				densityArrayVesicle.getValue(),
				depthVesicle.getValue(),
				
				enableVirusComputationCheckBox.getValue(),
				snrArrayVirus.getValue(),
				densityArrayVirus.getValue(),
				depthVirus.getValue(),
				
				enableReceptorComputationCheckBox.getValue(),
				snrArrayReceptor.getValue(),
				densityArrayreceptor.getValue(),
				depthReceptor.getValue(),
				
				randomSeed.getValue(),
				width.getValue(),
				height.getValue(),
				length.getValue()
				
				);
		
	}

	@Override
	public void clean() {

		
	}

//	@Override
//	public void stopExecution() {
//
//		
//	}


//	private void startBenchmarkComputation() {
//
//		ArrayList<Double> SNRArrayList = new ArrayList<Double>();
//		SNRArrayList.add( new Double(1) );
//		SNRArrayList.add( new Double(2) );
//		SNRArrayList.add( new Double(3) );
//		SNRArrayList.add( new Double(4) );
//		SNRArrayList.add( new Double(7) );
//
//		ArrayList<Double> densityArrayList = new ArrayList<Double>();
//		densityArrayList.add( new Double(100) );
//		densityArrayList.add( new Double(500) );
//		densityArrayList.add( new Double(1000) );
//
//		PsRandom ran = new PsRandom( 23512345l );
//
//		AnnounceFrame a1 = new AnnounceFrame("Creating microtubule scenario...");		
//		exportScenario_microtubule( ran , "Microtubules" , varFolder.getValue() , SNRArrayList , densityArrayList );
//		a1.close();
//
//		//		AnnounceFrame a2 = new AnnounceFrame("Creating vesicule scenario...");
//		//		exportScenario_vesicule( exportFolderString+File.separator+ "2 vesicles" , SNRArrayList , densityArrayList );
//		//		a2.close();
//		//		
//		//		AnnounceFrame a3 = new AnnounceFrame("Creating virus scenario...");
//		//		exportScenario_viruses( exportFolderString+File.separator+ "3 viruses" , SNRArrayList , densityArrayList );
//		//		a3.close();
//		//		
//		//		AnnounceFrame a4 = new AnnounceFrame("Creating receptor scenario...");
//		//		exportScenario_receptors( exportFolderString+File.separator+ "4 receptors" , SNRArrayList , densityArrayList );
//		//		a4.close();
//
//	}


//	private void exportScenario_microtubule( PsRandom ran , String scenarioName , File exportFolder, ArrayList<Double> SNRArrayList, ArrayList<Double> densityArrayList ) {
//
//		ProgressFrame p = new ProgressFrame( scenarioName );
//
//		// creates the output directory		
//		FileUtil.createDir( exportFolder );
//
//		float stepDone = 0;
//		float allStep = SNRArrayList.size() * densityArrayList.size();
//		p.setPosition( 0 );
//
//		for ( Double snr : SNRArrayList )
//		{
//			for ( Double density : densityArrayList )	
//			{
//				p.setMessage( scenarioName + " scenario : snr: " + snr.intValue() + " density: " + density.intValue() );
//				// create sequence.
//
//				String fileName = scenarioName + " snr "+ snr.intValue() + " density " + density.intValue();
//				String dataSetFolder = exportFolder+FileUtil.separator+scenarioName+FileUtil.separator+ fileName + FileUtil.separator ;
//				//System.out.println("Data set Folder: " + dataSetFolder );
//				FileUtil.createDir( dataSetFolder );
//
//				BenchmarkSequence benchmarkSequence = create_benchmarkSequence( ran, snr, density , CreatorTypes.DIRECTED_MIXED , scenarioName );		
//
//				benchmarkSequence.save( dataSetFolder , new File( dataSetFolder+ fileName + ".xml" ) , dataSetFolder+ fileName );
//
//				stepDone++;
//				p.setPosition( stepDone * 100f / allStep );
//			}
//		}
//
//		p.close();
//
//	}

//	/**
//	 * @deprecated now use the one in TrackGenerationUtil. 
//	 * @param ran
//	 * @param snr
//	 * @param density
//	 * @param creatorType
//	 * @param scenario
//	 * @return
//	 */
//	BenchmarkSequence create_benchmarkSequence( PsRandom ran , double snr, double density , CreatorTypes creatorType , String scenario )
//	{
//		ArrayList<Particle> allParticles = new ArrayList<Particle>();		
//		ArrayList<Particle> activeParticles = new ArrayList<Particle>();
//
//		int sequenceLength = 100;
//		double xyPixelSize = 50d;
//		double sliceSpacing = 300d;		
//
//		int width = 512;
//		int height = 512;
//		int depth = 1;
//		int numberParticles = 100;
//
//		// limits of the simulated volume
//		double xbordersSimu = 100;
//		double ybordersSimu = 100;
//		double zbordersSimu = 20;
//		int warmUpPeriod = 50; // number of frames of simulation before keeping tracks
//
//		double minXSimu = 0 - xbordersSimu;
//		double maxXSimu = width - 1 + xbordersSimu;
//		double minYSimu = 0 - ybordersSimu;
//		double maxYSimu = height -1 + ybordersSimu;
//		double minZSimu = 0 - zbordersSimu;
//		double maxZSimu = depth - 1 + zbordersSimu;
//
//		// parameters for cutting the tracks
//		double minXParticle = 0;
//		double maxXParticle = width - 1;
//		double minYParticle = 0;
//		double maxYParticle = height - 1;
//
//		double halfSizePSF = 3d; // half size of the PSF in pixels
//		double zGap = halfSizePSF * sliceSpacing/xyPixelSize;
//		double minZParticle = - zGap;
//		double maxZParticle = depth - 1 + zGap;
//
//		double volumeCrop = (maxXParticle - minXParticle)*(maxYParticle - minYParticle)*(maxZParticle - minZParticle);
//		if (volumeCrop<=0)
//			throw new IllegalArgumentException("The volume of the crop has to be strictly positive");
//
//		double volumeSimu = (maxXSimu-minXSimu)*(maxYSimu-minYSimu)*(maxZSimu-minZSimu);
//
//		long numberParticlesSimu = (int)Math.round(((double)numberParticles)*volumeSimu/volumeCrop);
//
//		double rate = 0.05d;
//
//		ParticleCreator creator =null;
//		//CreatorTypes creatorType = CreatorTypes.BROWNIAN_UNIFORM;
//		switch (creatorType)
//		{
//		case BROWNIAN_UNIFORM:
//		{
//			double sigma = 2;
//			creator = new BrownianUniformParticleCreator(sigma, new PointSourceShape(), minXSimu, maxXSimu, minYSimu, maxYSimu, minZSimu, maxZSimu, ran);
//			break;
//		}
//		case SWITCHING_UNIFORM:
//		{
//			double q1 = 1;
//			double Vmin = 1;
//			double Vmax = 5;
//			double sigmaBrownian = 2;
//			double probaDirectedBrownian = 0.3;
//			double probaBrownianDirected = 0.3;
//			creator = new SwitchingUniformParticleCreator(q1, Vmin, Vmax, sigmaBrownian, probaDirectedBrownian, probaBrownianDirected, new PointSourceShape(), minXSimu, maxXSimu, minYSimu, maxYSimu, minZSimu, maxZSimu, ran);
//			break;
//		}
//		case DIRECTED_MIXED:
//		{
//			double q1 = 1;
//			double Vmin = 1;
//			double Vmax = 5;
//			creator = new DirectedMotionMixedParticleCreator(q1, Vmin, Vmax, new MicrotubuleShape(), minXSimu, maxXSimu, minYSimu, maxYSimu, minZSimu, maxZSimu, ran);
//			break;
//		}
//		default:
//		{
//			throw new IllegalArgumentException("Invalid creator type");
//		}
//		}
//
//		ParticleCreatorAndTerminator creatorTerminator = new  PoissonBernouilliTrackManager(creator, rate, rate*numberParticlesSimu, ran);
//		creatorTerminator.createInitialTracks(numberParticles, activeParticles, allParticles);
//
//
//
//		for (int t = 1; t < sequenceLength-1 + warmUpPeriod; t++)
//		{
//			//	System.out.println(activeParticles.size());
//			for (Particle p :activeParticles)
//				p.move();
//			creatorTerminator.createAndTerminate(activeParticles, allParticles, t);
//		}
//
//		// cut tracks in the warm up period
//		cutWarmupPeriod(allParticles, warmUpPeriod);
//
//		// cut the tracks so that they cannot re-enter the volume after quitting it
//		// delete the tracks that are only staying outside the image
//		// cut the tracks that are born outside the image but enter it after a delay		
//		allParticles = cropAndcutTracks(allParticles, minXParticle, maxXParticle, minYParticle, maxYParticle, minZParticle, maxZParticle);
//
//		// rescale target position according to the pixel size
//		rescaleZCoordinate(allParticles, xyPixelSize, sliceSpacing);
//
//		// delete short tracks
//		int minTrackLength = 2;
//		int maxTrackLength = Integer.MAX_VALUE;
//		allParticles = lengthBasedSelection(allParticles, minTrackLength, maxTrackLength);
//
//		// ------------------------------------------------------- 
//		// create an image from the set of Particles
//		// ------------------------------------------------------- 
//
//		ArrayList<VolumeImage> volumeImageList = new ArrayList<VolumeImage>();
//
//		//ArrayList<byte[]> imageList = new ArrayList<byte[]>();
//
//		for ( int i = 0 ; i < sequenceLength ; i++ )
//		{
//			//byte data [] = new byte[width*height];
//			VolumeImage vi = new VolumeImage();
//			vi.imageData = new byte[1][width*height];
//			volumeImageList.add( vi );
//			//imageList.add( data );
//		}
//
//		for (Particle p:allParticles)
//		{
//			for (TGDetection d: p.detectionArrayList)
//			{					
//				//byte data[] = imageList.get(d.t);
//				byte data[][] = volumeImageList.get(d.t).imageData;
//				int x = (int)Math.round( d.x );
//				int y = (int)Math.round( d.y );
//				if ( x >= 0 && x < width && y >=0 && y< height )
//				{
//					data[0][x+y*width] = (byte)255;
//				}
//			}
//		}
//
//		// display
//
//		//DisplayTools.displayImage( imageList , width , height , allParticles );
//		//DisplayTools.displayImage( imageList , width , height );
//
//		// ---------------------------------
//
//
//		BenchmarkSequence benchmarkSequence = new BenchmarkSequence();
//		benchmarkSequence.particleArrayList = allParticles;
//		benchmarkSequence.volumeImageList = volumeImageList;
//		benchmarkSequence.width = width;
//		benchmarkSequence.height = height;
//		benchmarkSequence.snr = snr;
//		benchmarkSequence.density = density;
//		benchmarkSequence.scenario = scenario;
//
//		// TODO.
//		// benchmarkSequence.volumeImageList =
//
//		return benchmarkSequence;
//	}
//
//
//	public ArrayList<Particle> cropAndcutTracks(ArrayList<Particle> allParticles, double minXParticle, double maxXParticle, double minYParticle, double maxYParticle, double minZParticle, double maxZParticle)
//	{
//		ArrayList<Particle> cleanSet = new ArrayList<Particle>();
//		for (Particle p:allParticles)
//		{
//			Particle newParticle = null;
//			for (TGDetection d:p.detectionArrayList)
//			{
//				double x = d.x;
//				double y = d.y;
//				double z = d.z;
//				if ( x >= minXParticle && x <= maxXParticle && y >=minYParticle && y<= maxYParticle && z >=minZParticle && z <=maxZParticle)
//				{
//					if (newParticle == null)
//					{
//						newParticle = new Particle(p.shape, null);
//						newParticle.detectionArrayList.add(d);
//					}
//					else
//					{
//						newParticle.detectionArrayList.add(d);
//					}
//				}
//				else
//				{
//					if (newParticle != null)
//					{
//						// cut the track as it has went out of the image
//						break;
//					}
//				}
//			}
//			if (newParticle!=null)
//			{
//				cleanSet.add(newParticle);
//			}
//		}		
//		return cleanSet;
//	}
//
//	public void cutWarmupPeriod(ArrayList<Particle> allParticles, int warmUpPeriod) {
//
//		ArrayList<Particle> cloneParticles = (ArrayList<Particle>) allParticles.clone();
//		for (Particle p:cloneParticles)
//		{
//			if (p.detectionArrayList.get(0).t>=warmUpPeriod)
//			{
//				for (TGDetection d:p.detectionArrayList)
//					d.t = d.t - warmUpPeriod;
//			}
//			else
//			{
//				if (p.detectionArrayList.get(p.detectionArrayList.size()-1).t>=warmUpPeriod)
//				{
//					// we have to cut the particle trajectory
//					ArrayList<TGDetection> cloneDetectionList = (ArrayList<TGDetection>) p.detectionArrayList.clone();
//					p.detectionArrayList.clear();
//					for (TGDetection d:cloneDetectionList)
//					{
//						if (d.t>=warmUpPeriod)
//							p.detectionArrayList.add(d);
//					}
//					for (TGDetection d:p.detectionArrayList)
//						d.t = d.t - warmUpPeriod;
//				}
//				else
//					allParticles.remove(p);
//			}
//		}
//	}
//
//	public void rescaleZCoordinate(ArrayList<Particle> allParticles, double xyPixelSize, double zPixelSize)
//	{
//		double scalingFactor = xyPixelSize/zPixelSize;
//		for (Particle p:allParticles)
//			for (TGDetection d:p.detectionArrayList)
//				d.z = d.z*scalingFactor;
//	}
//
//	public ArrayList<Particle> lengthBasedSelection(ArrayList<Particle> allParticles, int minTrackLength, int maxTrackLength)
//	{
//		ArrayList<Particle> subset = new ArrayList<Particle>();
//		for (Particle p:allParticles)
//			if (p.detectionArrayList.size()>=minTrackLength && p.detectionArrayList.size()<=maxTrackLength)
//				subset.add(p);
//		return subset;
//	}
	
	
}
