package plugins.lagache.multipleintersection;


import icy.plugin.abstract_.Plugin;

import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.util.ShapeUtil.BooleanOperator;


import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;

// Colocalisation with Ripley function K
// Significant 

public class intersection extends Plugin implements Block {
	
	VarROIArray	rois_1		= new VarROIArray("List of ROIs 1");
	VarROIArray	rois_2		= new VarROIArray("List of ROIs 1");
	
	VarROIArray	rois_1_intersect		= new VarROIArray("Intersection between ROIs 1 and ROIs 2");

	VarDouble threshold = new VarDouble("threshold", 0.1);
	VarSequence	sequence	= new VarSequence("Target sequence", null);

	VarBoolean	replace		= new VarBoolean("Replace existing ROI", false);

	@Override
	public void run()
	{
	    Sequence s = sequence.getValue(true);	    		
	    double t=threshold.getValue();

	    //calcul de l'umion des ROIs 2
	    ROI union=null;
	    
		if (replace.getValue())
			s.removeAllROI();

			for (ROI roi2 : rois_2.getValue(true))
	    {
	    	if (union == null) union = roi2;
	    	else union=roi2.merge(union, BooleanOperator.OR);
	    }
	    		
		for (ROI roi1 : rois_1.getValue(true))
		{
			ROI r=roi1.merge(union, BooleanOperator.AND);
			double f=r.getNumberOfPoints();
			double f_1=roi1.getNumberOfPoints();
			if (f>(t*f_1))
			{
			rois_1_intersect.add(r);
			s.addROI(r);
			}
			}
				
	}

	@Override
	public void declareInput(VarList inputMap)
	{
		inputMap.add("input rois 1", rois_1);
		inputMap.add("input rois 2", rois_2);
		inputMap.add("threshold", threshold);
		inputMap.add("target sequence", sequence);
		inputMap.add("replace existing", replace);
	}

	@Override
	public void declareOutput(VarList outputMap)
	{
		outputMap.add("input rois 1 after intersection with rois 2", rois_1_intersect);

	}
}
