package plugins.nchenouard.detectionresultimportandexport;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

import plugins.nchenouard.spot.DetectionResult;
import plugins.nchenouard.spot.Spot;

import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.main.Icy;
import icy.plugin.abstract_.PluginActionable;
import icy.swimmingPool.SwimmingObject;

public class DetectionResultImportAndExport extends PluginActionable implements ActionListener
{

	IcyFrame mainFrame;
	JTabbedPane mainPanel;
	JButton chooseFileButton;
	JTextField importFileTF;
	JButton importButton;
	DetectionChooser detectionChooser;
	JButton chooseFileButton2;
	JButton exportButton;
	JTextField exportFileTF;

	File outputFile = null;
	File inputFile = null;
	
	Thread runningThread = null;
	AnnounceFrame runningFrame = null;
	
	@Override
	public void run()
	{
		mainPanel = new JTabbedPane();

		JPanel importPanel = new JPanel();
		mainPanel.add(importPanel, "Import");
		JPanel exportPanel = new JPanel();
		mainPanel.add(exportPanel, "Export");


		importPanel.setLayout(new GridLayout(3, 1));
		importPanel.add(new JLabel("Import results from file:"));
		JPanel fileImportPanel = new JPanel(new BorderLayout());
		chooseFileButton = new JButton("Choose file");
		fileImportPanel.add(chooseFileButton, BorderLayout.WEST);
		importFileTF = new JTextField("");
		importFileTF.setColumns(20);
		importFileTF.setEditable(false);
		fileImportPanel.add(importFileTF, BorderLayout.CENTER);
		importPanel.add(fileImportPanel);
		importButton = new JButton("Import results");
		importPanel.add(importButton);


		exportPanel.setLayout(new GridLayout(3, 1));
		detectionChooser = new DetectionChooser();
		detectionChooser.setToolTipText("Select the detection results to export here.");
		exportPanel.add(detectionChooser);
		//		exportPanel.add(new JLabel("Export to file:"));
		JPanel fileExportPanel = new JPanel(new BorderLayout());
		chooseFileButton2 = new JButton("Choose file");
		fileExportPanel.add(chooseFileButton2, BorderLayout.WEST);
		exportFileTF = new JTextField("");
		exportFileTF.setEditable(false);
		fileExportPanel.add(exportFileTF, BorderLayout.CENTER);
		exportPanel.add(fileExportPanel);
		exportButton = new JButton("Export results");
		exportPanel.add(exportButton);


		chooseFileButton.addActionListener(this);
		importButton.addActionListener(this);
		chooseFileButton2.addActionListener(this);
		exportButton.addActionListener(this);

		mainFrame = new IcyFrame("Detection results", true, true, true, true);
		mainFrame.getContentPane().add(mainPanel);
		mainFrame.pack();
		addIcyFrame(mainFrame);
		mainFrame.setVisible(true);
	}

	@Override
	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource() == chooseFileButton)
		{
			final JFileChooser fc = new JFileChooser();
			int returnVal = fc.showOpenDialog(mainPanel);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				File file = fc.getSelectedFile();
				if (file != null)
				{
					importFileTF.setText(file.getPath());
					inputFile = file;
				}
			}
		}
		if (e.getSource() == chooseFileButton2)
		{
			final JFileChooser fc = new JFileChooser();
			fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
			fc.setMultiSelectionEnabled(false);
			int returnVal = fc.showOpenDialog(mainPanel);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				File file = fc.getSelectedFile();
				if (file != null)
				{
					exportFileTF.setText(file.getPath());
					outputFile = file;
				}
			}
		}
		if (e.getSource() == importButton && inputFile != null)
		{
			runningThread = new Thread()
			{
				@Override
				public void run()
				{
					runningFrame = new AnnounceFrame("Import started");
					if (importResultsFromFileToPool(inputFile))
						new AnnounceFrame("Import succeded", 10);
					else
						new AnnounceFrame("Import failed", 10);
					runningFrame.close();
				}
			};
			runningThread.start();
		}
		if (e.getSource() == exportButton && outputFile != null)
		{
			final DetectionResult dr = detectionChooser.getSelectedDetectionResult();
			if (dr != null)
			{
				runningThread = new Thread()
				{
					@Override
					public void run()
					{
						runningFrame = new AnnounceFrame("Export started");
						if (exportResultsToFile(outputFile, dr))
							new AnnounceFrame("Export succeded", 10);
						else
							new AnnounceFrame("Export failed", 10);
						runningFrame.close();
					}
				};
				runningThread.start();
			}
		}
	}

	public static boolean exportResultsToFile(File f, DetectionResult dr) {
		try {
			BufferedWriter out = new BufferedWriter(new FileWriter(f));
			for (int t = dr.getFirstFrameTime(); t <= dr.getLastFrameTime(); t++)
			{
				for (Spot s:dr.getDetectionsAtT(t))
					out.write(t + " "+ s.mass_center.x + " " + s.mass_center.y + " " + s.mass_center.z + " " + s.meanIntensity + " " + s.minIntensity + " " + s.maxIntensity + "\n");
			}
			out.close();
		} catch (IOException e)
		{
			e.printStackTrace();
			return false;
		}
		return true;
	}

	public static boolean importResultsFromFileToPool(File f)
	{
		DetectionResult dr = importResultsFromFile(f);
		if (dr == null)
			return false;
		else
		{
			Icy.getMainInterface().getSwimmingPool().add(new SwimmingObject(dr, "Detection results from "+f.getName()));
			return true;
		}
	}

	public static DetectionResult importResultsFromFile(File f)
	{
		DetectionResult dr = new DetectionResult();
		try {
			BufferedReader out = new BufferedReader(new FileReader(f));
			try {
				String s;
				s = out.readLine();
				while(s != null)
				{
					String[] sTab = s.split(" ");
					Spot spot = new Spot();
					int t = 0;
					if (sTab.length > 0)
					{
						int idx = 0;
						t = Integer.parseInt(sTab[idx]);
						idx ++;
						if (sTab.length > idx)
						{
							spot.mass_center.x = Double.parseDouble(sTab[idx]);
							idx ++;
							if (sTab.length > idx)
							{
								spot.mass_center.y = Double.parseDouble(sTab[idx]);
								idx ++;
								if (sTab.length > idx)
								{
									spot.mass_center.z = Double.parseDouble(sTab[idx]);
									idx ++;
									if (sTab.length > idx)
									{
										spot.meanIntensity = Double.parseDouble(sTab[idx]);
										idx ++;
										if (sTab.length > idx)
										{
											spot.minIntensity = Double.parseDouble(sTab[idx]);
											idx ++;
											if (sTab.length > idx)
											{
												spot.maxIntensity = Double.parseDouble(sTab[idx]);
												idx ++;
											}
										}
									}
								}
							}
						}
						dr.addDetection(t, spot);
					}
					s = out.readLine();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
			out.close();
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
		return dr;
	}

}
