package plugins.fab.mapoverlay;

import java.awt.geom.Point2D;
import java.util.ArrayList;

public class Anchor2D extends icy.painter.Anchor2D {

	Point2D.Double previousPosition ;
	ArrayList<Anchor2D> linkedAnchor2D = new ArrayList<Anchor2D>();
	
	public Anchor2D(double x, double y) {

		super(x, y);			
		previousPosition = new Point2D.Double( x , y );
		
	}
	
	/**
	 * A linked anchor will be moved (or shifted) in x,y the same way this answer is moved.
	 * @param anchor2D
	 */
	public void linkToAnchor2D( Anchor2D anchor2D )
	{
		linkedAnchor2D.add( anchor2D );
	}
	
	@Override
    public void setPosition(double x, double y)
    {
        if ((position.x != x) || (position.y != y))
        {
        	position.x = x;
            position.y = y;

            double shiftX = position.x - previousPosition.x;
            double shiftY = position.y - previousPosition.y;
            
            previousPosition.x = x;
            previousPosition.y = y;
            
            for ( Anchor2D anchor : linkedAnchor2D )
            {
            	anchor.translate( shiftX , shiftY );
            }
            
            positionChanged();
            painterChanged();
        }
    }
	
	

	
	
}
