package plugins.fab.mapoverlay;

import icy.gui.frame.progress.AnnounceFrame;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;

public class MapOverlayAtlas extends EzPlug implements EzVarListener<Boolean> {

	EzVarSequence overlaySequenceTarget = new EzVarSequence("Draw on sequence");
	EzVarSequence overlaySequenceSource = new EzVarSequence("Source sequence");

	EzVarBoolean drawGrid = new EzVarBoolean("Draw grid", true );
	EzVarBoolean drawImage = new EzVarBoolean("Draw image", false );
	EzVarBoolean copyROIs = new EzVarBoolean("Copy ROIs", true );
	MapOverlay p;
	
	@Override
	protected void execute() {

		try
		{
			p =  new MapOverlay( overlaySequenceTarget.getValue(), overlaySequenceSource.getValue() , getActiveImage() );		

			p.drawImage = drawImage.getValue();
			p.drawGrid = drawGrid.getValue();
			p.copyROIs = copyROIs.getValue();

			overlaySequenceTarget.getValue().addOverlay( p );		

			drawGrid.addVarChangeListener( this );
			drawImage.addVarChangeListener( this );
			copyROIs.addVarChangeListener( this );
		}
		catch( IllegalArgumentException e )
		{
			new AnnounceFrame("The 2 sequences are the same. They should not.");
		}
		
	}

	@Override
	protected void initialize() {

		addEzComponent( overlaySequenceSource );
		addEzComponent( overlaySequenceTarget );

		addEzComponent( drawGrid );
		addEzComponent( drawImage );
		addEzComponent( copyROIs );
		
	}

	
	@Override
	public void clean() {		
	}

	@Override
	public void variableChanged(EzVar<Boolean> source, Boolean newValue) {
	
		if ( p == null ) return;
		
		if ( source == drawGrid )
		{
			p.setDrawGrid( drawGrid.getValue() );
		}
		if ( source == drawImage )
		{
			p.setDrawImage( drawImage.getValue() );
		}
		if ( source == copyROIs )
		{
			p.setCopyROIs( copyROIs.getValue() );
		}
	}
	
}
