package plugins.lagache.circularityfilter;

import icy.gui.frame.progress.AnnounceFrame;
import icy.plugin.abstract_.Plugin;

import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.util.ShapeUtil.BooleanOperator;


import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;

// Colocalisation with Ripley function K
// Significant 

public class circularity extends Plugin implements Block {
	
	VarROIArray	rois_input		= new VarROIArray("Input ROIs");
	
	
	VarROIArray	rois_output		= new VarROIArray("Output ROIs");

	VarDouble min_threshold = new VarDouble("min_threshold", 0);
	VarDouble max_threshold = new VarDouble("max_threshold", 1);
	


	@Override
	public void run()
	{
		    		
	    double min_t=min_threshold.getValue();
	    double max_t=max_threshold.getValue();
	    if (min_t>max_t)
	    {
	    	new AnnounceFrame("The min circularity threshold must be less than the max threshold");
			return;
	    }
	    if (min_t<0 || max_t>1)
	    {
	    	new AnnounceFrame("Min and max thresholds must be comprised between 0 (line) and 1 (perfect circles)");
			return;
	    }
	    if (rois_input.getValue(true)==null)
	    {
	    	new AnnounceFrame("The input list of ROIs is empty");
			return;
	    }

	    
		for (ROI roi : rois_input.getValue(true))
	    {
			//calcul de la circularity des rois
			double perimeter=roi.getNumberOfContourPoints();
			double area=roi.getNumberOfPoints();
			
			double circularity=Math.PI*(area-perimeter)/Math.pow(perimeter, 2);//=1 for disks
	    	if (circularity>min_t & circularity<max_t)
	    	{rois_output.add(roi);}	    
	    }
	    								
	}

	@Override
	public void declareInput(VarList inputMap)
	{
		inputMap.add("input rois", rois_input);		
		inputMap.add("min threshold", min_threshold);
		inputMap.add("max threshold", max_threshold);		
	}

	@Override
	public void declareOutput(VarList outputMap)
	{
		outputMap.add("output ROIs", rois_output);

	}
}
