package plugins.fab.aggregatesdetector;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

import icy.roi.ROI;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.util.XLSUtil;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.roi.LabelExtractor;
import plugins.adufour.roi.LabelExtractor.ExtractionType;
import plugins.adufour.thresholder.Thresholder;

public class AggregatesDetector extends EzPlug {

	EzVarInteger thresholdComponent = new EzVarInteger("Threshold", 3000, 0, Integer.MAX_VALUE , 1 );
	EzVarInteger channelComponent = new EzVarInteger("Channel",0, 0, 10 , 1 );
	EzVarInteger minVolumeComponent = new EzVarInteger("Min volume",10, 0, Integer.MAX_VALUE , 1 );
	
	@Override
	protected void execute() {
		
		double thresholdArray[] = { thresholdComponent.getValue() };
		
		Sequence inputSequence = getActiveSequence();
		int minVolume = minVolumeComponent.getValue();
		
		Sequence thresholdedSequence = Thresholder.threshold( inputSequence, channelComponent.getValue(), thresholdArray , false );
		ArrayList<ROI> roiUserList = new ArrayList<ROI>();
		
		for ( ROI roi : new ArrayList<ROI>(inputSequence.getROIs() ) )
		{
			if ( roi.getColor().equals( Color.GREEN ) )
			{
				roiUserList.add( roi ); // keep user ROI in green
			}else
			{				
				inputSequence.removeROI( roi ); // remove ROI previously created.
			}
		}		
		
		List<ROI> roiDetectedList = LabelExtractor.extractLabels( thresholdedSequence , ExtractionType.ALL_LABELS_VS_BACKGROUND, 0 );
		
		WritableWorkbook workbook= null;
		try {
			workbook = XLSUtil.createWorkbook( new File( inputSequence.getFilename()+".xls" ) );
		} catch (IOException e) {
			e.printStackTrace();
			return;
		}
		
		for ( ROI roiDetected : new ArrayList<ROI>(roiDetectedList) )
		{
			roiDetected.setColor( Color.yellow );			
			if( roiDetected.getNumberOfPoints() >= minVolume ) // filter by volume
			{
				inputSequence.addROI( roiDetected );
			}else
			{
				roiDetectedList.remove( roiDetected );
			}
		}
		
		// list of roi never found in ROIs. Starts from a full copy and then roi found are removed.
		ArrayList<ROI> roiNotInAnyROI= new ArrayList<ROI>( roiDetectedList );
		
		WritableSheet detailResultSheet = XLSUtil.createNewPage(workbook, "detailed results" );
		WritableSheet overviewSheet = XLSUtil.createNewPage(workbook, "overview" );
		
		int rowDetail = 0;
		int rowOverview = 0;
		
		XLSUtil.setCellString(detailResultSheet, 0, rowOverview, "ROI Name" );
		XLSUtil.setCellString(detailResultSheet, 1, rowOverview, "Number of detection" );
		rowOverview+=2;
		
		for ( ROI roiUser : roiUserList )
		{
			XLSUtil.setCellString(detailResultSheet, 0, rowDetail, "ROI:" );
			XLSUtil.setCellString(detailResultSheet, 1, rowDetail, roiUser.getName() );
			rowDetail++;
			XLSUtil.setCellString(detailResultSheet, 0, rowDetail, "#detection number" );
			XLSUtil.setCellString(detailResultSheet, 1, rowDetail, "nbPixels" );			
			rowDetail+=2;
			
			XLSUtil.setCellString(overviewSheet, 0, rowOverview, roiUser.getName() );
			int numberOfDetectionInROI = 0;
			
			System.out.println("ROI USER: " + roiUser.getBounds5D() );
			
			int roiNumber = 0;
			for ( ROI roiDetected : roiDetectedList )
			{
				System.out.println("ROI DETECTED: " + roiDetected.getBounds5D() );
				ROI intersect = roiDetected.getIntersection( roiUser );
				if ( !intersect.getBounds5D().isEmpty() )
				{		
					System.out.println("intersects");
					roiNumber++;
					XLSUtil.setCellNumber(detailResultSheet, 0, rowDetail, roiNumber );
					XLSUtil.setCellNumber(detailResultSheet, 1, rowDetail, ROIUtil.getNumPixel( inputSequence, roiDetected ) );
					roiNotInAnyROI.remove( roiDetected );
					rowDetail++;
					numberOfDetectionInROI++;					
				}
			}
			rowDetail+=2;

			XLSUtil.setCellNumber(overviewSheet, 1, rowOverview, numberOfDetectionInROI );			

			rowOverview++;

		}

		// detection out of rois
		
		{
			XLSUtil.setCellString(detailResultSheet, 0, rowDetail, "Detection outside ROIs" );		
			rowDetail++;
			XLSUtil.setCellString(detailResultSheet, 0, rowDetail, "#" );
			XLSUtil.setCellString(detailResultSheet, 1, rowDetail, "nbPixels" );			
			rowDetail+=2;
			
			XLSUtil.setCellString(overviewSheet, 0, rowOverview, "Detection outside ROIs" );
			XLSUtil.setCellNumber(overviewSheet, 1, rowOverview, roiNotInAnyROI.size() );			

			int roiNumber=0;
			for ( ROI roiDetected : roiNotInAnyROI )
			{
				roiNumber++;
				XLSUtil.setCellNumber(detailResultSheet, 0, rowDetail, roiNumber );
				XLSUtil.setCellNumber(detailResultSheet, 1, rowDetail, ROIUtil.getNumPixel( inputSequence, roiDetected ) );
				rowDetail++;
			}
		}
		
		
		try {
			XLSUtil.saveAndClose( workbook );
		} catch (WriteException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	@Override
	protected void initialize() {
		addEzComponent( thresholdComponent );
		addEzComponent( channelComponent );
		addEzComponent( minVolumeComponent );		
	}

	@Override
	public void clean() {
		
	}

}
