/*
 * Decompiled with CFR 0.152.
 */
package psf.defocusplane.lateral;

import psf.defocusplane.lateral.LateralFunction;

public class Cosine
extends LateralFunction {
    private double freq = 1.5707963267948966;
    private double size = 1.0;

    public Cosine(double radius, double defocusFactor) {
        this.size = radius * defocusFactor;
    }

    public double eval(double x, double y) {
        if (this.size < 1.0E-7) {
            return 0.0;
        }
        double r = Math.sqrt(x * x + y * y) / this.size;
        return Math.max(0.0, Math.cos(r * this.freq));
    }
}

