/*
 * Decompiled with CFR 0.152.
 */
package psf.defocusplane.lateral;

import psf.defocusplane.lateral.LateralFunction;

public class DoubleHelix
extends LateralFunction {
    private double radius;
    private double sigma;
    private double kgauss;
    private double cosa;
    private double sina;

    public DoubleHelix(double radius, double defocusFactor) {
        this.radius = radius;
        this.sigma = 0.25 * radius;
        this.kgauss = 1.0 / (this.sigma * this.sigma * 2.0);
        this.cosa = Math.cos(defocusFactor);
        this.sina = Math.sin(defocusFactor);
    }

    public double eval(double x, double y) {
        double u = x * this.cosa + y * this.sina;
        double v = -x * this.sina + y * this.cosa;
        double u1 = u - this.radius * 0.5;
        double u2 = u + this.radius * 0.5;
        return Math.exp(-((u1 * u1 + v * v) * this.kgauss)) + Math.exp(-((u2 * u2 + v * v) * this.kgauss));
    }
}

