/*
 * Decompiled with CFR 0.152.
 */
package psf.vri_gibsonlanni;

import bilib.commons.gui.GridToolbar;
import bilib.commons.gui.SpinnerDouble;
import bilib.commons.job.runnable.Job;
import bilib.commons.job.runnable.Pool;
import bilib.commons.settings.Settings;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import psf.PSF;
import psf.vri_gibsonlanni.KirchhoffDiffractionSimpson;
import psf.vri_gibsonlanni.VRIGLParameters;

public class VRIGLPSF
extends PSF {
    private double ni_Default = 1.5;
    private double ng_Default = 1.5;
    private double ns1_Default = 1.33;
    private double ns2_Default = 1.4;
    private double ti_Default = 150.0;
    private double tg_Default = 170.0;
    private double zpos_Default = 2000.0;
    private SpinnerDouble spnNI = new SpinnerDouble(this.ni_Default, 0.0, 3.0, 0.1);
    private SpinnerDouble spnNG = new SpinnerDouble(this.ng_Default, 0.0, 3.0, 0.1);
    private SpinnerDouble spnNS1 = new SpinnerDouble(this.ns1_Default, 0.0, 3.0, 0.1);
    private SpinnerDouble spnNS2 = new SpinnerDouble(this.ns2_Default, 0.0, 3.0, 0.1);
    private JComboBox cmbRIvary = new JComboBox<String>(new String[]{"Linear", "Logrithmic", "Exponential"});
    private SpinnerDouble spnTI = new SpinnerDouble(this.ti_Default, 0.0, 9999.0, 100.0);
    private SpinnerDouble spnTG = new SpinnerDouble(this.tg_Default, 0.0, 9999.0, 100.0);
    private SpinnerDouble spnZPos = new SpinnerDouble(this.zpos_Default, -999999.0, 999999.0, 10.0);
    private JComboBox cmbAccuracy = new JComboBox<String>(new String[]{"Good", "Better", "Best"});
    protected VRIGLParameters p;
    VRIGL[] gb;
    public int accuracy = 0;

    public VRIGLPSF() {
        this.fullname = "Variable Refractive Index Gibson & Lanni";
        this.shortname = "VRIGL";
        this.p = new VRIGLParameters();
    }

    public void resetParameters() {
        this.spnNI.set(this.ni_Default);
        this.spnNG.set(this.ng_Default);
        this.spnNS1.set(this.ns1_Default);
        this.spnNS2.set(this.ns2_Default);
        this.spnTI.set(this.ti_Default);
        this.spnTG.set(this.tg_Default);
        this.spnZPos.set(this.zpos_Default);
        this.cmbAccuracy.setSelectedIndex(0);
    }

    public void fetchParameters() {
        this.p.ni = this.spnNI.get();
        this.p.ng = this.spnNG.get();
        this.p.ns1 = this.spnNS1.get();
        this.p.ns2 = this.spnNS2.get();
        this.p.type = this.cmbRIvary.getSelectedIndex();
        this.p.ti0 = this.spnTI.get() * 1.0E-6;
        this.p.tg0 = this.spnTG.get() * 1.0E-6;
        this.p.particleAxialPosition = this.spnZPos.get() * 1.0E-9;
        this.accuracy = this.cmbAccuracy.getSelectedIndex();
    }

    public JPanel buildPanel(Settings settings) {
        GridToolbar pn = new GridToolbar(false, 1);
        pn.place(2, 0, "Refr. Index Immersion");
        pn.place(3, 0, "Refr. Index Sample at 0");
        pn.place(4, 0, "Refr. Index Sample at Zp");
        pn.place(5, 0, "Refr. Index Variation");
        pn.place(6, 0, "Working distance (ti)");
        pn.place(11, 0, "Particle position Zp");
        pn.place(14, 0, "Accuracy computation");
        pn.place(2, 1, this.spnNI);
        pn.place(3, 1, this.spnNS1);
        pn.place(4, 1, this.spnNS2);
        pn.place(5, 1, this.cmbRIvary);
        pn.place(6, 1, this.spnTI);
        pn.place(11, 1, this.spnZPos);
        pn.place(14, 1, this.cmbAccuracy);
        pn.place(1, 2, "<html>[nm]</html>");
        pn.place(2, 2, "<html>n<sub>i</sub></html>");
        pn.place(3, 2, "<html>n<sub>s0</sub></html>");
        pn.place(4, 2, "<html>n<sub>sz</sub></html>");
        pn.place(6, 2, "<html>[&mu;m]</html>");
        pn.place(11, 2, "<html>[nm]</html>");
        JPanel panel = new JPanel();
        panel.add(pn);
        settings.record("psf-" + this.shortname + "-NI", this.spnNI, "" + this.ni_Default);
        settings.record("psf-" + this.shortname + "-NG", this.spnNG, "" + this.ng_Default);
        settings.record("psf-" + this.shortname + "-NS1", this.spnNS1, "" + this.ns1_Default);
        settings.record("psf-" + this.shortname + "-NS2", this.spnNS2, "" + this.ns2_Default);
        settings.record("psf-" + this.shortname + "-RIvary", this.cmbRIvary, "Linear");
        settings.record("psf-" + this.shortname + "-TI", this.spnTI, "" + this.ti_Default);
        settings.record("psf-" + this.shortname + "-TG", this.spnTG, "" + this.tg_Default);
        settings.record("psf-" + this.shortname + "-ZPos", this.spnZPos, "" + this.zpos_Default);
        settings.record("psf-" + this.shortname + "-accuracy", this.cmbAccuracy, (String)this.cmbAccuracy.getItemAt(0));
        return panel;
    }

    public String checkSize(int nx, int ny, int nz) {
        if (nz < 3) {
            return "nz should be greater than 3.";
        }
        if (nx < 4) {
            return "nx should be greater than 4.";
        }
        if (ny < 4) {
            return "ny should be greater than 4.";
        }
        return "";
    }

    public void generate(Pool pool) {
        int z = 0;
        while (z < this.nz) {
            VRIGLParameters param = new VRIGLParameters(this.p);
            param.ti = this.p.ti0 + this.resAxial * 1.0E-9 * ((double)z - ((double)this.nz - 1.0) / 2.0);
            VRIGL plane = new VRIGL(param, z);
            plane.addMonitor(this);
            pool.register(plane);
            ++z;
        }
    }

    public String getDescription() {
        return "<h1>Variable Refractive Index G&L</h1><p>Author:Sameer Hiware, IIT Bombay, India<p>";
    }

    public class VRIGL
    extends Job {
        private int OVER_SAMPLING = 2;
        private VRIGLParameters p;
        private int z;

        public VRIGL(VRIGLParameters p, int z) {
            this.z = z;
            this.p = p;
        }

        public void process() {
            double x0 = (double)(VRIGLPSF.this.nx - 1) / 2.0;
            double y0 = (double)(VRIGLPSF.this.ny - 1) / 2.0;
            double xp = x0;
            double yp = y0;
            int maxRadius = (int)Math.round(Math.sqrt(((double)VRIGLPSF.this.nx - x0) * ((double)VRIGLPSF.this.nx - x0) + ((double)VRIGLPSF.this.ny - y0) * ((double)VRIGLPSF.this.ny - y0))) + 1;
            double[] r = new double[maxRadius * this.OVER_SAMPLING];
            double[] h = new double[r.length];
            KirchhoffDiffractionSimpson I = new KirchhoffDiffractionSimpson(this.p, VRIGLPSF.this.accuracy, this.z, VRIGLPSF.this.resLateral, VRIGLPSF.this.resAxial);
            int n = 0;
            while (n < r.length) {
                r[n] = (double)n / (double)this.OVER_SAMPLING;
                h[n] = I.calculate(r[n] * VRIGLPSF.this.resLateral * 1.0E-9);
                if (!this.live) {
                    return;
                }
                ++n;
            }
            double[] slice = new double[VRIGLPSF.this.nx * VRIGLPSF.this.ny];
            int x = 0;
            while (x < VRIGLPSF.this.nx) {
                int y = 0;
                while (y < VRIGLPSF.this.ny) {
                    double value;
                    double rPixel = Math.sqrt(((double)x - xp) * ((double)x - xp) + ((double)y - yp) * ((double)y - yp));
                    int index = (int)Math.floor(rPixel * (double)this.OVER_SAMPLING);
                    slice[x + VRIGLPSF.this.nx * y] = value = h[index] + (h[index + 1] - h[index]) * (rPixel - r[index]) * (double)this.OVER_SAMPLING;
                    ++y;
                }
                if (!this.live) {
                    return;
                }
                ++x;
            }
            VRIGLPSF.this.setPlane(this.z, slice);
            this.increment(90.0 / (double)VRIGLPSF.this.nz, this.z + " / " + VRIGLPSF.this.nz);
        }
    }
}

