/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.smarttable;

public class SmartFormat {
    private double LOG1000 = Math.log(1000.0);
    private String[] prefix = new String[]{"Y", "Z", "E", "P", "T", "G", "M", "K", " ", "m", "u", "n", "p", "f", "a", "z", "y"};
    public static int INTEGER = 0;
    public static int CLIKE = 1;
    public static int DECIMAL = 2;
    public static int SCIENTIFIC = 3;
    public static int ENGINEER = 4;
    public static int SYMBOLIC = 5;
    public int decimal = 3;
    public String clike = "%3.3f";
    public String unit = "";
    public int type = DECIMAL;
    public boolean withUnit = false;

    public SmartFormat(int type) {
        this.type = type;
    }

    public SmartFormat(int type, String unit) {
        this.type = type;
        this.unit = unit;
    }

    public SmartFormat(int type, int decimal) {
        this.type = type;
        this.decimal = decimal;
    }

    public SmartFormat(int type, int decimal, String unit) {
        this.type = type;
        this.decimal = decimal;
        this.unit = unit;
    }

    public void setClikeFormat(String clike) {
        this.clike = clike;
        this.type = CLIKE;
    }

    public String format(Double d) {
        return this.format((double)d);
    }

    public String format(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return "" + d;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "" + d;
        }
        if (d == Double.NaN) {
            return "" + d;
        }
        if (this.type == INTEGER) {
            return String.valueOf(String.format("%.0f", d)) + " " + this.unit;
        }
        if (this.type == DECIMAL) {
            return String.valueOf(String.format("%." + this.decimal + "f", d)) + " " + this.unit;
        }
        if (this.type == CLIKE) {
            return String.valueOf(String.format(this.clike, d)) + " " + this.unit;
        }
        if (this.type == SCIENTIFIC) {
            return String.valueOf(String.format("%." + this.decimal + "e", d)) + " " + this.unit;
        }
        if (this.type == ENGINEER) {
            return String.valueOf(this.formatEngineer(d)) + " " + this.unit;
        }
        if (this.type == SYMBOLIC) {
            return String.valueOf(this.formatSymbolic(d)) + this.unit;
        }
        return "" + d;
    }

    private String formatEngineer(double value) {
        int e = 3 * (int)Math.round(Math.log(Math.abs(value)) / this.LOG1000);
        double m = value / Math.pow(10.0, e);
        return String.valueOf(String.format("%." + this.decimal + "f", m)) + " E" + String.format("%+-3d", e);
    }

    private String formatSymbolic(double value) {
        int e = (int)Math.round(Math.log(Math.abs(value)) / this.LOG1000);
        double m = value / Math.pow(10.0, 3 * e);
        if (8 - e >= 0 & 8 - e < this.prefix.length) {
            return String.valueOf(String.format("%." + this.decimal + "f", m)) + " " + this.prefix[8 - e];
        }
        return String.valueOf(String.format("%." + this.decimal + "f", m)) + " * 10E" + 3 * e + " ";
    }
}

