/*
 * Decompiled with CFR 0.152.
 */
package psfgenerator;

import bilib.commons.gui.GridPanel;
import bilib.commons.gui.HTMLPane;
import bilib.commons.smarttable.SmartFormat;
import bilib.commons.smarttable.SmartTable;
import bilib.commons.smarttable.SmartTableColumn;
import java.awt.Color;
import psf.PSF;
import psf.Point3D;

public class SummaryPanel
extends GridPanel {
    public SummaryPanel(PSF psf) {
        super(false, 8);
        Point3D max = psf.getData().max;
        Point3D fwhm = psf.getData().fwhm;
        SmartTableColumn[] columns = new SmartTableColumn[3];
        SmartFormat nm1 = new SmartFormat(SmartFormat.DECIMAL, 1, "nm");
        SmartFormat px1 = new SmartFormat(SmartFormat.DECIMAL, 0, "px");
        SmartFormat sf2 = new SmartFormat(SmartFormat.DECIMAL, 2);
        columns[0] = new SmartTableColumn("Feature");
        columns[1] = new SmartTableColumn("Value in nm", nm1);
        columns[2] = new SmartTableColumn("Value in pixel", px1);
        SmartTable table = new SmartTable(columns);
        table.setBackgroundColor(new Color(245, 245, 250), new Color(245, 245, 250), new Color(150, 150, 177));
        table.setMonospaceFont(true);
        table.addRow(new Object[]{"Numerical Aperture", psf.NA, ""}, sf2);
        table.addRow(new Object[]{"Wavelength", psf.lambda, ""});
        table.addRow(new Object[]{"Energy", psf.getData().energy, ""}, new SmartFormat(SmartFormat.ENGINEER));
        table.addRowEmpty();
        table.addRow(new Object[]{"Size X", (double)psf.nx * psf.resLateral, psf.nx});
        table.addRow(new Object[]{"Size Y", (double)psf.ny * psf.resLateral, psf.ny});
        table.addRow(new Object[]{"Size Z", (double)psf.nz * psf.resAxial, psf.nz});
        table.addRowEmpty();
        table.addRow(new Object[]{"Pixelsize X", psf.resLateral});
        table.addRow(new Object[]{"Pixelsize Y", psf.resLateral});
        table.addRow(new Object[]{"Axial Z-step", psf.resAxial});
        table.addRowEmpty();
        table.addRow(new Object[]{"FWHM Lateral X", (double)fwhm.x * psf.resLateral, fwhm.x});
        table.addRow(new Object[]{"FWHM Lateral Y", (double)fwhm.y * psf.resLateral, fwhm.y});
        table.addRow(new Object[]{"FWHM Axial Z", (double)fwhm.z * psf.resAxial, fwhm.z});
        table.addRow(new Object[]{"Energy under FWHM", fwhm.value, ""}, new SmartFormat(SmartFormat.ENGINEER));
        table.addRowEmpty();
        table.addRow(new Object[]{"Max Lateral X", (double)max.x * psf.resLateral, max.x});
        table.addRow(new Object[]{"Max Lateral Y", (double)max.y * psf.resLateral, max.y});
        table.addRow(new Object[]{"Max Axial Z", (double)max.z * psf.resAxial, max.z});
        table.addRow(new Object[]{"Max Value", max.value, ""}, new SmartFormat(SmartFormat.DECIMAL, 3));
        String content = "";
        content = String.valueOf(content) + "<h1>" + psf.getFullname() + "</h1>";
        HTMLPane panel = new HTMLPane(content);
        this.place(0, 0, panel);
        this.place(1, 0, table);
    }
}

