/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.smarttable;

import bilib.commons.smarttable.SmartFormat;
import bilib.commons.smarttable.SmartTableColumn;
import bilib.commons.smarttable.SmartTableListener;
import bilib.commons.smarttable.SmartTableModel;
import bilib.commons.smarttable.SmartTableRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class SmartTable
extends JPanel {
    private SmartTableModel model;
    private SmartTableColumn[] columns = null;
    private JTable table;
    private SmartTableRenderer renderer;
    private ArrayList<SmartFormat> nfRows = new ArrayList();

    public SmartTable(SmartTableColumn[] columns) {
        this.columns = columns;
        this.model = new SmartTableModel(columns);
        int n = columns.length;
        Object[] headers = new String[n];
        int i = 0;
        while (i < n) {
            headers[i] = columns[i].header;
            ++i;
        }
        this.model.setColumnIdentifiers(headers);
        this.renderer = new SmartTableRenderer(columns, this.nfRows);
        this.table = new JTable(this.model);
        this.setLayout(new BorderLayout());
        JTableHeader header = this.table.getTableHeader();
        header.addMouseListener(new SmartTableListener(header, columns));
        JScrollPane pane = new JScrollPane(this.table);
        this.add((Component)pane, "Center");
        int i2 = 0;
        while (i2 < n) {
            TableColumn tc = header.getTable().getColumnModel().getColumn(i2);
            tc.setHeaderValue(columns[i2].getSortedHeader());
            tc.setPreferredWidth(columns[i2].width);
            tc.setCellRenderer(this.renderer);
            ++i2;
        }
    }

    public void setMonospaceFont(boolean monospace) {
        this.renderer.setMonospaceFont(monospace);
    }

    public void incrementSizeFont(int sizeFont) {
        this.renderer.incrementSizeFont(sizeFont);
    }

    public void setBackgroundColor(Color colorEvenRow, Color colorOddRow, Color colorSelection) {
        this.renderer.setBackgroundColor(colorEvenRow, colorOddRow, colorSelection);
    }

    public void setBackgroundColorTop(Color colorTop) {
        this.renderer.setBackgroundTopColor(colorTop);
    }

    public void addRow(Object[] data) {
        this.addRow(data, null);
    }

    public void addRow(Object[] data, int format) {
        this.addRow(data, new SmartFormat(format));
    }

    public void addRow(Object[] data, SmartFormat numformat) {
        if (this.model == null) {
            return;
        }
        Object[] tmp = new Object[data.length];
        int i = 0;
        while (i < data.length) {
            tmp[i] = data[i].getClass().getSuperclass() == Number.class ? new Double(((Number)data[i]).doubleValue()) : (data[i].getClass() == String.class ? (String)data[i] : (data[i].getClass() == Boolean.class ? (Boolean)data[i] : "- Undefined -"));
            ++i;
        }
        this.nfRows.add(numformat);
        this.model.addRow(tmp);
    }

    public void addTopRow(Object[] data) {
        if (this.model == null) {
            return;
        }
        this.nfRows.add(0, null);
        this.model.insertRow(0, data);
        ++this.renderer.top;
    }

    public void addRowEmpty() {
        if (this.model == null) {
            return;
        }
        Object[] empty = new String[this.columns.length];
        this.nfRows.add(null);
        this.model.addRow(empty);
    }

    public void setValueAt(Object value, int row, int col) {
        if (this.model == null) {
            return;
        }
        if (row >= this.model.getRowCount()) {
            return;
        }
        if (col >= this.model.getColumnCount()) {
            return;
        }
        this.model.setValueAt(value, row, col);
    }

    public void showInFrame(String title, int width, int height) {
        JFrame frame = new JFrame(title);
        JScrollPane scrollpane = new JScrollPane(this);
        scrollpane.setPreferredSize(new Dimension(width, height));
        frame.add(scrollpane);
        frame.pack();
        frame.setVisible(true);
    }

    public void saveCVS(String filename) {
        this.saveCVS(filename, true);
    }

    private String[] getHeaderAsStringArray() {
        int n = this.columns.length;
        String[] headers = new String[n];
        int i = 0;
        while (i < n) {
            headers[i] = this.columns[i].header;
            ++i;
        }
        return headers;
    }

    public void saveCVS(String filename, boolean saveHeader) {
        File file = new File(filename);
        try {
            String[] headers = this.getHeaderAsStringArray();
            BufferedWriter buffer = new BufferedWriter(new FileWriter(file));
            String s = "";
            if (saveHeader) {
                int i = 0;
                while (i < headers.length) {
                    s = String.valueOf(s) + headers[i] + ",";
                    ++i;
                }
                buffer.write(String.valueOf(s) + "\n");
            }
            int ncols = this.model.getColumnCount();
            int nrows = this.model.getRowCount();
            int row = 0;
            while (row < nrows) {
                s = "";
                int col = 0;
                while (col < ncols - 1) {
                    s = String.valueOf(s) + this.model.getValueAt(row, col) + ",";
                    ++col;
                }
                s = String.valueOf(s) + this.model.getValueAt(row, ncols - 1);
                buffer.write(String.valueOf(s) + "\n");
                ++row;
            }
            buffer.close();
        }
        catch (IOException ex) {
            System.out.println("" + ex);
        }
    }

    public void saveTex(String filename, boolean saveHeader) {
        File file = new File(filename);
        try {
            String[] headers = this.getHeaderAsStringArray();
            BufferedWriter buffer = new BufferedWriter(new FileWriter(file));
            String s = "";
            if (saveHeader) {
                int i = 0;
                while (i < headers.length) {
                    s = String.valueOf(s) + headers[i] + " & ";
                    ++i;
                }
                buffer.write(String.valueOf(s) + "\\\\  \n");
            }
            int ncols = this.model.getColumnCount();
            int nrows = this.model.getRowCount();
            int row = 0;
            while (row < nrows) {
                s = "";
                int col = 0;
                while (col < ncols - 1) {
                    s = String.valueOf(s) + this.model.getValueAt(row, col) + " & ";
                    ++col;
                }
                s = String.valueOf(s) + this.model.getValueAt(row, ncols - 1);
                buffer.write(String.valueOf(s) + " \\\\  \n");
                ++row;
            }
            buffer.close();
        }
        catch (IOException ex) {
            System.out.println("" + ex);
        }
    }

    public static enum Alignment {
        CENTER,
        LEFT,
        RIGHT;

    }

    public static enum Sorter {
        NONE,
        ASCENT,
        DESCENT;

    }
}

