/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.smarttable;

import bilib.commons.smarttable.SmartFormat;
import bilib.commons.smarttable.SmartTable;

public class SmartTableColumn {
    protected String header = "Undefined";
    protected int width = 20;
    protected boolean editable = false;
    private SmartTable.Sorter sorter = SmartTable.Sorter.NONE;
    protected SmartFormat numformat = new SmartFormat(SmartFormat.DECIMAL);
    private SmartTable.Alignment alignment = SmartTable.Alignment.LEFT;
    private boolean sortable = false;

    public SmartTableColumn(String header, boolean sortable, int width, SmartFormat numformat) {
        this.header = header;
        this.sortable = sortable;
        this.width = width;
        this.numformat = numformat;
        this.alignment = SmartTable.Alignment.RIGHT;
    }

    public SmartTableColumn(String header, boolean sortable, int width) {
        this.header = header;
        this.sortable = sortable;
        this.width = width;
    }

    public SmartTableColumn(String header, boolean sortable, SmartFormat numformat) {
        this.header = header;
        this.sortable = sortable;
        this.numformat = numformat;
        this.alignment = SmartTable.Alignment.RIGHT;
    }

    public SmartTableColumn(String header, SmartFormat numformat) {
        this.header = header;
        this.numformat = numformat;
        this.alignment = SmartTable.Alignment.RIGHT;
    }

    public SmartTableColumn(String header, boolean sortable) {
        this.header = header;
        this.sortable = sortable;
    }

    public SmartTableColumn(String header, int width) {
        this.header = header;
        this.width = width;
    }

    public SmartTableColumn(String header) {
        this.header = header;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSorter(SmartTable.Sorter sorter) {
        this.sorter = sorter;
    }

    public boolean isAscent() {
        return this.sorter == SmartTable.Sorter.ASCENT;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setAlignment(SmartTable.Alignment alignment) {
        this.alignment = alignment;
    }

    public int getAlignment() {
        if (this.alignment == SmartTable.Alignment.CENTER) {
            return 0;
        }
        if (this.alignment == SmartTable.Alignment.RIGHT) {
            return 4;
        }
        return 2;
    }

    public void nextSorter() {
        if (this.sorter == SmartTable.Sorter.NONE) {
            this.sorter = SmartTable.Sorter.ASCENT;
            return;
        }
        if (this.sorter == SmartTable.Sorter.ASCENT) {
            this.sorter = SmartTable.Sorter.DESCENT;
            return;
        }
        if (this.sorter == SmartTable.Sorter.DESCENT) {
            this.sorter = SmartTable.Sorter.ASCENT;
            return;
        }
    }

    public String getSortedHeader() {
        if (!this.sortable) {
            return this.header;
        }
        String sign = "";
        if (this.sorter == SmartTable.Sorter.NONE) {
            sign = "&#9830;";
        }
        if (this.sorter == SmartTable.Sorter.ASCENT) {
            sign = "&#9650;";
        }
        if (this.sorter == SmartTable.Sorter.DESCENT) {
            sign = "&#9660;";
        }
        return "<html>" + sign + " " + this.header + "</html";
    }
}

