/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolBar;

public class GridToolbar
extends JToolBar {
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraint = new GridBagConstraints();
    private int defaultSpace = 3;

    public GridToolbar() {
        super("Control");
        this.setLayout(this.layout);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setFloatable(false);
    }

    public GridToolbar(boolean border) {
        super("Control");
        this.setLayout(this.layout);
        if (border) {
            this.setBorder(BorderFactory.createEtchedBorder());
        }
        this.setFloatable(false);
    }

    public GridToolbar(String title) {
        super(title);
        this.setLayout(this.layout);
        this.setBorder(BorderFactory.createTitledBorder(title));
        this.setFloatable(false);
    }

    public GridToolbar(int defaultSpace) {
        super("Control");
        this.setLayout(this.layout);
        this.defaultSpace = defaultSpace;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setFloatable(false);
    }

    public GridToolbar(boolean border, int defaultSpace) {
        super("Control");
        this.setLayout(this.layout);
        this.defaultSpace = defaultSpace;
        if (border) {
            this.setBorder(BorderFactory.createEtchedBorder());
        }
        this.setFloatable(false);
    }

    public GridToolbar(boolean border, int defaultSpace, boolean floatable) {
        super("Control");
        this.setLayout(this.layout);
        this.defaultSpace = defaultSpace;
        if (border) {
            this.setBorder(BorderFactory.createEtchedBorder());
        }
        this.setFloatable(floatable);
    }

    public GridToolbar(boolean border, boolean floatable) {
        super("Control");
        this.setLayout(this.layout);
        if (border) {
            this.setBorder(BorderFactory.createEtchedBorder());
        }
        this.setFloatable(floatable);
    }

    public GridToolbar(String title, boolean floatable) {
        super(title);
        this.setLayout(this.layout);
        this.setBorder(BorderFactory.createTitledBorder(title));
        this.setFloatable(floatable);
    }

    public GridToolbar(int defaultSpace, boolean floatable) {
        super("Control");
        this.setLayout(this.layout);
        this.defaultSpace = defaultSpace;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setFloatable(floatable);
    }

    public GridToolbar(String title, int defaultSpace) {
        super(title);
        this.setLayout(this.layout);
        this.defaultSpace = defaultSpace;
        this.setBorder(BorderFactory.createTitledBorder(title));
        this.setFloatable(false);
    }

    public GridToolbar(String title, int defaultSpace, boolean floatable) {
        super(title);
        this.setLayout(this.layout);
        this.defaultSpace = defaultSpace;
        this.setBorder(BorderFactory.createTitledBorder(title));
        this.setFloatable(floatable);
    }

    public void setSpace(int defaultSpace) {
        this.defaultSpace = defaultSpace;
    }

    public void place(int row, int col, String label) {
        this.place(row, col, 1, 1, this.defaultSpace, new JLabel(label));
    }

    public void place(int row, int col, int space, String label) {
        this.place(row, col, 1, 1, space, new JLabel(label));
    }

    public void place(int row, int col, int width, int height, String label) {
        this.place(row, col, width, height, this.defaultSpace, new JLabel(label));
    }

    public void place(int row, int col, JComponent comp) {
        this.place(row, col, 1, 1, this.defaultSpace, comp);
    }

    public void place(int row, int col, int space, JComponent comp) {
        this.place(row, col, 1, 1, space, comp);
    }

    public void place(int row, int col, int width, int height, JComponent comp) {
        this.place(row, col, width, height, this.defaultSpace, comp);
    }

    public void place(int row, int col, int width, int height, int space, JComponent comp) {
        if (comp == null) {
            return;
        }
        this.constraint.gridx = col;
        this.constraint.gridy = row;
        this.constraint.gridwidth = width;
        this.constraint.gridheight = height;
        this.constraint.anchor = 18;
        this.constraint.insets = new Insets(space, space, space, space);
        this.constraint.fill = 2;
        this.layout.setConstraints(comp, this.constraint);
        this.add(comp);
    }
}

