/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.random;

import bilib.commons.gui.GridPanel;
import bilib.commons.gui.SpinnerDouble;
import bilib.commons.random.Noise;
import bilib.commons.settings.Settings;
import javax.swing.JPanel;

public class NoiseRayleigh
extends Noise {
    private double sigma = 1.0;
    private SpinnerDouble spnSigma = new SpinnerDouble(1.0, -1.7976931348623157E308, Double.MAX_VALUE, 1.0);

    public NoiseRayleigh(double sigma) {
        this.sigma = sigma;
    }

    @Override
    public String getName() {
        return "Rayleigh";
    }

    @Override
    public void fetchParameters() {
        this.sigma = this.spnSigma.get();
    }

    @Override
    public double nextValue() {
        return Math.sqrt(-2.0 * Math.log(1.0 - this.random.nextDouble())) * this.sigma;
    }

    @Override
    public JPanel buildPanel(Settings settings) {
        GridPanel panel = new GridPanel(false);
        panel.place(1, 0, "Sigma");
        panel.place(1, 1, this.spnSigma);
        settings.record("random-" + this.getName() + "-sigma", this.spnSigma, "1");
        settings.loadRecordedItems();
        return panel;
    }
}

