/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.settings;

import bilib.commons.settings.Settings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SettingsFileDialog
extends JDialog
implements ActionListener {
    private JTextField txt;
    private JButton bnCancel = new JButton("Cancel");
    private JButton bnReset = new JButton("Default");
    private JButton bnSaveAs = new JButton("Save As");
    private JButton bnLoad = new JButton("Load");
    private JButton bnSave = new JButton("Save");
    private Settings settings;

    public SettingsFileDialog(Settings settings) {
        super((Frame)new JFrame(), "Settings of " + settings.getProject());
        this.settings = settings;
        this.txt = new JTextField(settings.getFilename());
        this.txt.setEditable(false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel pn1 = new JPanel(new FlowLayout());
        pn1.add(this.txt);
        JPanel pn2 = new JPanel(new FlowLayout());
        pn2.add(this.bnCancel);
        pn2.add(this.bnReset);
        pn2.add(this.bnSave);
        pn2.add(this.bnSaveAs);
        pn2.add(this.bnLoad);
        contentPane.add((Component)pn1, "North");
        contentPane.add((Component)pn2, "South");
        this.bnCancel.addActionListener(this);
        this.bnReset.addActionListener(this);
        this.bnSaveAs.addActionListener(this);
        this.bnSave.addActionListener(this);
        this.bnLoad.addActionListener(this);
        this.pack();
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bnSaveAs) {
            JFileChooser chooser = new JFileChooser(this.txt.getText());
            chooser.setSelectedFile(new File("config.txt"));
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(new FileNameExtensionFilter("Configuration file", "txt"));
            int returnVal = chooser.showSaveDialog(new JFrame());
            if (returnVal == 0) {
                String name = chooser.getSelectedFile().getAbsolutePath();
                if (!name.endsWith(".txt")) {
                    name = String.valueOf(name) + ".txt";
                }
                this.txt.setText(name);
                this.settings.storeRecordedItems(this.txt.getText());
            }
        } else if (e.getSource() == this.bnLoad) {
            JFileChooser chooser = new JFileChooser(this.txt.getText());
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(new FileNameExtensionFilter("Configuration file", "txt"));
            int returnVal = chooser.showOpenDialog(new JFrame());
            if (returnVal == 0) {
                String name = chooser.getSelectedFile().getAbsolutePath();
                this.txt.setText(name);
            }
            this.settings.loadRecordedItems(this.txt.getText());
        } else if (e.getSource() == this.bnSave) {
            this.settings.storeRecordedItems(this.txt.getText());
        } else if (e.getSource() == this.bnReset) {
            this.settings.loadRecordedItems("default-no-file");
        }
        this.bnCancel.removeActionListener(this);
        this.bnReset.removeActionListener(this);
        this.bnLoad.removeActionListener(this);
        this.bnSave.removeActionListener(this);
        this.bnSaveAs.removeActionListener(this);
        this.dispose();
    }
}

