/*
 * Decompiled with CFR 0.152.
 */
package plugins.sage.apachecommonsmath3;

import icy.gui.frame.progress.AnnounceFrame;
import icy.plugin.abstract_.PluginActionable;
import icy.plugin.interface_.PluginLibrary;

public class ApacheCommonsMath3
extends PluginActionable
implements PluginLibrary {
    public void run() {
        String version = "3.5";
        new AnnounceFrame("Appache Commons Math 3 Version " + version, 2);
        System.out.println("\nAppache Commons Math 3 Version " + version + " is available");
        int n = 500000;
        int iter = 10;
        double chrono = System.nanoTime();
        System.out.println("\nRunning a quick benchmark: " + n * iter + " round(sin(exp(random()))) operations");
        chrono = System.nanoTime();
        int i = 0;
        while (i < n) {
            Math.round(Math.sin(Math.exp(Math.random())));
            ++i;
        }
        System.out.println("- with the Math class of Java: " + ((double)System.nanoTime() - chrono) / 1000000.0 + " ms");
        chrono = System.nanoTime();
        i = 0;
        while (i < n) {
            StrictMath.round(StrictMath.sin(StrictMath.exp(StrictMath.random())));
            ++i;
        }
        System.out.println("- with the StrictMath class of Java: " + ((double)System.nanoTime() - chrono) / 1000000.0 + " ms");
    }
}

