package plugins.oeway;
/*
 * Saz file importer for PAV Scanning Acoustic Microscope
 * Used by EVA project(http://www.evaimg.org/)
 * 
 *  @author Will Ouyang
 */
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import loci.common.services.ServiceException;
import loci.formats.gui.ExtensionFileFilter;
import loci.formats.ome.OMEXMLMetadataImpl;
import icy.common.exception.UnsupportedFormatException;
import icy.file.FileUtil;
import icy.file.Loader;
import icy.image.IcyBufferedImage;
import icy.math.ArrayMath;
import icy.plugin.abstract_.PluginSequenceFileImporter;
import icy.type.DataType;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.process.ImageProcessor;
import icy.sequence.MetaDataUtil;

public class EvaSazImporter extends PluginSequenceFileImporter
{
	ImagePlus image;
     int sizeX ;
     int sizeY;
     int sizeC;
     int sizeZ;
     int sizeT;
     int type;
    // only integer signed type allowed in ImageJ is 16 bit signed
     boolean signed16;
     String filePath;
     OMEXMLMetadataImpl meta;
	public FileInfo getFileInfo(String path) {
		File file = new File(path);
        //long length = file.length();
        
		String fileName =FileUtil.getFileName(path);
		String directory =FileUtil.getDirectory(path);
		
		HashMap<String, Object> msgDict = new HashMap<String, Object>();
		
		try {
			RandomAccessFile f = new RandomAccessFile(file, "r");
			
			System.out.println("---------------------header info of saz file--------------------");
	        //#message define: name , location ,length
	        msgDict.put("head", ReadFromFile( f,"head", 0,12,"12s"));
	        msgDict.put("unit", ReadFromFile( f,"unit", 128,28,"28s"));
	        msgDict.put("transducor", ReadFromFile( f,"transducor", 448,8,"8s"));
	        msgDict.put("realWidth",ReadFromFile( f,"realWidth", 76,4,"<L","um"));
	        msgDict.put("realHeight",ReadFromFile( f,"realHeight", 80,4,"<L","um"));
	        msgDict.put("pixelWidth",ReadFromFile( f,"pixelWidth", 88,4,"<L","pixel"));
	        msgDict.put("pixelHeight",ReadFromFile( f,"pixelHeight", 92,4,"<L","pixel"));
	        msgDict.put("resolutionX",ReadFromFile( f,"resolutionX", 84,4,"<L","pixel/mm"));
	        msgDict.put("resolutionY",ReadFromFile( f,"resolutionY", 96,4,"<L","X"));
	        msgDict.put("display",ReadFromFile( f,"display", 116,4,"<i",""));
	        msgDict.put("xPos",ReadFromFile( f,"xPos", 100,4,"<L","um"));
	        msgDict.put("yPos",ReadFromFile( f, "yPos",104,4,"<L","um"));
	        msgDict.put("zPos",ReadFromFile( f,"zPos", 108,4,"<L","um"));
	        
	        msgDict.put("cscanWidth",ReadFromFile( f,"cscanWidth", 184,4,"<L","ns"));
	        msgDict.put("cscanPos",ReadFromFile( f,"cscanPos", 180,4,"<i","ns"));
	        msgDict.put("bscanPos",ReadFromFile( f,"bscanPos", 188,4,"<i","ns"));
	        msgDict.put("bscanWidth",ReadFromFile( f,"bscanWidth", 192,4,"<L","ns"));
	        msgDict.put("sftPos",ReadFromFile( f,"sftPos", 196,4,"<i","ns"));
	        msgDict.put("sftWidth",ReadFromFile( f,"sftWidth", 200,4,"<L","ns"));
	       
	        msgDict.put("highResolution",ReadFromFile( f, "highResolution",64,1,"<B"));
	        msgDict.put("highPass",ReadFromFile( f,"highPass", 292,4,"<L","MHz"));
	        msgDict.put("lowPass",ReadFromFile( f,"lowPass", 288,4,"<L","MHz"));
	        msgDict.put("voltage",ReadFromFile( f,"voltage", 280,4,"<L","V"));
	        msgDict.put("gain",ReadFromFile( f,"gain", 284,4,"<L","dB"));
	        
	        msgDict.put("dataWidth",ReadFromFile( f,"dataWidth", 480,4,"<L"));
	        msgDict.put("dataHeight",ReadFromFile( f,"dataHeight", 484,4,"<L"));
	        msgDict.put("dataAspectRatio",ReadFromFile( f,"dataAspectRatio", 488,4,"<L"));
	        msgDict.put("waveformLength",ReadFromFile( f,"waveformLength", 492,4,"<L","byte"));
	        //msgDict.put("Waveform",ReadFromFile( f, 496,7504,""));
	        System.out.println("--------------------------------------------------------");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		

		FileInfo fi = new FileInfo();
		fi.fileFormat = FileInfo.RAW;
		fi.fileName = fileName;
		fi.directory = directory;
		fi.width = (Integer) msgDict.get("waveformLength")/2;
		fi.height = (Integer) msgDict.get("dataWidth");
		int offset = 496;
		
		if (offset>2147483647)
			fi.longOffset = offset;
		else
			fi.offset = (int)offset;
		fi.nImages = (Integer) msgDict.get("pixelHeight");
		fi.gapBetweenImages = 0;
		fi.intelByteOrder = false;  //little-endian
		fi.whiteIsZero = false;
		
//		String imageType = "16-bit Signed";
//		if (imageType.equals("8-bit"))
//			fi.fileType = FileInfo.GRAY8;
//		else if (imageType.equals("16-bit Signed"))
			fi.fileType = FileInfo.GRAY16_SIGNED;
//		else if (imageType.equals("16-bit Unsigned"))
//			fi.fileType = FileInfo.GRAY16_UNSIGNED;
//		else if (imageType.equals("32-bit Signed"))
//			fi.fileType = FileInfo.GRAY32_INT;
//		else if (imageType.equals("32-bit Unsigned"))
//			fi.fileType = FileInfo.GRAY32_UNSIGNED;
//		else if (imageType.equals("32-bit Real"))
//			fi.fileType = FileInfo.GRAY32_FLOAT;
//		else if (imageType.equals("64-bit Real"))
//			fi.fileType = FileInfo.GRAY64_FLOAT;
//		else if (imageType.equals("24-bit RGB"))
//			fi.fileType = FileInfo.RGB;
//		else if (imageType.equals("24-bit RGB Planar"))
//			fi.fileType = FileInfo.RGB_PLANAR;
//		else if (imageType.equals("24-bit BGR"))
//			fi.fileType = FileInfo.BGR;
//		else if (imageType.equals("24-bit Integer"))
//			fi.fileType = FileInfo.GRAY24_UNSIGNED;
//		else if (imageType.equals("32-bit ARGB"))
//			fi.fileType = FileInfo.ARGB;
//		else if (imageType.equals("32-bit ABGR"))
//			fi.fileType = FileInfo.ABGR;
//		else if (imageType.equals("1-bit Bitmap"))
//			fi.fileType = FileInfo.BITMAP;
//		else
//			fi.fileType = FileInfo.GRAY8;
		return fi;
	}

	public static final int unsignedIntToLong(byte[] b) {
	    int l = 0;
	    l |= b[3] & 0xFF;
	    l <<= 8;
	    l |= b[2] & 0xFF;
	    l <<= 8;
	    l |= b[1] & 0xFF;
	    l <<= 8;
	    l |= b[0] & 0xFF;
	    return l;
	  }
	
	private Object ReadFromFile(RandomAccessFile f, String name, int loc, int len, String type, String unit) throws IOException {

		f.seek(loc);
		if(type=="<L")
		{
			byte[] b = new byte[4];
			for(int i=0;i<4;i++)
				b[i] = f.readByte();
			int val = unsignedIntToLong(b);
			System.out.println (name+": "+val+unit);
			return val;
		}
		else if(type=="<i")
			return f.readShort();
		else if(type.contains("s")){
			
			int	l =  Integer.parseInt(type.replace("s", ""));
			byte[] b = new byte[l];
			for(int i=0;i<l;i++)
				b[i] =f.readByte();
			String val = new String(b,0,l);
			System.out.println (name+": "+val+unit);
			return val;
		}
		return null;
	}

	private Object ReadFromFile(RandomAccessFile f, String name, int loc, int len, String type) throws IOException {
		return ReadFromFile( f,name, loc,len,type,"");
	}

	@Override
	public String getOpened() {
		
		return filePath;
	}

	@Override
	public boolean open(String path, int flags)
			throws UnsupportedFormatException, IOException {
		if(!acceptFile(path))
			return false;
		FileInfo fi = getFileInfo(path);
		if (fi==null) return false;
		FileOpener fo = new FileOpener(fi);
		image = fo.open(false);
		if (image!=null) {			
			final int[] dim = image.getDimensions(true);
	        sizeX = dim[0];
	        sizeY = dim[1];
	        sizeC = dim[2];
	        sizeZ = dim[3]; //exchange Z and T
	        sizeT = dim[4];
	        type = image.getType();
	        // only integer signed type allowed in ImageJ is 16 bit signed
	        signed16 = image.getLocalCalibration().isSigned16Bit();
	       
	        meta = MetaDataUtil.createDefaultMetadata(fi.fileName);
	        try {
				MetaDataUtil.setMetaData(meta, sizeX, sizeY, sizeC, sizeZ, sizeT, DataType.UINT,false);
			} catch (ServiceException e) {
				e.printStackTrace();
			}
	        filePath = path;
			return true;
		}
		else
		{
			filePath ="";
			return false;
		}
	}

	@Override
	public boolean acceptFile(String path) {
        // easy discard
        if (Loader.canDiscardImageFile(path))
            return false;
		
		File file = new File(path);
        InputStream in = null;
        try {
			RandomAccessFile f = new RandomAccessFile(file, "r");
			
	        //#message define: name , location ,length
	        String head = (String) ReadFromFile( f,"head", 0,12,"12s");
	        f.close();
	        System.out.println (head);
	        if(head.equals("Z-WSam 5  80"))
	        	return true;
	        else
	        	return false;
        } catch (IOException e) {
            e.printStackTrace();
            return false;
        }
	}

	@Override
	public List<FileFilter> getFileFilters() {
	     final List<FileFilter> result = new ArrayList<FileFilter>();
	     result.add(new ExtensionFileFilter(new String[] {"saz", "SAZ"}, "saz file for PAV Scanning Acoustic Microscope"));
		return result;
	}

	@Override
	public boolean close() throws IOException {
//		if (image!=null) {
//			image.close();
//		}
		return true;
	}

	@Override
	public OMEXMLMetadataImpl getMetaData() throws UnsupportedFormatException,
			IOException {
		return meta;
	}

	@Override
	public IcyBufferedImage getImage(int serie, int resolution,
			Rectangle rectangle, int z, int t, int c)
			throws UnsupportedFormatException, IOException {
		if(image!=null){
            image.setPosition(1, z + 1, t + 1);

            // separate RGB channel
            if ((sizeC == 1) && ((type == ImagePlus.COLOR_256) || (type == ImagePlus.COLOR_RGB)))
                return IcyBufferedImage.createFrom(image.getBufferedImage());
            else
            {
                final ImageProcessor ip = image.getProcessor();
                Object data = ip.getPixels();
                // special case of 16 bits signed data --> subtract 32768
                if (signed16)
                    data = ArrayMath.subtract(data, Double.valueOf(32768));
                // create a single image from all channels
                return new IcyBufferedImage(sizeX, sizeY, data, signed16);
            }
		}
		return null;
		
	}
	
}
