package plugins.worm.envelopeline;

import java.util.ArrayList;
import java.util.HashMap;
import java.awt.*;
import java.awt.event.*;

import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.oeway.featureExtraction.featureExtractionPlugin;
import icy.gui.dialog.MessageDialog;
import icy.plugin.abstract_.PluginActionable;
import icy.type.point.Point5D;

public class EnvelopeLine extends featureExtractionPlugin {
	private EzVarInteger			 MeanValue;
	int w ;
	int mean ;
	
	double output[] = null;
	String[] outputGroup = new String[] {"Original Signal","Envelope Line"};
	@Override
	public void initialize(HashMap<String,Object> options,ArrayList<Object> optionUI){
		MeanValue = new EzVarInteger("Mean value : "); 
		optionUI.add(MeanValue);
		options.put(FEATURE_GROUPS, outputGroup);
		
	}

	@Override
	public double[] process(double[] input, double[] position) {
		w= input.length;
		double originArray[] = new double [w];
		double ResultArray[] = new double [w];
		mean = MeanValue.getValue();
		for(int i = 0;i<w;i++)
		{
			originArray[i] = input[i]-mean;
		}
		output =  new double [2*w];
		
		ResultArray= Hilbert.transform(originArray, w);
		for(int i = 0;i<w;i++)
		{
			ResultArray[i]= Math.sqrt(Math.pow(originArray[i],2)+Math.pow(ResultArray[i],2));
		}
		output=AddArrayBefore(originArray, output);
		output=AddArrayAfter(ResultArray,output);
		return output;
	}
	private double[] AddArrayBefore(double[] front,double[] sum ){
		int FrontLength = front.length;	
		for(int i=0;i<FrontLength;i++)
		{
			sum[i]=front[i];
		}
		return sum;
	}
	private double[] AddArrayAfter(double[] after,double[] sum){
		int AfterLength = after.length;
		int SumLength = sum.length;
		for(int i=AfterLength;i<SumLength;i++)
		{
			sum[i] = after[i-AfterLength];
		}
		return sum;
	}
}
	