package plugins.worm.multilineadapter;




import java.util.ArrayList;

import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarDoubleArray;
import plugins.adufour.vars.lang.VarDoubleArrayNative;
import plugins.adufour.vars.lang.VarTrigger;
import plugins.adufour.vars.lang.VarTrigger.TriggerListener;
import plugins.adufour.vars.util.VarListener;
import icy.gui.dialog.MessageDialog;
import icy.plugin.abstract_.Plugin;


public class MultiLineAdapter extends Plugin implements Block {
	XYSeriesCollection 				xyDataset 		= new XYSeriesCollection();
	Var<XYSeriesCollection> 		chartVar 		= new Var<XYSeriesCollection>("Output",xyDataset);
	VarList LineList			= new VarList();
	VarList InputList			;
	VarDoubleArrayNative			varDoubleLabel	= new VarDoubleArrayNative("Label",null);
	TriggerListener listener1 = new TriggerListener(){

	

		@Override
		public void triggered(VarTrigger source) {
			//System.out.println("click");
			inputNum++;
			VarDoubleArrayNative			varDoubleInput	= new VarDoubleArrayNative("line"+inputNum,null);
			varDoubleInput.addListener(listener2);
			LineList.add(varDoubleInput);
			InputList.add(varDoubleInput);
			
		}

		@Override
		public void valueChanged(Var<Integer> source, Integer oldValue,
				Integer newValue) {
			// TODO Auto-generated method stub
			
		}

		@Override
		public void referenceChanged(Var<Integer> source,
				Var<? extends Integer> oldReference,
				Var<? extends Integer> newReference) {
			// TODO Auto-generated method stub
			
			
		}
		
	};
	VarListener<double[]> listener2 = new VarListener<double[]>(){

		@Override
		public void valueChanged(Var<double[]> source, double[] oldValue,
				double[] newValue) {
			
			run();
			
		}

		@Override
		public void referenceChanged(Var<double[]> source,
				Var<? extends double[]> oldReference,
				Var<? extends double[]> newReference) {
			// TODO Auto-generated method stub
			//System.out.println("Hello");
			
			run();
				
		}

		

		
	};
	
	VarTrigger 						AddButton	   	= new VarTrigger("Add Line",listener1);
	
	int		  inputNum = 4;
	double [] input = null;
	//double [] input2 = null;
	double [] inputLabel = null;
	double maxY=0;
	double minY=0;
	
	@Override
	public void declareInput(VarList inputMap) {
		VarDoubleArrayNative			varDoubleInput1	= new VarDoubleArrayNative("line1",null);
		VarDoubleArrayNative			varDoubleInput2	= new VarDoubleArrayNative("line2",null);
		VarDoubleArrayNative			varDoubleInput3	= new VarDoubleArrayNative("line3",null);
		VarDoubleArrayNative			varDoubleInput4	= new VarDoubleArrayNative("line4",null);
		//VarDoubleArrayNative			varDoubleInput2	= new VarDoubleArrayNative("line2",null);
		
		AddButton.addListener(listener1);
		varDoubleLabel.addListener(listener2);
		varDoubleInput1.addListener(listener2);
		varDoubleInput2.addListener(listener2);
		varDoubleInput3.addListener(listener2);
		varDoubleInput4.addListener(listener2);
		LineList.add(varDoubleInput1);
		LineList.add(varDoubleInput2);
		LineList.add(varDoubleInput3);
		LineList.add(varDoubleInput4);


	
		inputMap.add(AddButton);
		inputMap.add(varDoubleLabel);
		inputMap.add(varDoubleInput1);
		inputMap.add(varDoubleInput2);
		inputMap.add(varDoubleInput3);
		inputMap.add(varDoubleInput4);

		InputList = inputMap;
		
		
		
	}

	@Override
	public void declareOutput(VarList outputMap) {
		
			outputMap.add(chartVar);
		
		
		chartVar.setValue(xyDataset);
	}
	@Override
	public void run() {
//		if(LineList.get(0).getValue()!=null){
//			double[] reference =  (double[]) LineList.get(0).getValue();
//			maxY=reference[0];
//			minY=reference[0];
//		}
	
		
		xyDataset.removeAllSeries();
		
		for(int i=0;i<inputNum;i++)
		{
		
			
			
			input =   (double[]) LineList.get(i).getValue();
			if(input != null)
			{


				XYSeries seriesInput = new XYSeries(LineList.get(i).getName());
				seriesInput = FillSeries(input,seriesInput);
				
	//			{
//				if(maxY<seriesInput.getMaxY())
//				{
//					maxY=seriesInput.getMaxY();
//				}
//				if(minY>seriesInput.getMinY())
//				{
//					minY=seriesInput.getMinY();
//				}
				
				xyDataset.addSeries(seriesInput);
				maxY=xyDataset.getRangeUpperBound(true);
				minY=xyDataset.getRangeLowerBound(true);
			}
			
		}
		inputLabel = varDoubleLabel.getValue();
		for(int j=0;j<inputLabel.length;j++){
			XYSeries label = new XYSeries(varDoubleLabel.getName());
			xyDataset.addSeries(FillLabelSeries(inputLabel[j],label));
		}
	}



	private XYSeries FillSeries(double[] data,XYSeries origin)
	{

		for(int i =0;i<data.length;i++)
		{
			origin.add(i, data[i]);
		}
		return origin;
	}
	private XYSeries FillLabelSeries(double data,XYSeries origin)
	{

		
			origin.add(data, maxY);
			origin.add(data,minY);
		
		return origin;
	}

	}

