package plugins.worm.arraySlicer;

import java.util.ArrayList;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarDoubleArrayNative;
import plugins.adufour.vars.lang.VarIntegerArrayNative;
import plugins.adufour.vars.lang.VarTrigger;
import plugins.adufour.vars.lang.VarTrigger.TriggerListener;
import plugins.adufour.vars.util.VarListener;
import icy.plugin.abstract_.Plugin;

public class ArraySlicer extends Plugin implements Block {
	int 							sliceCount	= 			4;
	VarList InputList;
	VarList OutputList;
    ArrayList<VarIntegerArrayNative>	rangeList		=new ArrayList<VarIntegerArrayNative>();
	ArrayList<VarDoubleArrayNative> sliceOutputList	= new ArrayList<VarDoubleArrayNative>();
	VarDoubleArrayNative			varDoubleInput=new VarDoubleArrayNative("input",null);
	
	VarIntegerArrayNative			varSlice1=new VarIntegerArrayNative("range 1",null);
	VarIntegerArrayNative			varSlice2=new VarIntegerArrayNative("range 2",null);
	VarIntegerArrayNative			varSlice3=new VarIntegerArrayNative("range 3",null);
	VarIntegerArrayNative			varSlice4=new VarIntegerArrayNative("range 4",null);
	VarDoubleArrayNative			varDoubleOutput1= new VarDoubleArrayNative("slice1"+" output",null);
	VarDoubleArrayNative			varDoubleOutput2= new VarDoubleArrayNative("slice2"+" output",null);
	VarDoubleArrayNative			varDoubleOutput3= new VarDoubleArrayNative("slice3"+" output",null);
	VarDoubleArrayNative			varDoubleOutput4= new VarDoubleArrayNative("slice4"+" output",null);

	@SuppressWarnings("rawtypes")
	VarListener listener2 = new VarListener(){

		@Override
		public void valueChanged(Var source, Object oldValue, Object newValue) {
			// TODO Auto-generated method stub
			try
			{
				if(varDoubleInput.size()>0&&varSlice1.getValue().length!=2)
				{
					varSlice1.setValue(new int[]{0,varDoubleInput.size()});
				}
				if(varDoubleInput.size()>0&&varSlice2.getValue().length!=2)
				{
					varSlice2.setValue(new int[]{0,varDoubleInput.size()});
				}
				if(varDoubleInput.size()>0&&varSlice3.getValue().length!=2)
				{
					varSlice3.setValue(new int[]{0,varDoubleInput.size()});
				}
				if(varDoubleInput.size()>0&&varSlice4.getValue().length!=2)
				{
					varSlice4.setValue(new int[]{0,varDoubleInput.size()});
				}
//				else{
//					if(varSlice1.getValue()[1]==-1)
//					{
//						varSlice1.setValue(new int[]{0,varDoubleInput.size()-1});
//					}
//				}
				
			}
			catch(Exception e)
			{
				
			}
			run();
		}

		@Override
		public void referenceChanged(Var source, Var oldReference,
				Var newReference) {
			try
			{
				if(varDoubleInput.size()>0&&varSlice1.getValue().length!=2)
				{
					varSlice1.setValue(new int[]{0,varDoubleInput.size()});
				}
				if(varDoubleInput.size()>0&&varSlice2.getValue().length!=2)
				{
					varSlice2.setValue(new int[]{0,varDoubleInput.size()});
				}
				if(varDoubleInput.size()>0&&varSlice3.getValue().length!=2)
				{
					varSlice3.setValue(new int[]{0,varDoubleInput.size()});
				}
				if(varDoubleInput.size()>0&&varSlice4.getValue().length!=2)
				{
					varSlice4.setValue(new int[]{0,varDoubleInput.size()});
				}
			}
			catch(Exception e)
			{
				
			}
			run();
		}

	};

	TriggerListener listener1 = new TriggerListener(){
		@Override
		public void triggered(VarTrigger source) {
			sliceCount++;
			int[] defaultRange = null;
			if(varDoubleInput!=null){
				defaultRange = new int[]{0,varDoubleInput.size()};
			}
			VarIntegerArrayNative	varSlice	= new VarIntegerArrayNative("range "+sliceCount,defaultRange);
			VarDoubleArrayNative	varDoubleOutput = new VarDoubleArrayNative("slice"+sliceCount+" output",null);
			varSlice.addListener(listener2);
			InputList.add(varSlice);
			OutputList.add(varDoubleOutput);
			
			rangeList.add(varSlice);
			sliceOutputList.add(varDoubleOutput);
			run();
				
		}

		@Override
		public void valueChanged(Var<Integer> source, Integer oldValue,
				Integer newValue) {
			try
			{
				
				if(varSlice1.getValue().length!=2)
				{
					varSlice1.setValue(new int[]{0,varDoubleInput.size()});
				}
			}
			catch(Exception e)
			{
				
			}
			run();
		}

		@Override
		public void referenceChanged(Var<Integer> source,
				Var<? extends Integer> oldReference,
				Var<? extends Integer> newReference) {
			
		}
		
	};	
	@Override
	public void declareInput(VarList inputMap) {
		
		VarTrigger AddButton	= new VarTrigger("Add slice",listener1);
		inputMap.add(AddButton);		
		inputMap.add(varDoubleInput);
		inputMap.add(varSlice1);
		inputMap.add(varSlice2);
		inputMap.add(varSlice3);
		inputMap.add(varSlice4);
		InputList = inputMap;
		//InputList.add(varSlicer1);
		rangeList.add(varSlice1);
		rangeList.add(varSlice2);
		rangeList.add(varSlice3);
		rangeList.add(varSlice4);
		varSlice1.addListener(listener2);
		varDoubleInput.addListener(listener2);
		
	

	}

	@Override
	public void declareOutput(VarList outputMap) {
		outputMap.add(varDoubleOutput1);
		outputMap.add(varDoubleOutput2);
		outputMap.add(varDoubleOutput3);
		outputMap.add(varDoubleOutput4);
		OutputList=	outputMap;
		sliceOutputList.add(varDoubleOutput1);
		sliceOutputList.add(varDoubleOutput2);
		sliceOutputList.add(varDoubleOutput3);
		sliceOutputList.add(varDoubleOutput4);
		
	}

	@Override
	public void run() {
		if((varDoubleInput.getValue())!=null){
			for(int i =0; i<sliceCount;i++)
			{
				try
				{
					int[] range = rangeList.get(i).getValue();
					VarDoubleArrayNative varDoubleOutputA = sliceOutputList.get(i);
					
					double[] input = varDoubleInput.getValue();
					//int sizeTocopyA = input.length>=varLenA?varLenA:input.length;
					int startTocopy = Math.min(range[0],range[1]);
					int endOfCopy = Math.max(range[0],range[1])<=(input.length)?Math.max(range[0],range[1]):(input.length);
					int sizeTocopyA =  endOfCopy-startTocopy;
					if(sizeTocopyA>0)
					{
						double[] output1 = new double[sizeTocopyA];
						for(int j=startTocopy;j<endOfCopy;j++)
							output1[j-startTocopy] = input[j];
						varDoubleOutputA.setValue(output1);
					}
					else
					{
						varDoubleOutputA.setValue(new double[]{});
					}
				}
				catch(Exception e)
				{
					
				}
			}
		}
		
		
		
	}

	
}



