package plugins.worm.adconvert;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarDoubleArrayNative;
import plugins.adufour.vars.util.VarListener;
import icy.plugin.abstract_.Plugin;


public class ADConvert extends Plugin implements Block {
	int _w ;
	VarDouble						inputRange		=new VarDouble("Input Range (V)",2);
	VarDoubleArrayNative			varDoubleInput	=new VarDoubleArrayNative("input",null);
	VarDoubleArrayNative			varDoubleOutput =new VarDoubleArrayNative("output",null);
	VarListener listener = new VarListener(){

		@Override
		public void valueChanged(Var source, Object oldValue, Object newValue) {
			run();			
		}

		@Override
		public void referenceChanged(Var source, Var oldReference,
				Var newReference) {
			run();
		}
		
	};
	@Override
	public void run() {
		_w = varDoubleInput.getValue().length;
		double[] inputArray = new double[_w];
		inputArray=varDoubleInput.getValue().clone();
		varDoubleOutput.setValue(ADConvert(inputArray,inputRange.getValue()));
	}

	@Override
	public void declareInput(VarList inputMap) {
		
		inputMap.add(inputRange);
		inputMap.add(varDoubleInput);
		inputRange.addListener(listener);
		varDoubleInput.addListener(listener);
	}

	@Override
	public void declareOutput(VarList outputMap) {
		outputMap.add(varDoubleOutput);
		
	}
	private double[] ADConvert(double[] DigitalValue,double maxAnologValue)
	{
		double[] anologValue = new double[DigitalValue.length];
		for(int i =0;i<DigitalValue.length;i++)
		{
			anologValue[i]=(DigitalValue[i]-32768)/32768*maxAnologValue;
		}
		return anologValue;
	}
}
