package plugins.worm.coercivity;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarDoubleArrayNative;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.util.VarListener;
import icy.gui.dialog.MessageDialog;
import icy.plugin.abstract_.Plugin;
import icy.plugin.abstract_.PluginActionable;

public class Coercivity extends  Plugin implements Block {
	VarList InputList			;
	VarList 	LineList			                    = new VarList();
	VarDouble						varCoercivity	=				new VarDouble("Coercivity",0.0);

	VarListener listener = new VarListener(){

		@Override
		public void valueChanged(Var source, Object oldValue, Object newValue) {
			run();			
		}

		@Override
		public void referenceChanged(Var source, Var oldReference,
				Var newReference) {
			run();
		}
		
	};
	@Override
	public void run() {
		double[] xValue = new double[((double[])LineList.get(0).getValue()).length];
		xValue = ((double[])LineList.get(0).getValue()).clone();
		double[] yValue = new double[((double[])LineList.get(1).getValue()).length];
		yValue = ((double[])LineList.get(1).getValue()).clone();
		
		
		for(int i =0;i<xValue.length;i++){
			if(yValue[i]==0)
			{
				varCoercivity.setValue(Math.abs(xValue[i]));
				break;
			}
			
			
		}
		
	
	}

	@Override
	public void declareInput(VarList inputMap) {
		VarDoubleArrayNative			xAxis			=				new VarDoubleArrayNative("xAxis",null);
		VarDoubleArrayNative			yAxis			=				new VarDoubleArrayNative("yAxis",null);

		inputMap.add(xAxis);
		inputMap.add(yAxis);
		inputMap.add(varCoercivity);

		LineList.add(xAxis);
		LineList.add(yAxis);
		LineList.add(varCoercivity);
		xAxis.addListener(listener);
		yAxis.addListener(listener);
		InputList = inputMap;
		
	}

	@Override
	public void declareOutput(VarList outputMap) {
		
		
	}

}
