/*
 * Decompiled with CFR 0.152.
 */
package plugins.fcordelieres.IcyMetamorphRoiImporter;

import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.roi.ROI;
import icy.sequence.Sequence;
import java.io.File;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.fcordelieres.IcyMetamorphRoiImporter.rgnFile.rgnFile;

public class IcyMetamorphRoiImporter
extends EzPlug
implements Block {
    EzVarFile fileSelector = new EzVarFile("Select the rgn file", "");
    EzVarSequence sequenceSelector = new EzVarSequence("Source sequence");
    final VarROIArray IcyRois = new VarROIArray("ROIs");

    public void clean() {
    }

    protected void execute() {
        File file = (File)this.fileSelector.getValue(true);
        if (!this.isHeadLess()) {
            IcyMetamorphRoiImporter.showMMRoisOnSequence(file, (Sequence)this.sequenceSelector.getValue(true));
        } else {
            this.IcyRois.setValue((Object)IcyMetamorphRoiImporter.getMMRois(file));
        }
    }

    protected void initialize() {
        this.addEzComponent((EzComponent)this.fileSelector);
        this.addEzComponent((EzComponent)this.sequenceSelector);
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("MMRois_in", this.fileSelector.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("MMRois_out", (Var)this.IcyRois);
    }

    public static ROI[] getMMRois(File file) {
        rgnFile rgn = new rgnFile(file.getParent(), file.getName());
        ROI[] out = new ROI[rgn.nRois];
        int i = 0;
        while (i < rgn.nRois) {
            out[i] = rgn.rois.get(i).getIcyRoifromMMRoi();
            ++i;
        }
        new AnnounceFrame(String.valueOf(rgn.nRois) + " Metamorph ROIs found in \"" + file.getName() + "\"", 5);
        return out;
    }

    public static boolean showMMRoisOnSequence(File file, Sequence seq) {
        if (seq == null) {
            new FailedAnnounceFrame("Metamorph Rois Importer requires a sequence to be opened", 5);
            return false;
        }
        ROI[] rois = IcyMetamorphRoiImporter.getMMRois(file);
        if (rois != null) {
            ROI[] rOIArray = rois;
            int n = rois.length;
            int n2 = 0;
            while (n2 < n) {
                ROI roi = rOIArray[n2];
                seq.addROI(roi);
                ++n2;
            }
            return true;
        }
        new FailedAnnounceFrame("Please select a rgn file first", 5);
        return false;
    }
}

