package plugins.lagache.etrack;

import icy.file.FileUtil;


import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.math.ArrayMath;


import icy.roi.ROI2D;


import icy.sequence.Sequence;


import icy.swimmingPool.SwimmingObject;

import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;


import icy.util.XLSUtil;



import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import javax.swing.SwingUtilities;
import javax.vecmath.Point3i;

import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;


import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;

import plugins.adufour.connectedcomponents.*;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.fab.spotDetector.DetectionSpot;
import plugins.fab.spotDetector.Point3D;
import plugins.fab.spotDetector.detector.LocalMaximaDetector;
import plugins.fab.spotDetector.detector.UDWTScale;
import plugins.fab.spotDetector.detector.wavelets.UDWT.B3SplineUDWT;
import plugins.fab.spotDetector.detector.wavelets.UDWT.WaveletConfigException;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackManager;
import plugins.fab.trackmanager.TrackSegment;

import plugins.nchenouard.spot.Detection;
import plugins.nchenouard.spot.Spot;

public class eTrack extends EzPlug {
			
		EzVarSequence sequence = new EzVarSequence("Input Sequence");
		EzVarBoolean bright        = new EzVarBoolean("detect bright spots in dark background ", true);
	    
		EzVarInteger scale = new EzVarInteger("Scale for spot detection",2, 1, 5, 1);
		EzVarDouble threshold = new EzVarDouble("Threshold for spot detection", 100.0, 0, 500, 1);
		
		
		EzVarBoolean displayCumulativeSpotsCheckBox = new EzVarBoolean("Display Putative Endocytosis Sites", false);
		EzVarBoolean displayEndoCheckBox = new EzVarBoolean("Display Endocytosis Sites", false);

		EzVarBoolean advanced = new EzVarBoolean("Show advanced parameters", false);
		EzVarDouble minTubesDistance = new EzVarDouble("Min. distance between endocytosis sites",5, 0, 100, 1);
		EzVarDouble maxSearchDistance = new EzVarDouble("Max. search distance of spots to sites",10, 0, 100, 1);
		EzVarDouble TubeThreshold= new EzVarDouble("Threshold to detect endocytosis sites",10, 0, 100, 1);;
		EzVarDouble maxGap= new EzVarDouble("Max. gap closing",5, 0, 100, 1);
		EzVarDouble minDuration= new EzVarDouble("Min. tube duration",5, 0, 100000, 1);
		EzVarDouble maxDuration= new EzVarDouble("Max. tube duration",1000, 0, 1000000, 1);
		
		
		protected EzVarBoolean exportExcel = new EzVarBoolean("Export to Excel",false);
		protected EzVarFile exportExcelFile = new EzVarFile("Excel file", "");

		ArrayList<UDWTScale> UDWTScaleArrayList = new ArrayList<UDWTScale>();
				
				
		private int getNumberOfMaxEnabledScale() {
			int maxScale = 0;
			for (UDWTScale scale : UDWTScaleArrayList) {
				if (scale.isEnabled()) {
					if (scale.scaleNumber > maxScale)
						maxScale = scale.scaleNumber;
				}
			}
			return maxScale;

		}

		private int getNumberOfScale() {
			return UDWTScaleArrayList.size();
		}

		private double getScaleThreshold(int scale) {
			return UDWTScaleArrayList.get(scale).getThreshold();
		}

		private boolean isScaleEnabled(int scale) {
			return UDWTScaleArrayList.get(scale).isEnabled();
		}

		private double getMinTubesDistance() {
			double minDist;
			try {
				minDist = minTubesDistance.getValue();				
			} catch (NumberFormatException nfe) {
				minDist = 0;				
			}
			return minDist;
		}

		private double getMinTubesDuration() {
			double minDur;
			try {
				minDur = minDuration.getValue();				
			} catch (NumberFormatException nfe) {
				minDur = 0;				
			}
			return minDur;
		}
		private double getMaxTubesDuration() {
			double maxDur;
			try {
				maxDur = maxDuration.getValue();				
			} catch (NumberFormatException nfe) {
				maxDur = 0;				
			}
			return maxDur;
		}
		private double getMaxSearchDistance() {
			double maxDist;

			try {
				maxDist = maxSearchDistance.getValue();				
			} catch (NumberFormatException nfe) {
				maxDist = 0;				
			}
			return maxDist;
		}

		private double getTubeThreshold() {
			double tubeThres;

			try {
				tubeThres = TubeThreshold.getValue();				
			} catch (NumberFormatException nfe) {
				tubeThres = 0;				
			}
			return tubeThres;
		}
		
		private double getMaxGapClosing() {
			double maxGapp;
			try {
				maxGapp = maxGap.getValue();				
			} catch (NumberFormatException nfe) {
				maxGapp = 0;				
			}
			return maxGapp;
		}

		
		
		
		private class ImageMathInfo {
			double mad;
		}

		public double getVar(double[] data) {
			if (data.length <= 1)
				return 0;

			double sum = 0;
			double sum2 = 0;
			double val;

			for (int i = 0; i < data.length; i++) {
				val = data[i];
				sum2 += val * val;
				sum += val;
			}

			return (sum2 - sum * sum / data.length) / (data.length - 1);
		}

		public double getMean(float[] data) {
			double mean = 0;
			double sum = 0;

			for (int i = 0; i < data.length; i++) {
				sum += data[i];
			}

			if (data.length > 0)
				mean = sum / data.length;

			return mean;
		}

		/**
		 * 
		 * @return
		 */
		public double getMeanAverageDistance(float[] data) {
			double mean = getMean(data);
			double a = 0;
			double s;

			for (int i = 0; i < data.length; i++) {
				s = data[i] - mean;
				a = a + Math.abs(s);
			}

			if (data.length > 0)
				return a / data.length;
			return 0;
		}

		/**
		 * 
		 * @param m
		 * @return
		 */
		private ImageMathInfo avesigma(float[] image) {
			ImageMathInfo ic = new ImageMathInfo();
			ic.mad = getMeanAverageDistance(image);

			return ic;

		}

		/**
		 * filtre les coefficients sans imposer leur binarisation
		 * 
		 * @param data
		 *            : ceci est le tableau
		 */
		private void filter_wat(float[] data, int depth, int width, int height) {

			if (!isScaleEnabled(depth)) // if the scale is not selected, fill of 0.
										// could be optimized by not rebuilding it.
			{
				for (int i = 0; i < data.length; i++) {
					data[i] = 0;
				}
				return;
			}

			// Init lambda value
			double lambdac[] = new double[getNumberOfScale() + 2];

			for (int i = 0; i < getNumberOfScale() + 2; i++) {
				// ( 1 << (2*i) ) ) gives 1 , 4 , 16 , 64 , 256 , 1024 ...
				lambdac[i] = Math.sqrt(2 * Math.log(width * height / (1 << (2 * i))));
			}

			ImageMathInfo imageCaract = avesigma(data);

			double dcoeff[] = new double[5];

			for (int i = 0; i < getNumberOfMaxEnabledScale(); i++) {
				dcoeff[i] = getScaleThreshold(i) / 100.0d;
			}
			double coeffThr = (lambdac[depth + 1] * imageCaract.mad) / dcoeff[depth];
			int inc=0;

			for (int i = 0; i < data.length; i++) {
				if (data[i] < coeffThr) {
					data[i] = 0;
				}
				if (data[i]>coeffThr){
					inc++;
				}				
				}
			inc=inc+0;
			}


		// construct the detection results for all t
		private double[][] detectionResults(Sequence sequence) {
			int numScales = getNumberOfMaxEnabledScale();
			int width = sequence.getImage(0, 0).getWidth();
			int height = sequence.getImage(0, 0).getHeight();
			// le tableau contenant le cumul des spots
			double[][] detectionResults = new double[sequence.getSizeT()][width * height];

			// 2D Image
			if (sequence.getSizeZ() == 1) {
				for (int t = 0; t < sequence.getSizeT(); t++) {
					IcyBufferedImage image = sequence.getImage(t, 0);
					float[] DetectionResult = new float[image.getWidth() * image.getHeight()];

					if (image != null) {
						// compute scales
						final float dataIn[] = Array1DUtil.arrayToFloatArray(image.getDataXY(0), image.getDataType_()
								.isSigned());
						// decompose the image
						B3SplineUDWT waveletTransform = new B3SplineUDWT();

						float[][] scales;
						try {
							scales = waveletTransform.b3WaveletScales2D(dataIn, image.getWidth(), image.getHeight(),
									numScales);
						} catch (WaveletConfigException e1) {
							e1.printStackTrace();
							return detectionResults;
						}
						float[][] coefficients = waveletTransform.b3WaveletCoefficients2D(scales, dataIn, numScales,
								image.getWidth() * image.getHeight());

						for (int i = 0; i < coefficients.length - 1; i++) {
							if (bright.getValue()==false) {
								for (int ii = 0; ii < coefficients[i].length; ii++) {
									coefficients[i][ii] = -coefficients[i][ii];
								}
							}
							filter_wat(coefficients[i], i, sequence.getWidth(), sequence.getHeight());
						}

						// extrait les spots apres threshold des coeff

						waveletTransform.b3SpotConstruction2D(coefficients, DetectionResult, numScales, image.getWidth()
								* image.getHeight(), UDWTScaleArrayList);

					}
					for (int i = 0; i < detectionResults[t].length; i++) {
						detectionResults[t][i] = DetectionResult[i];
					}
				}
				return detectionResults;
			}// 2D
			else // 3D
			{
				return detectionResults;
			}
		}

		// construct position of tubes from the detection results
		private ArrayList<Point3D> getTubesPositions(Sequence sequence, double[][] detectionResults, double minDistance, int height, int width) {
			// on ajoute les spots a cumulativeSpots
			double[] cumulativeSpot = new double[detectionResults[0].length];
			// initialisation
			for (int j = 0; j < detectionResults[0].length; j++) {
				cumulativeSpot[j] = 0;
			}
	double mean=0;int inc=0;

			for (int i = 0; i < detectionResults.length; i++) {
				for (int ii = 0; ii < detectionResults[i].length; ii++) {
					cumulativeSpot[ii] += detectionResults[i][ii];
					if (detectionResults[i][ii]>0)
					{
						mean+=detectionResults[i][ii];inc+=1;
					}
				}
			}

			mean = mean/inc;
			double thresholdValue = getTubeThreshold();
			
			System.out.println(" - Max: " + ArrayMath.max(cumulativeSpot));
			System.out.println(" - Mean: " + ArrayMath.mean(cumulativeSpot));

			ArrayList<Point3D> tubesPositions = new ArrayList<Point3D>(50);

			IcyBufferedImage cumulativeImage = new IcyBufferedImage(width, height, 1, DataType.DOUBLE);
			Array1DUtil.arrayToArray(cumulativeSpot, cumulativeImage.getDataXY(0), cumulativeImage.getDataType_()
					.isSigned());
			cumulativeImage.dataChanged();

			double[] cumulativeTab = Array1DUtil.arrayToDoubleArray(cumulativeImage.getDataXY(0),
					cumulativeImage.isSignedDataType());

			LocalMaximaDetector lmd = new LocalMaximaDetector(cumulativeImage);
			lmd.detectLocalMaxima(minDistance);// va detecter les
												// maxima=points
			// on ajoute ensuite les maxima locaux a la liste de positions des tubes
			ArrayList<ROI2D> roiArrayList = sequence.getROI2Ds();
		
			if (roiArrayList.size() == 0) {
			// creat a rectangle Roi
				ROI2DRectangle roi = new ROI2DRectangle(new Point2D.Double(0, 0), new Point2D.Double(sequence.getWidth(),
						sequence.getHeight()));
				roiArrayList.add(roi);
			}
			
			for (double[] max : lmd.maxima) {
				// keep only max>mean*gap
				//if (cumulativeTab[(int) max[0] + (int) max[1] * width] > mean * gapValue) {
				if (cumulativeTab[(int) max[0] + (int) max[1] * width] > mean * thresholdValue) {
					Point3D point = new Point3D(max);
					for (ROI2D roi : roiArrayList) {
							if (roi.contains(max[0], max[1])) {
								tubesPositions.add(point);
							}				
					}
					
				}
			}
			return tubesPositions;
		}

				private void tubesUpdate2(Sequence sequence, ArrayList<Tube> Tubes, double maxDistance, int width,
				Vector<Spot> detections, int t) {
			// on veut mettre a jour la liste de tubes
			// On parcourt la liste des tubes et on associe les spots qui sont a
			// l'interieur d'un rayon
			// donne (ROI)

			ArrayList<ROI2D> roiArrayList = sequence.getROI2Ds();
			HashMap<ROI2D, Vector<Spot>> ROI2Detection = detectionsInRoi(sequence, detections, roiArrayList);

			double d = maxDistance + 1;
			int index = 0;

			for (ROI2D roi : ROI2Detection.keySet()) {
				Vector<Spot> detect = ROI2Detection.get(roi);

				//	for (Spot spot1 : detect) {
				for (int isp=0; isp<detect.size();isp++) {
					Spot spot1 = detect.get(isp);
					Point3D p = new Point3D();
					p.x = spot1.mass_center.x;
					p.y = spot1.mass_center.y;
					d = maxDistance + 1;
					// on fait ensuite une boucle sur tout les tubes sur "on" pour
					// determiner
					// lequel contient le SPOT no k
					for (int j = 0; j < Tubes.size(); j++) { 
						if (Tubes.get(j).on == true) {
							double dist = computeDistance(p, Tubes.get(j).position);
							if (dist < d) {
								d = dist;
								index = j;
							}
						}
					}
					// Remarque, le tube d'index est necessairement sur on!
					// on ajoute ensuite le point 3d correspondant k = j * width
					// + i au tube numero index si le tube le plus proche n'est pas a
					// une distance > distance max
					if (d < maxDistance) {
						// si le tube est vide, on initialise la detectionList avec le
						// spot correspondant au pixel
						if (Tubes.get(index).DetectionList == null) {
							// on cree le spot que l'on ajoutera ensuite a la detection
							// list
							DetectionSpot spot = new DetectionSpot();
							spot.points.add(p);
							spot.computeMassCenter();
							spot.setT(t);
							spot.minIntensity = spot1.minIntensity;
							spot.meanIntensity = spot1.meanIntensity;
							spot.maxIntensity = spot1.maxIntensity;
							Tubes.get(index).addNewSpotToTube(spot);
							// gere la creation de la detectionList
						}
						else{// une detection existe
							// sinon on cree le spot que l'on ajoute au tube si l'on
							// n est pas au dela du gap closing
																			
							DetectionSpot spot = new DetectionSpot();
							for (int pi = 0; pi<spot1.point3DList.size();pi++) {
								Point3D pt = new Point3D(); 
								pt.x= spot1.point3DList.get(pi).x; 
								pt.y= spot1.point3DList.get(pi).y; // Point3D nch
								spot.points.add(pt);
							}
							spot.computeMassCenter();
							//spot.setMassCenter(p);
							spot.setT(t) ;
							spot.minIntensity = spot1.minIntensity;
							spot.meanIntensity = spot1.meanIntensity;
							spot.maxIntensity = spot1.maxIntensity;
							
							ArrayList<DetectionSpot> DetectionListe = Tubes.get(index).DetectionList;
							DetectionSpot s = DetectionListe.get(DetectionListe.size()-1);
							
							if (s.getT() ==t)
							{							
								Point3D pp=s.getMassCenter();
								double dista = computeDistance(pp, Tubes.get(index).position);
								if (d<dista)
								{
									Tubes.get(index).setLastDetectionSpot(spot);
								}							
							}
							else
							{
							DetectionSpot lastSpot = Tubes.get(index).getLastDetectionSpot();							
							if ((t - lastSpot.getT()) > getMaxGapClosing()) {
									// on met l'ancien tube sur off
									Tubes.get(index).on = false;
									// on cree un nouveau tube a partir de la
									// liste de detection
									ArrayList<DetectionSpot> DetectionList = new ArrayList<DetectionSpot>();
									DetectionList.add(spot);
									Tube neo = new Tube(Tubes.get(index).position, DetectionList);
									Tubes.add(neo);} 
								else {
									Tubes.get(index).addNewSpotToTube(spot);
									}														
							}
							}
						}
					}
			}
		}

		//FIXME: Fonctionne en t ?
		private 	HashMap<ROI2D, Vector<Spot>> detectionsInRoi(Sequence sequence, Vector<Spot> detection,
				ArrayList<ROI2D> roiArrayList ){		
			// create a hashMap with the detections binded to ROI
		
			
			HashMap<ROI2D, Vector<Spot>> ROI2Detection = new HashMap<ROI2D, Vector<Spot>>();

			if (roiArrayList.size() == 0) {
				ROI2Detection.put(new ROI2DRectangle(new Point2D.Double(0, 0), new Point2D.Double(sequence.getWidth(),
						sequence.getHeight())), (Vector<Spot>) detection.clone());
			} else { // there is ROI is the sequence
		
				// setup hashMap
				for (ROI2D roi : roiArrayList) {
					ROI2Detection.put(roi, new Vector<Spot>());
				}
		
				// fill hashMap
				for (ROI2D roi : roiArrayList) {
					for (Spot spot : detection) {
						if (roi.contains(spot.mass_center.x, spot.mass_center.y)) {
							ROI2Detection.get(roi).add(spot);
						}
					}
				}
			}
		
			
			// rebuild the detectionResult with what has been found in ROIs
			detection.clear();
			for (ROI2D roi : ROI2Detection.keySet()) {
				for (Spot s : ROI2Detection.get(roi)) {
					detection.add(s);
				}
			}

			if (detection.size() == 0) {
				new AnnounceFrame("There is no detection associated with the ROI(s)");
				//return;//FIXME: sortir 
			}

			return(ROI2Detection);
		}
		
		// Methode existante ?
		private double computeDistance(Point3D p3d, Point3D coord) {
			double d = 0;

			d += (p3d.x - coord.x) * (p3d.x - coord.x);
			d += (p3d.y - coord.y) * (p3d.y - coord.y);

			Math.sqrt(d);
			return (d);
		}

				public static void sendTracksToPool(final TrackGroup trackGroup,
				final Sequence sequence) {
			SwingUtilities.invokeLater(new Runnable()
			{
				@Override
				public void run() {
					// Add the given trackGroup
					SwimmingObject result = new SwimmingObject(trackGroup);// should
					Icy.getMainInterface().getSwimmingPool().add(result);
					TrackManager manager = new TrackManager();
					if (sequence != null)
						manager.setDisplaySequence(sequence );
					new AnnounceFrame("Tracking results exported to Track manager plugin");
				}
			});
		}
		
		   
			
		@Override
		public void clean() {
			// TODO Auto-generated method stub
			
		}

		@Override
		
		protected void execute() {
			
			//initialisation excel
			int row = 0;		
			WritableWorkbook WW = null;
			WritableSheet WS = null;
			if (exportExcel.getValue()) {
				int page = 1;
				try {
					File f = exportExcelFile.getValue(true);
					if (!FileUtil.getFileExtension(f.getPath(), false)
							.equalsIgnoreCase("xls"))
						f = new File(f.getPath() + ".xls");
					WW = XLSUtil.loadWorkbookForWrite(f); 
					}							
				 catch (Exception e) {
					e.printStackTrace();
					return;}			
				WS  = XLSUtil.createNewPage(WW, "Page" + page);
				XLSUtil.setCellString(WS, 0, 0, "Date of XLS page:");
				row++;
				XLSUtil.setCellString(WS, 0, row, new Date().toString());			
				row++;}

			
			UDWTScaleArrayList.clear();
			for (int i = 0;i<scale.getValue()-1;i++)
			{UDWTScale sc = new UDWTScale(i+1, false, threshold.getValue());UDWTScaleArrayList.add(sc);}
			UDWTScale sc = new UDWTScale(scale.getValue(), true, threshold.getValue());UDWTScaleArrayList.add(sc);
				
				double[][] detections = detectionResults(sequence.getValue());
			
							
				
				int height = sequence.getValue().getHeight();
				int width = sequence.getValue().getWidth();
				// initialisation des sequences de visualisation
				Sequence SpotsSequence = new Sequence();
				SpotsSequence.setName("Spots");
				
				Sequence endoSequence = new Sequence();
				endoSequence.setName("Spots endo");
				
				Sequence CumulativeSpotsSequence = new Sequence();
				CumulativeSpotsSequence.setName("Cumulative Spots");
				// ////////////initialisation cumulative spots
				final IcyBufferedImage cumulativeSpots = new IcyBufferedImage(width, height, 1, DataType.DOUBLE);
				// le tableau contenat le cumul des spots
				double[] cumulativeSpot = new double[width * height];
				// on initialise le deux tableaux a 0
				for (int i = 0; i < cumulativeSpot.length; i++) {
					cumulativeSpot[i] = 0;
				}
				// /////////////////////////////////////////////////

				double minDist = getMinTubesDistance();
				double maxDist = getMaxSearchDistance();
				ArrayList<Point3D> TubesPositions = getTubesPositions(sequence.getValue(), detections, minDist, height, width);

				// initialisation des tubes a partir des tubes positions
				ArrayList<Tube> tubes = new ArrayList<Tube>();
				// pour chaque position, on cree un spot et on initialise 
				// le tube correspondant
				for (int j = 0; j < TubesPositions.size(); j++) {
					Point3D position = TubesPositions.get(j);
					Tube tube = new Tube(position);
					// on vient d'initialiser le j eme tube a partir de la jieme
					// position et on ajoute donc ce tube a la liste de tubes
					tubes.add(j, tube);
				}
				//int highSizeValue = intervalSize.getCurrentHighValue() ;
				//int lowSizeValue = intervalSize.getCurrentLowValue() ;
				
				// boucle en temps et construction iteratives des tubes
				for (int t = 0; t < sequence.getValue().getSizeT(); t++) {					
					final IcyBufferedImage image = new IcyBufferedImage(width, height, 1, DataType.DOUBLE);

					// on remplit les images spots et tubes
					Array1DUtil.arrayToArray(detections[t], image.getDataXY(0), image.getDataType_().isSigned());
					image.dataChanged();
								
					Sequence s = new Sequence(image);
					Map<Integer, List<ConnectedComponent>> m = ConnectedComponents.extractConnectedComponents(s, null);
					List<ConnectedComponent> l = m.get(0);
					//on cr�e un vector de Spotcorrespondant aux CC
					Vector<Spot> detectionsSpots = new Vector<Spot>();
					for (ConnectedComponent CC:l){				
						double[] minI = CC.computeMinIntensity(sequence.getValue());double[] maxI = CC.computeMaxIntensity(sequence.getValue());double[] meanI = CC.computeMeanIntensity(sequence.getValue());
						Spot sp = new Spot(CC.getMassCenter().x, CC.getMassCenter().y, CC.getMassCenter().z, minI[0], maxI[0], meanI[0]);				
						for (Point3i pt:CC.getPoints())
						{plugins.nchenouard.spot.Point3D p = new plugins.nchenouard.spot.Point3D((double)pt.x,(double) pt.y,(double) pt.z);
						sp.point3DList.add(p);
						}
						
						detectionsSpots.add(sp);
					}
					//Vector<Spot> detectionsSpots = detectionsFromswp.getDetectionsAtT(t);
					Vector<Spot> detectionsSpotsFiltre = (Vector<Spot>) detectionsSpots.clone();
					//on fait le filtre!
					
					//ici, on update les tubes avec les detections"filtr�es (apr�s avoir enlever les spots avec tres peu de pixels!)
					tubesUpdate2(sequence.getValue() , tubes, maxDist, width, detectionsSpotsFiltre, t);
					//	tubesUpdate(tubes, maxDist, width, detections, t);
					// remplissage des sequenses spots, cumulative spots et tubes
					// give spots and binary spots
					final IcyBufferedImage imageOut = new IcyBufferedImage(width, height, 1, DataType.DOUBLE);

					// on ajoute les spots au temps t a cumulativeSpots
					for (int i = 0; i < cumulativeSpot.length; i++) {
						cumulativeSpot[i] += detections[t][i];
					}
					// on remplit les images spots et tubes
					Array1DUtil.arrayToArray(detections[t], imageOut.getDataXY(0), imageOut.getDataType_().isSigned());
					imageOut.dataChanged();

					
					// remplissage des sequences		
					SpotsSequence.setImage(t, 0, imageOut);						
				}	
				
				//a la fin, il faut enlever les tubes vides (lie au fait que certaines detections ont ete filtrees)
				
				ArrayList<Tube> TubesFiltre = (ArrayList<Tube>) tubes.clone();
				//on fait le filtre!
				for ( Tube tube_ :TubesFiltre){
					if ((tube_.t_final - tube_.t_init < getMinTubesDuration())||(tube_.t_final - tube_.t_init > getMaxTubesDuration()))
					{
						tubes.remove(tube_);				
					}
				}
				//on va a present construire les track segment correspondant aux tubes construits
				TrackGroup tG=new TrackGroup(sequence.getValue());
				tG.setDescription(sequence.getValue().getName());
				for ( Tube tube :tubes){
					ArrayList<Detection> detectionList = new ArrayList<Detection>();
					if (tube.DetectionList!=null){
					for (DetectionSpot ds: tube.DetectionList)
					{
						Point3D p3 = ds.getMassCenter();
						Detection d = new Detection(p3.x, p3.y, p3.z, ds.getT());
						detectionList.add(d);
						
					}
					TrackSegment ts=new TrackSegment(detectionList);
					tG.addTrackSegment(ts);
				}}		
				sendTracksToPool(tG,sequence.getValue()); 
				
				// on copie ensuite le cumul des spots dans la bonne image
				if (displayCumulativeSpotsCheckBox.getValue()) {
				Array1DUtil.arrayToArray(cumulativeSpot, cumulativeSpots.getDataXY(0), cumulativeSpots.getDataType_()
						.isSigned());
				cumulativeSpots.dataChanged();
				// remplissage des sequences
				CumulativeSpotsSequence.setImage(0, 0, cumulativeSpots);		
				// MAJ sequences et affichage des sequences
				SpotsSequence.dataChanged();
				CumulativeSpotsSequence.dataChanged();		

				//avant de marquer les sequences avec les evts d'endocytose, on enleve les ROIs existantes
				SpotsSequence.removeAllROI();
				CumulativeSpotsSequence.removeAllROI();
				
					// display spots
					int r = 2;			
					
					//permet de definir les tubes qui sont effectivement endocytes et les ROI correspondantes
					for (Tube tube : tubes) {
							if (tube.t_final < sequence.getValue().getSizeT() - getMaxGapClosing()) 
							{
								tube.endo = true;
								Point3D p = tube.position;
								Rectangle2D rect = new Rectangle2D.Double((p.x - r), p.y - r, 2 * r, 2 * r);
								ROI2DRectangle roi = new ROI2DRectangle(rect);
								roi.setReadOnly(true);
								SpotsSequence.addROI(roi);
								CumulativeSpotsSequence.addROI(roi);					
						}
					}
					/*if (displaySpotsCheckBox.isSelected()) {
						addSequence(SpotsSequence);}*/
					
						addSequence(CumulativeSpotsSequence);
					}
						
		//on va construire une sequence qui contient specifiquement les spots endocytes
					
				if (displayEndoCheckBox.getValue()) {
				Sequence endo2Sequence = new Sequence();
				endo2Sequence.setName("Spots endo2");
				for (int t = 0; t < sequence.getValue().getSizeT(); t++) {
					final IcyBufferedImage imageOut2 = new IcyBufferedImage(width, height, 1, DataType.DOUBLE);
					// on remplit les images spots et tubes	
					imageOut2.dataChanged();
					// sequence des points endocyes
					endo2Sequence.setImage(t, 0, imageOut2);
				
				}
				// Ne conserver que les tubes endocytes					
					for (Tube tube: tubes) {						
						if (tube.endo==true){
							for (int t=tube.t_init; t<tube.t_final;t++){
								IcyBufferedImage imageEndo2 = endo2Sequence.getImage(t, 0);
								IcyBufferedImage imageIn = SpotsSequence.getImage(t, 0);
								double tabOutEndo[] = Array1DUtil.arrayToDoubleArray(imageEndo2.getDataXY(0), imageEndo2.isSignedDataType());
								double tabIn[] = Array1DUtil.arrayToDoubleArray(imageIn.getDataXY(0), imageIn.isSignedDataType());
								for (DetectionSpot spot:tube.DetectionList) {
									for( Point3D p:spot.points){
										int x = (int) p.x;
										int y = (int) p.y;
										tabOutEndo[x+y*width] = tabIn[x+y*width];								
									}
								}	
								Array1DUtil.arrayToArray(tabOutEndo, imageEndo2.getDataXY(0), imageEndo2.getDataType_().isSigned());
								imageEndo2.dataChanged();
							}
						}
					}
					endo2Sequence.dataChanged();		

				
					addSequence(endo2Sequence);}				
				
				////////////////////////////////////////////////////////////////////
				//export excel
				if (exportExcel.getValue()){				

				int nb = 1;
				int col = 0;

				// summary page

				XLSUtil.setCellString(WS,col, row, "tube : ");
				XLSUtil.setCellString(WS,col + 1, row, "position x: ");
				XLSUtil.setCellString(WS,col + 2, row, "position y: ");
				XLSUtil.setCellString(WS,col + 3, row, "t_init  ");
				XLSUtil.setCellString(WS,col + 4, row, "t_final  ");
				XLSUtil.setCellString(WS,col + 5, row, "duration ");
				XLSUtil.setCellString(WS,col + 6, row, "nb spots ");
				XLSUtil.setCellString(WS,col + 7, row, "mean spots size");
				XLSUtil.setCellString(WS,col + 8, row, "max spots size");
				XLSUtil.setCellString(WS,col + 9, row, "mean intensity");
				XLSUtil.setCellString(WS,col + 10, row, "max intensity");
				XLSUtil.setCellString(WS,col + 11, row, " mean spots size*mean intensity ");		
				XLSUtil.setCellString(WS,col + 12, row, "ratio");
				XLSUtil.setCellString(WS,col + 13, row, "endocytosis");
				row++;

				for (Tube tube : tubes) {

					XLSUtil.setCellNumber(WS,col, row, nb);
					XLSUtil.setCellNumber(WS,col + 1, row, tube.position.x);
					XLSUtil.setCellNumber(WS,col + 2, row, tube.position.y);
					XLSUtil.setCellNumber(WS,col + 3, row, tube.t_init);
					XLSUtil.setCellNumber(WS,col + 4, row, tube.t_final);
						double duration = tube.t_final - tube.t_init + 1;
						XLSUtil.setCellNumber(WS,col + 5, row, duration);

						if (tube.DetectionList!=null){
						double[] arrayMeanSizeSpot = new double[tube.DetectionList.size()];
						double[] arrayMaxSizeSpot = new double[tube.DetectionList.size()];
						double[] arrayMeanIntensitySpot = new double[tube.DetectionList.size()];
						double[] arrayMaxIntensitySpot = new double[tube.DetectionList.size()];
						int ind = 0;
						for (DetectionSpot spot : tube.DetectionList) {
							arrayMeanSizeSpot[ind] = spot.points.size();
							arrayMaxSizeSpot[ind] = spot.points.size();
							arrayMeanIntensitySpot[ind] = spot.meanIntensity;
							arrayMaxIntensitySpot[ind] = spot.maxIntensity;
							ind++;
						}
						XLSUtil.setCellNumber(WS,col + 6, row, ind); // ind=nbSpots
						if (ind > 0){
							XLSUtil.setCellNumber(WS,col + 7, row, ArrayMath.mean(arrayMeanSizeSpot));
							XLSUtil.setCellNumber(WS,col + 8, row, ArrayMath.max(arrayMaxSizeSpot));
							XLSUtil.setCellNumber(WS,col + 9, row, ArrayMath.mean(arrayMeanIntensitySpot));
							XLSUtil.setCellNumber(WS,col + 10, row, ArrayMath.max(arrayMaxIntensitySpot));
							XLSUtil.setCellNumber(WS,col + 11, row, ArrayMath.mean(arrayMeanIntensitySpot)*ArrayMath.mean(arrayMeanSizeSpot));
						}
						XLSUtil.setCellNumber(WS,col + 12, row, ind / duration);}
						
						if (tube.endo==true) {XLSUtil.setCellNumber(WS,col + 13, row, 1);}
						else {XLSUtil.setCellNumber(WS,col + 13, row, 0);}
							
						row++;
						nb++;
					}

				/*WritableSheet WS2 = null;
				WS2  = XLSUtil.createNewPage(WW, "Page 2");
				nb = 1;
				col = 0;
				row = 0;

				for (Tube tube : tubes) {			
					XLSUtil.setCellString(WS2,col, row, "tube : " + nb);
					row++;
					XLSUtil.setCellString(WS2,col, row, "t_init : ");
					XLSUtil.setCellNumber(WS2,col + 1, row, tube.t_init);
					row++;

					XLSUtil.setCellString(WS2,col, row, "t_final : ");
					XLSUtil.setCellNumber(WS2,col + 1, row, tube.t_final);
					row++;

					XLSUtil.setCellString(WS2,col, row, "position : ");
					XLSUtil.setCellNumber(WS2,col + 1, row, tube.position.x);
					XLSUtil.setCellNumber(WS2,col + 2, row, tube.position.y);
					row++;

					row++;

					XLSUtil.setCellString(WS2,col, row, "spot # : ");
					XLSUtil.setCellString(WS2,col + 1, row, "time : ");
					XLSUtil.setCellString(WS2,col + 2, row, "spots size : ");
					XLSUtil.setCellString(WS2,col + 3, row, "mean intensity: ");
					XLSUtil.setCellString(WS2,col + 4, row, "spots size*mean intensity: ");
					row++;
					int nbsp = 1;
					if (tube.DetectionList !=null)
					for (DetectionSpot spot : tube.DetectionList) {
						XLSUtil.setCellNumber(WS2,col, row, nbsp++);
						XLSUtil.setCellNumber(WS2,col + 1, row, spot.getT());
						XLSUtil.setCellNumber(WS2,col + 2, row, spot.points.size());
						XLSUtil.setCellNumber(WS2,col + 3, row, spot.meanIntensity);
						XLSUtil.setCellNumber(WS2,col + 4, row, spot.meanIntensity*spot.points.size());
						row++;
					}

					int colOffset = 5;
					int rowOffset = 0;
					col = col + colOffset;
					row = 0;					
					nb++;
					
				}	*/	

			}
		

				
///////////////////////////////	
if (exportExcel.getValue()) {
try {
XLSUtil.saveAndClose(WW);
} catch (WriteException e) {
// TODO Auto-generated catch block
e.printStackTrace();
} catch (IOException e) {
// TODO Auto-generated catch block
e.printStackTrace();}
}
	
			}
				

		@Override
		protected void initialize() {
			// TODO Auto-generated method stub
		super.addEzComponent(sequence);
		super.addEzComponent(bright);
	    
		super.addEzComponent(scale);
		super.addEzComponent(threshold);
			
		super.addEzComponent(displayCumulativeSpotsCheckBox);
		super.addEzComponent(displayEndoCheckBox);

		addEzComponent(new EzGroup("Advanced parameters",advanced,TubeThreshold, minTubesDistance,maxSearchDistance,maxGap,minDuration,maxDuration));
		advanced.addVisibilityTriggerTo(TubeThreshold, true);
		advanced.addVisibilityTriggerTo(minTubesDistance, true);
		advanced.addVisibilityTriggerTo(maxSearchDistance, true);
		advanced.addVisibilityTriggerTo(maxGap, true);
		advanced.addVisibilityTriggerTo(minDuration, true);
		advanced.addVisibilityTriggerTo(maxDuration, true);
		
		addEzComponent(new EzGroup("Export",exportExcel, exportExcelFile));		
		exportExcel.addVisibilityTriggerTo(exportExcelFile, true);		
		}

	}

