

import sys
import os

from icy.file import Loader
from icy.gui.dialog import MessageDialog
from java.io import File
from java.awt import EventQueue
from plugins.adufour import ezplug

import callosecountermaincascade

# interface
class CalloseCounter(ezplug.EzPlug):
    def __init__(self):
        ezplug.EzPlug.__init__(self)
        self.input_select = ezplug.EzVarText("Input select",
                                             ["----------------------------",
                                              "Active sequence",
                                              "Batch processing"],
                                             0,False)
        self.active = ezplug.EzVarSequence("input file")
        self.batch = ezplug.EzVarFolder("input folder",None)
        self.input_box = ezplug.EzGroup("Input",[self.input_select,
                                                 self.active,
                                                 self.batch])
        
        self.pypath = ezplug.EzVarText("python path",["default","usr select"],
                                       0,False)
        self.setpath = ezplug.EzVarFile("set pass", None)


        self.upper = ezplug.EzVarInteger("upper limit (pixel)",3,3,999,2)
        self.lower = ezplug.EzVarInteger("lower limit (pixel)",3,3,999,2)
        self.thresh = ezplug.EzVarInteger("threshold value")
        self.parm_box = ezplug.EzGroup("Parameters",
                                       [self.upper,self.lower,self.thresh])


        self.export_bin = ezplug.EzVarBoolean("Export binary image (.png)", 
                                              True)
        self.export_out = ezplug.EzVarBoolean("Export detection image (.png)", 
                                              True)
        self.export_data = ezplug.EzVarBoolean("Export detection data (.txt)", 
                                               True)
        self.export_box = ezplug.EzGroup("Output",
                                         [self.export_bin,self.export_out,
                                          self.export_data])


    def getName(self):
        return "Callose Counter"

    def initialize(self):
        self.addEzComponent(self.input_box)
        self.addEzComponent(self.pypath)
        self.addEzComponent(self.setpath)
        self.addEzComponent(self.export_box)
        self.addEzComponent(self.parm_box)
        

        self.input_select.addVisibilityTriggerTo(self.active,"Active sequence")
        self.input_select.addVisibilityTriggerTo(self.batch,"Batch processing")
        self.pypath.addVisibilityTriggerTo(self.setpath,"usr select")
        
    def execute(self):
        # parameters for spot detection
        parm = [self.upper.getValue(),
                self.lower.getValue(),
                self.thresh.getValue()]
        
        # parameters for exporting result image and data
        export = [self.export_out.getValue(),
                  self.export_bin.getValue(),
                  self.export_data.getValue()]
        
        # set python path
        pypath = self.pypath.getValue()
        setpath = self.setpath.getValue()
        
        if pypath == "default" :
            pypath = None
        elif pypath == "usr select" and setpath != None :
            pypath = str(setpath)
        else :
            pypath = None


        usrsetting = {"export_out":export[0],"export_bin":export[1],
                      "export_data":export[2],"parm":parm, "pypath":pypath}

        # input: Active sequence or Batch processing
        is_act_seq = True
        selection = self.input_select.getValue()

        # Active sequence
        if selection == "Active sequence":

            input_seq = self.active.getValue()

            ### main processing
            callosecountermaincascade.mainCascade(usrsetting, input_seq,
                                                  is_act_seq)

        # Batch processing
        elif selection == "Batch processing":
            is_act_seq = False

            if self.batch.getValue() == None:
                MessageDialog.showDialog("Please select the processing folder.")
                return
            
            input_folder = str(self.batch.getValue()) + os.sep 
            input_list = os.listdir(input_folder)
            
            file_list = []
            for i in input_list:
                if os.path.isfile(input_folder + i):
                    ext = os.path.splitext(input_folder + i)[1]
                    if (ext == ".png" or ext == ".jpg" or
                        ext == ".tif" or ext == ".bmp"):
                        file_list.append(input_folder + i)
                    else:
                        None
                else:
                    None
            ### main processing
            for f in file_list:
                input_seq = Loader.loadSequence(File(f))
                callosecountermaincascade.mainCascade(usrsetting,input_seq,
                                                      is_act_seq)
        else:
            MessageDialog.showDialog("Please select the option : \"Active sequence\" or \"Batch Processing\" in input select.")
        
        return
        
    def clean(self):
        return


def run():
    cc = CalloseCounter()
    cc.compute()

run()
