/*
 * Decompiled with CFR 0.152.
 */
package kovac.binaryMask;

import icy.gui.frame.progress.CancelableProgressFrame;
import icy.gui.frame.progress.ProgressFrame;
import icy.system.thread.ThreadUtil;
import icy.type.point.Point3D;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kovac.binaryMask.BinaryMask;
import kovac.binaryMask.BoundingBox;
import kovac.res.quadric.QuadricExpression;

public class ConcurrentBoundingBoxTreatment
extends Thread {
    private BoundingBox box;
    int[] bounds;
    QuadricExpression quad;
    ProgressFrame progress;

    public ConcurrentBoundingBoxTreatment(BoundingBox b) {
        this.box = b;
        this.progress = new CancelableProgressFrame("Handling stacks");
    }

    @Override
    public void run() {
        this.treatBox();
    }

    private void treatBox() {
        double[] preciseBounds = null;
        this.quad = this.box.getAssociatedEquation();
        preciseBounds = this.box.getBounds();
        this.bounds = new int[preciseBounds.length];
        int i = 0;
        while (i < preciseBounds.length) {
            this.bounds[i] = (int)preciseBounds[i];
            ++i;
        }
        ExecutorService exec = ThreadUtil.createThreadPool((String)"Handling Stacks");
        int z = this.bounds[4];
        while (z < this.bounds[5]) {
            exec.execute(new ConcurrentStackTreatment(z));
            ++z;
        }
        this.progress.setLength((double)(this.bounds[5] - this.bounds[4]));
        exec.shutdown();
        try {
            exec.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            System.out.println("Threads didn't finish in time");
        }
    }

    private class ConcurrentStackTreatment
    extends Thread {
        int stack;

        public ConcurrentStackTreatment(int stack) {
            this.stack = stack;
        }

        @Override
        public void run() {
            Point3D.Double testedPoint = null;
            int x = ConcurrentBoundingBoxTreatment.this.bounds[0];
            while (x < ConcurrentBoundingBoxTreatment.this.bounds[1]) {
                int y = ConcurrentBoundingBoxTreatment.this.bounds[2];
                while (y < ConcurrentBoundingBoxTreatment.this.bounds[3]) {
                    if (x >= ConcurrentBoundingBoxTreatment.this.bounds[0] && x <= ConcurrentBoundingBoxTreatment.this.bounds[1] && y >= ConcurrentBoundingBoxTreatment.this.bounds[2] && y <= ConcurrentBoundingBoxTreatment.this.bounds[3] && this.stack >= ConcurrentBoundingBoxTreatment.this.bounds[4] && this.stack <= ConcurrentBoundingBoxTreatment.this.bounds[5] && ConcurrentBoundingBoxTreatment.this.quad.isInsideQuadric((Point3D)(testedPoint = new Point3D.Double((double)x, (double)y, (double)this.stack)))) {
                        BinaryMask.addCoordinates(new int[]{x, y, this.stack});
                    }
                    ++y;
                }
                ++x;
            }
            ConcurrentBoundingBoxTreatment.this.progress.incPosition();
        }
    }
}

