/*
 * Decompiled with CFR 0.152.
 */
package plugins.weiss.fitellipsoid;

import icy.common.Version;
import icy.gui.dialog.ConfirmDialog;
import icy.gui.dialog.MessageDialog;
import icy.gui.viewer.Viewer;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.system.thread.ThreadUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import kovac.binaryMask.ExportBinaryMask;
import kovac.res.Points;
import kovac.res.enums.Methods;
import kovac.res.gui.SegOrthoViewer;
import kovac.res.util.LinkedViewersUtil;
import kovac.saving.ExportCSV;
import kovac.saving.Saving;
import kovac.saving.SavingStatic;
import plugins.adufour.ezplug.EzButton;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGUI;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;

public class fitellipsoid
extends EzPlug
implements EzStoppable {
    private static Methods chosenMethod;
    private static boolean hasSetUpImage;
    private static EzGUI currentUI;
    private static EzVarSequence sequenceChoice;
    private static EzVarEnum<Methods> methodChoice;
    private static EzButton exportCSV;
    private static EzButton confirmSequence;
    private static EzButton exportBinary;
    private static EzButton removeLastEllipsoid;
    private static EzButton removeGivenEllipsoid;
    private static EzVarBoolean displayPoints;
    private static ActionListener confirmListener;
    private static EzVarListener<Methods> methodListener;
    private static ActionListener exportListener;
    private static ActionListener exportBinaryListener;
    private static ActionListener removeListener;
    private static ActionListener removeGivenListener;

    public void execute() {
        if (!LinkedViewersUtil.areSet()) {
            MessageDialog.showDialog((String)"No sequence confirmed, the plugin will stop");
            return;
        }
        switch (fitellipsoid.getChosenMethod()) {
            case ELLIPSES: {
                break;
            }
            case POINTS: {
                Points.saveCurrentList();
                Points.createEllipsoids();
                SegOrthoViewer.SegOrthoCanvas canvas = (SegOrthoViewer.SegOrthoCanvas)LinkedViewersUtil.getOrth().getCanvas();
                canvas.getLock().setSelected(false);
                canvas.setLock(false);
                LinkedViewersUtil.getOrthCanvas().repaint();
                break;
            }
        }
    }

    public void clean() {
        LinkedViewersUtil.clear();
    }

    protected void initialize() {
        Version currentVersion = Icy.version;
        if (currentVersion.isOlder(new Version("1.7.0.0"))) {
            MessageDialog.showDialog((String)"This plugin works only for Version 1.7.0.0 and greater. Please update Icy", (int)0);
            return;
        }
        this.initializeListeners();
        this.initializeGUI();
        this.addEzComponent((EzComponent)sequenceChoice);
        this.addEzComponent((EzComponent)confirmSequence);
        this.addComponent(new JSeparator(0));
        this.addEzComponent((EzComponent)displayPoints);
        this.addEzComponent((EzComponent)methodChoice);
        this.addEzComponent((EzComponent)exportCSV);
        this.addEzComponent((EzComponent)exportBinary);
        this.addEzComponent((EzComponent)removeGivenEllipsoid);
        this.addEzComponent((EzComponent)removeLastEllipsoid);
        methodChoice.addVarChangeListener(methodListener);
        methodChoice.setEnabled(false);
    }

    private void initializeGUI() {
        sequenceChoice = new EzVarSequence("Sequence");
        sequenceChoice.setToolTipText("Choose the sequence to work on");
        methodChoice = new EzVarEnum("Method", (Enum[])Methods.values(), (Enum)Methods.POINTS);
        methodChoice.setToolTipText("Only points are implemented for now");
        exportCSV = new EzButton("Export as CSV", exportListener);
        exportCSV.setToolTipText("Export data as a CSV file");
        exportBinary = new EzButton("Export as Binary Mask", exportBinaryListener);
        exportBinary.setToolTipText("Create a new binary image, where every pixel's value is 0, except for the ones inside an ellipsoid");
        removeGivenEllipsoid = new EzButton("Remove given ellipsoid", removeGivenListener);
        removeGivenEllipsoid.setToolTipText("Removes an ellipsoid given by a number");
        removeLastEllipsoid = new EzButton("Remove last ellipsoid", removeListener);
        removeLastEllipsoid.setToolTipText("Removes the last ellipdoid from list");
        confirmSequence = new EzButton("Confirm sequence", confirmListener);
        displayPoints = new EzVarBoolean("Display points", true);
        currentUI = this.getUI();
    }

    private void initializeListeners() {
        removeGivenListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String number = JOptionPane.showInputDialog(this, (Object)"Enter the number of your ellipsoid:");
                        SavingStatic.removeGiven(number);
                    }
                });
            }
        };
        removeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadUtil.bgRun((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SavingStatic.removeLast();
                    }
                });
            }
        };
        exportBinaryListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadUtil.bgRun((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ExportBinaryMask.exportMask(LinkedViewersUtil.getBaseSeq());
                    }
                });
            }
        };
        exportListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame frame = new JFrame();
                JFileChooser fileChooser = new JFileChooser(Saving.getSavingDirectory());
                fileChooser.setFileFilter(new FileNameExtensionFilter("CSV Files", "csv"));
                int returnVal = fileChooser.showSaveDialog(frame);
                if (returnVal == 0) {
                    ExportCSV.initializeExport(fileChooser.getSelectedFile());
                }
            }
        };
        confirmListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LinkedViewersUtil.areSet()) {
                    LinkedViewersUtil.minimizeViewers();
                }
                fitellipsoid.this.setUpViews();
                if (hasSetUpImage) {
                    do {
                        ThreadUtil.sleep((int)500);
                    } while (LinkedViewersUtil.getBaseSeq() == null);
                    Saving.initializeSaving(LinkedViewersUtil.getBaseSeq());
                    confirmSequence.setText("Change sequence");
                }
            }
        };
        methodListener = new EzVarListener<Methods>(){

            public void variableChanged(EzVar<Methods> source, Methods newValue) {
                chosenMethod = newValue;
                if (chosenMethod == Methods.ELLIPSES) {
                    displayPoints.setVisible(false);
                } else {
                    displayPoints.setVisible(true);
                }
            }
        };
    }

    private void setUpViews() {
        if (LinkedViewersUtil.getBaseSeq() == sequenceChoice.getValue()) {
            return;
        }
        if (!this.checker((Sequence)sequenceChoice.getValue())) {
            return;
        }
        final Sequence seq = SequenceUtil.getCopy((Sequence)((Sequence)sequenceChoice.getValue()));
        final Viewer baseViewer = Icy.getMainInterface().getActiveViewer();
        LinkedViewersUtil.setBaseSeq((Sequence)sequenceChoice.getValue());
        if (baseViewer != null) {
            ThreadUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    LinkedViewersUtil.setVTK(new Viewer(seq));
                    LinkedViewersUtil.goToVTK();
                    LinkedViewersUtil.getVTK().setTitle("3D VTK rendering");
                    LinkedViewersUtil.getVTK().setSize(500, 500);
                    LinkedViewersUtil.setOrth(new Viewer(seq));
                    LinkedViewersUtil.goToSeg();
                    LinkedViewersUtil.getOrth().setTitle("Orthogonal View");
                    LinkedViewersUtil.getOrth().setSize(500, 500);
                    baseViewer.close();
                    LinkedViewersUtil.linkViewers();
                    hasSetUpImage = true;
                }
            });
        }
    }

    private boolean checker(Sequence baseSeq) throws IllegalArgumentException {
        if (baseSeq == null) {
            MessageDialog.showDialog((String)"This plugin needs an image to work");
            confirmSequence.setText("Confirm sequence");
            return false;
        }
        if (baseSeq.getSizeZ() < 2 && baseSeq.getSizeT() > 2) {
            if (!ConfirmDialog.confirm((String)"This plugin requires a stacked image to work, would you like to convert your image to stack ?")) {
                return false;
            }
            SequenceUtil.convertToStack((Sequence)baseSeq);
        }
        return true;
    }

    public static void setRunEnabled(boolean flag) {
        currentUI.setRunButtonEnabled(flag);
    }

    public static Methods getChosenMethod() {
        return chosenMethod;
    }

    public static void setTextSequence(String text) {
        confirmSequence.setText(text);
    }

    public static boolean isDisplayingPoints() {
        return (Boolean)displayPoints.getValue();
    }
}

