/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.kymographtracker;

import icy.main.Icy;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import icy.util.XMLUtil;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class KymographTrackingResults {
    ArrayList<ArrayList<double[]>> tracks1D;
    TrackGroup tracks2D;
    public static String KYMO_TRACKING_RESULTS = "KymographTrackingResults";
    public static String KYMO_TRACK = "KymographTrack";
    public static String TRACKS = "Tracks";
    public static String TIME_LIST = "TimeList";
    public static String POSITION_LIST = "PositionList";
    public static String POSITION_LISTX = "PositionListX";
    public static String POSITION_LISTY = "PositionListY";

    public static void generateDefaultNode(Element node) {
        XMLUtil.setElement((Node)node, (String)KYMO_TRACKING_RESULTS);
    }

    public void saveToXML(Element node) {
        Element nodeKymoResults = XMLUtil.setElement((Node)node, (String)KYMO_TRACKING_RESULTS);
        int i = 0;
        while (i < this.tracks1D.size()) {
            Element nodeTrack = XMLUtil.addElement((Node)nodeKymoResults, (String)KYMO_TRACK);
            String timeString = "";
            String positionString = "";
            int j = 0;
            while (j < this.tracks1D.get(i).size()) {
                timeString = timeString.concat(String.valueOf(this.tracks1D.get(i).get(j)[0]) + ", ");
                positionString = positionString.concat(String.valueOf(this.tracks1D.get(i).get(j)[1]) + ", ");
                ++j;
            }
            XMLUtil.setAttributeValue((Element)nodeTrack, (String)TIME_LIST, (String)timeString);
            XMLUtil.setAttributeValue((Element)nodeTrack, (String)POSITION_LIST, (String)positionString);
            String positionStringX = "";
            String positionStringY = "";
            int j2 = 0;
            while (j2 < ((TrackSegment)this.tracks2D.getTrackSegmentList().get(i)).getDetectionList().size()) {
                positionStringX = positionStringX.concat(String.valueOf(((TrackSegment)this.tracks2D.getTrackSegmentList().get(i)).getDetectionAt(j2).getX()) + ", ");
                positionStringY = positionStringY.concat(String.valueOf(((TrackSegment)this.tracks2D.getTrackSegmentList().get(i)).getDetectionAt(j2).getY()) + ", ");
                ++j2;
            }
            XMLUtil.setAttributeValue((Element)nodeTrack, (String)POSITION_LISTX, (String)positionStringX);
            XMLUtil.setAttributeValue((Element)nodeTrack, (String)POSITION_LISTY, (String)positionStringY);
            ++i;
        }
    }

    public static KymographTrackingResults loadFromXML(Element node, Sequence sourceSequence, String trackGroupName) {
        Element e = XMLUtil.getElement((Node)node, (String)KYMO_TRACKING_RESULTS);
        if (e == null) {
            return null;
        }
        KymographTrackingResults r = new KymographTrackingResults();
        r.tracks1D = new ArrayList();
        r.tracks2D = new TrackGroup(sourceSequence);
        r.tracks2D.setDescription(trackGroupName);
        ArrayList trackElements = XMLUtil.getElements((Node)e, (String)KYMO_TRACK);
        for (Element te : trackElements) {
            String s = XMLUtil.getAttributeValue((Element)te, (String)TIME_LIST, (String)"");
            String[] ss = s.split(",");
            ArrayList<Double> tList = new ArrayList<Double>();
            int i = 0;
            while (i < ss.length) {
                if (!ss[i].trim().isEmpty()) {
                    tList.add(Double.valueOf(ss[i]));
                }
                ++i;
            }
            s = XMLUtil.getAttributeValue((Element)te, (String)POSITION_LIST, (String)"");
            ss = s.split(",");
            ArrayList<Double> pList = new ArrayList<Double>();
            int i2 = 0;
            while (i2 < ss.length) {
                if (!ss[i2].trim().isEmpty()) {
                    pList.add(Double.valueOf(ss[i2]));
                }
                ++i2;
            }
            ArrayList<double[]> trk1D = new ArrayList<double[]>();
            int i3 = 0;
            while (i3 < tList.size()) {
                trk1D.add(new double[]{(Double)tList.get(i3), (Double)pList.get(i3)});
                ++i3;
            }
            r.tracks1D.add(trk1D);
            s = XMLUtil.getAttributeValue((Element)te, (String)POSITION_LISTX, (String)"");
            ss = s.split(",");
            ArrayList<Double> xList = new ArrayList<Double>();
            int i4 = 0;
            while (i4 < ss.length) {
                if (!ss[i4].trim().isEmpty()) {
                    xList.add(Double.valueOf(ss[i4]));
                }
                ++i4;
            }
            s = XMLUtil.getAttributeValue((Element)te, (String)POSITION_LISTY, (String)"");
            ss = s.split(",");
            ArrayList<Double> yList = new ArrayList<Double>();
            int i5 = 0;
            while (i5 < ss.length) {
                if (!ss[i5].trim().isEmpty()) {
                    yList.add(Double.valueOf(ss[i5]));
                }
                ++i5;
            }
            TrackSegment ts = new TrackSegment();
            int i6 = 0;
            while (i6 < xList.size()) {
                ts.addDetection(new Detection(((Double)xList.get(i6)).doubleValue(), ((Double)yList.get(i6)).doubleValue(), 0.0, ((Double)tList.get(i6)).intValue()));
                ++i6;
            }
            r.tracks2D.addTrackSegment(ts);
        }
        Icy.getMainInterface().getSwimmingPool().add(new SwimmingObject((Object)r.tracks2D));
        return r;
    }
}

