/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.rieszwavelets;

import icy.gui.component.pool.SwimmingObjectChooser;
import icy.swimmingPool.SwimmingObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import plugins.nchenouard.isotropicwavelets.WaveletFilterSet;
import plugins.tinevez.rieszwavelets.HarmonicTypes;
import plugins.tinevez.rieszwavelets.RieszConfig;
import plugins.tinevez.rieszwavelets.RieszGeneralization;
import plugins.tinevez.rieszwavelets.RieszWaveletCoefficients;
import plugins.tinevez.rieszwavelets.RieszWaveletConfig;
import plugins.tinevez.rieszwavelets.SequenceAnalysisResults;
import plugins.tinevez.rieszwavelets.StandardRieszFrames;

public class CoefficientSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 7698432379479738937L;
    CoefficientsTableModel coeffTableModel;
    JTable coefficientTable;
    SwimmingObjectChooser resultsBox;

    public CoefficientSelectionPanel() {
        this.setLayout(new BorderLayout());
        this.resultsBox = new SwimmingObjectChooser(SequenceAnalysisResults.class);
        this.add((Component)this.resultsBox, "North");
        this.resultsBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                CoefficientSelectionPanel.this.updateResultsTable();
            }
        });
        this.coeffTableModel = new CoefficientsTableModel();
        this.coefficientTable = new JTable(this.coeffTableModel);
        JScrollPane scrollTablePane = new JScrollPane(this.coefficientTable);
        this.add((Component)scrollTablePane, "Center");
    }

    void updateResultsTable() {
        Object selectedItem = this.resultsBox.getSelectedItem();
        if (selectedItem != null) {
            SequenceAnalysisResults results = (SequenceAnalysisResults)((SwimmingObject)selectedItem).getObject();
            this.coeffTableModel.setResults(results);
        } else {
            this.coeffTableModel.setResults(null);
        }
    }

    public class CoefficientsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -4810024326298005026L;
        SequenceAnalysisResults results = null;
        String[] columnNames = new String[]{"Sequence name", "Frames", "Generalization", "Harmonics", "Harmonics type", "Scales", "Wavelet profile", "Filter high frequencies", "Isotropic padding", "Padding X", "Padding Y"};
        String[] valueList = new String[]{"", "", "", "", "", "", "", "", "", "", ""};

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public void setResults(SequenceAnalysisResults r) {
            this.results = r;
            if (this.results == null) {
                int i = 0;
                while (i < this.valueList.length) {
                    this.valueList[i] = "";
                    ++i;
                }
            } else {
                this.valueList[0] = this.results.getSequenceName();
                this.valueList[1] = Integer.toString(this.results.getAllAnalyzedTimesResults().size());
                RieszWaveletCoefficients rwc = this.results.getAllResults().get(0);
                RieszWaveletConfig config = rwc.getConfig();
                WaveletFilterSet filters = config.getWaveletFilterSet();
                ArrayList<RieszGeneralization> rieszGeneralizationList = rwc.getGeneralizationList();
                ArrayList<StandardRieszFrames> rieszFrameList = new ArrayList<StandardRieszFrames>();
                for (RieszGeneralization rg : rieszGeneralizationList) {
                    rieszFrameList.add(rg.getRieszFrame());
                }
                boolean sameItem = true;
                StandardRieszFrames rieszFrame = (StandardRieszFrames)((Object)rieszFrameList.get(0));
                for (StandardRieszFrames srf : rieszFrameList) {
                    if (srf == rieszFrame) continue;
                    sameItem = false;
                    break;
                }
                String rieszFrameString = "";
                if (sameItem) {
                    rieszFrameString = rieszFrame.toString();
                } else {
                    for (StandardRieszFrames srf : rieszFrameList) {
                        rieszFrameString = rieszFrameString.concat(String.valueOf(srf.toString()) + "; ");
                    }
                }
                this.valueList[2] = rieszFrameString;
                ArrayList<RieszConfig> rieszConfigList = config.getRieszConfigurations();
                ArrayList<int[]> harmonicList = new ArrayList<int[]>();
                ArrayList<HarmonicTypes> harmonicsTypeList = new ArrayList<HarmonicTypes>();
                for (RieszConfig rc : rieszConfigList) {
                    harmonicList.add(rc.harmonics);
                    harmonicsTypeList.add(rc.harmonicType);
                }
                sameItem = true;
                int[] harmonics = (int[])harmonicList.get(0);
                block5: for (int[] h : harmonicList) {
                    if (harmonics.length != h.length) {
                        sameItem = false;
                        break;
                    }
                    int i = 0;
                    while (i < h.length) {
                        if (h[i] != harmonics[i]) {
                            sameItem = false;
                            continue block5;
                        }
                        ++i;
                    }
                }
                String harmonicsString = "";
                if (sameItem) {
                    harmonicsString = "[";
                    int j = 0;
                    while (j < harmonics.length) {
                        harmonicsString = String.valueOf(harmonicsString) + harmonics[j] + ", ";
                        ++j;
                    }
                    harmonicsString = String.valueOf(harmonicsString) + "]";
                } else {
                    for (int[] h : harmonicList) {
                        harmonicsString = String.valueOf(harmonicsString) + "[";
                        int j = 0;
                        while (j < harmonics.length) {
                            harmonicsString = String.valueOf(harmonicsString) + h[j] + ", ";
                            ++j;
                        }
                        harmonicsString = String.valueOf(harmonicsString) + "]; ";
                    }
                }
                this.valueList[3] = harmonicsString;
                sameItem = true;
                HarmonicTypes harmonicsType = (HarmonicTypes)((Object)harmonicsTypeList.get(0));
                for (HarmonicTypes ht : harmonicsTypeList) {
                    if (ht == harmonicsType) continue;
                    sameItem = false;
                    break;
                }
                String harmonicTypeString = "";
                if (sameItem) {
                    harmonicTypeString = harmonicsType.toString();
                } else {
                    for (HarmonicTypes ht : harmonicsTypeList) {
                        harmonicTypeString = harmonicTypeString.concat(String.valueOf(ht.toString()) + "; ");
                    }
                }
                this.valueList[4] = harmonicTypeString;
                this.valueList[5] = Integer.toString(filters.getNumScales());
                this.valueList[6] = filters.getWaveletType().toString();
                this.valueList[7] = Boolean.toString(filters.isPrefilter());
                this.valueList[8] = Boolean.toString(filters.isIsotropicPadding());
                this.valueList[9] = Integer.toString(rwc.getPadX());
                this.valueList[10] = Integer.toString(rwc.getPadY());
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int arg0, int arg1) {
            return this.valueList[arg1];
        }
    }
}

