/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.rieszwavelets;

import icy.common.exception.UnsupportedFormatException;
import icy.file.Loader;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.preferences.ApplicationPreferences;
import icy.preferences.GeneralPreferences;
import icy.sequence.Sequence;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import plugins.nchenouard.isotropicwavelets.IsotropicWaveletType;
import plugins.tinevez.rieszwavelets.HarmonicTypes;
import plugins.tinevez.rieszwavelets.RieszConfig;
import plugins.tinevez.rieszwavelets.RieszGeneralization;
import plugins.tinevez.rieszwavelets.RieszWaveletCoefficients;
import plugins.tinevez.rieszwavelets.RieszWaveletConfig;
import plugins.tinevez.rieszwavelets.StandardRieszFrames;

public class KymographSeparator {
    public static Sequence[] separateKymograph(Sequence kymographSeq) {
        int height = kymographSeq.getSizeY();
        int width = kymographSeq.getSizeX();
        boolean isRealImage = true;
        int numScales = 4;
        boolean prefilter = false;
        IsotropicWaveletType waveletType = IsotropicWaveletType.Simoncelli;
        int order = 6;
        HarmonicTypes harmonicType = HarmonicTypes.even;
        boolean prepareRieszFilters = true;
        RieszWaveletConfig config = new RieszWaveletConfig(width, height, true, 4, waveletType, false, true, 6, harmonicType, false);
        ArrayList<RieszConfig> rieszConfigList = config.getRieszConfigurations();
        ArrayList<RieszGeneralization> generalizationList = new ArrayList<RieszGeneralization>();
        int i = 0;
        while (i < 4) {
            RieszGeneralization rieszGeneralization = new RieszGeneralization(StandardRieszFrames.Simoncelli, rieszConfigList.get(i));
            generalizationList.add(rieszGeneralization);
            ++i;
        }
        double[] image = kymographSeq.getDataXYAsDouble(0, 0, 0);
        RieszWaveletCoefficients anteroCoefficients = config.multiscaleRieszAnalysisInFourier(image, width, height, generalizationList);
        ArrayList<double[][]> retroBands = new ArrayList<double[][]>(anteroCoefficients.getNumScales());
        int i2 = 0;
        while (i2 < anteroCoefficients.getNumScales()) {
            double[][] anteroCoeffs = anteroCoefficients.getRieszBandsAtScale(i2);
            double[][] retroCoeffs = new double[anteroCoeffs.length][];
            int j = 0;
            while (j < anteroCoeffs.length) {
                retroCoeffs[j] = (double[])anteroCoeffs[j].clone();
                ++j;
            }
            retroBands.add(retroCoeffs);
            ++i2;
        }
        double[] retroHPResidual = null;
        if (anteroCoefficients.getHPResidual() != null) {
            retroHPResidual = (double[])anteroCoefficients.getHPResidual().clone();
        }
        double[] retroLPResidual = (double[])anteroCoefficients.getLPResidual().clone();
        RieszWaveletCoefficients retroCoefficients = new RieszWaveletCoefficients(anteroCoefficients.getConfig(), generalizationList, retroBands, retroHPResidual, retroLPResidual, anteroCoefficients.getPadX(), anteroCoefficients.getPadY());
        int i3 = 0;
        while (i3 < retroCoefficients.getNumScales()) {
            double[][] retroCoeffs = retroCoefficients.getRieszBandsAtScale(i3);
            int k = 0;
            while (k < retroCoeffs[0].length) {
                retroCoeffs[0][k] = 0.0;
                ++k;
            }
            int j = 0;
            while (j < retroCoeffs.length / 2) {
                int k2 = 0;
                while (k2 < retroCoeffs[j].length) {
                    retroCoeffs[j][k2] = 0.0;
                    ++k2;
                }
                ++j;
            }
            ++i3;
        }
        int k = 0;
        while (k < retroLPResidual.length) {
            retroLPResidual[k] = 0.0;
            ++k;
        }
        Sequence retroSeq = new Sequence();
        double[] reconstructedImage = config.multiscaleRieszSynthesisInFourier(retroCoefficients, width, height);
        double minRetro = Double.POSITIVE_INFINITY;
        double[] dArray = reconstructedImage;
        int n = reconstructedImage.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (d < minRetro) {
                minRetro = d;
            }
            ++n2;
        }
        int i4 = 0;
        while (i4 < reconstructedImage.length) {
            double d = reconstructedImage[i4];
            reconstructedImage[i4] = d - minRetro + 1.1754943508222875E-38;
            ++i4;
        }
        retroSeq.addImage(0, (BufferedImage)new IcyBufferedImage(width, height, (Object)reconstructedImage));
        i4 = 0;
        while (i4 < anteroCoefficients.getNumScales()) {
            double[][] anteroCoeffs = anteroCoefficients.getRieszBandsAtScale(i4);
            int k3 = 0;
            while (k3 < anteroCoeffs[0].length) {
                anteroCoeffs[0][k3] = 0.0;
                ++k3;
            }
            int j = anteroCoeffs.length / 2 + 1;
            while (j < anteroCoeffs.length) {
                int k4 = 0;
                while (k4 < anteroCoeffs[j].length) {
                    anteroCoeffs[j][k4] = 0.0;
                    ++k4;
                }
                ++j;
            }
            ++i4;
        }
        double[] anteroLPresidual = anteroCoefficients.getLPResidual();
        int k5 = 0;
        while (k5 < anteroLPresidual.length) {
            anteroLPresidual[k5] = 0.0;
            ++k5;
        }
        Sequence anteroSeq = new Sequence();
        double[] reconstructedImage2 = config.multiscaleRieszSynthesisInFourier(anteroCoefficients, width, height);
        double minAntero = Double.POSITIVE_INFINITY;
        double[] dArray2 = reconstructedImage2;
        int n3 = reconstructedImage2.length;
        int n4 = 0;
        while (n4 < n3) {
            double d = dArray2[n4];
            if (d < minAntero) {
                minAntero = d;
            }
            ++n4;
        }
        int i5 = 0;
        while (i5 < reconstructedImage2.length) {
            double d = reconstructedImage2[i5];
            reconstructedImage2[i5] = d - minAntero + 1.1754943508222875E-38;
            ++i5;
        }
        anteroSeq.addImage(0, (BufferedImage)new IcyBufferedImage(width, height, (Object)reconstructedImage2));
        i5 = 0;
        while (i5 < anteroCoefficients.getNumScales()) {
            double[][] anteroCoeffs = anteroCoefficients.getRieszBandsAtScale(i5);
            double[][] retroCoeffs = retroCoefficients.getRieszBandsAtScale(i5);
            int j = anteroCoeffs.length / 2;
            while (j < anteroCoeffs.length) {
                int k6 = 0;
                while (k6 < anteroCoeffs[j].length) {
                    anteroCoeffs[j][k6] = retroCoeffs[j][k6];
                    ++k6;
                }
                ++j;
            }
            ++i5;
        }
        Sequence filteredSeq = new Sequence();
        double[] reconstructedImage3 = config.multiscaleRieszSynthesisInFourier(anteroCoefficients, width, height);
        filteredSeq.addImage(0, (BufferedImage)new IcyBufferedImage(width, height, (Object)reconstructedImage3));
        return new Sequence[]{filteredSeq, anteroSeq, retroSeq};
    }

    public static void main(String[] args) throws UnsupportedFormatException, IOException {
        ApplicationPreferences.load();
        GeneralPreferences.load();
        GeneralPreferences.setAutomaticUpdate((boolean)false);
        Icy.main((String[])new String[]{"--nosplash", "--disableJCL"});
        File file = new File("samples/Path_1_kymograph.tif");
        IcyBufferedImage colorImage = Loader.loadImage((String)file.getAbsolutePath());
        IcyBufferedImage image = colorImage.getImage(0);
        final Sequence seq = new Sequence("source", image);
        final Sequence[] sequences = KymographSeparator.separateKymograph(seq);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Viewer(seq);
                Sequence[] sequenceArray = sequences;
                int n = sequences.length;
                int n2 = 0;
                while (n2 < n) {
                    Sequence sequence = sequenceArray[n2];
                    new Viewer(sequence);
                    ++n2;
                }
            }
        });
    }
}

