/*
 * Decompiled with CFR 0.152.
 */
package impl.danyfel80.sequence.util;

import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.TypeUtil;
import java.util.concurrent.atomic.AtomicBoolean;

public class SequenceVolumeCursor {
    Sequence seq;
    int[] seqSize;
    DataType seqType;
    int t;
    AtomicBoolean tChanged;
    AtomicBoolean volumeChanged;
    Object volumeData;

    public SequenceVolumeCursor(Sequence seq) {
        this.seq = seq;
        this.seqSize = new int[]{seq.getSizeX(), seq.getSizeY(), seq.getSizeZ()};
        this.seqType = seq.getDataType_();
        this.tChanged = new AtomicBoolean(true);
        this.volumeChanged = new AtomicBoolean(false);
    }

    public SequenceVolumeCursor(Sequence seq, int t) {
        this(seq);
        this.setT(t);
    }

    public void setT(int t) {
        this.t = t;
        this.tChanged.set(true);
    }

    public void setVolume(int t) {
        if (this.volumeChanged.get()) {
            this.seq.dataChanged();
            this.volumeChanged.set(false);
        }
        this.volumeData = this.seq.getDataXYCZ(t);
        this.tChanged.set(false);
    }

    public synchronized double get(int x, int y, int z, int c, boolean withOrigin) {
        if (this.tChanged.get()) {
            this.setVolume(this.t);
        }
        if (withOrigin) {
            x += this.seq.getBounds5D().x;
            y += this.seq.getBounds5D().y;
            z += this.seq.getBounds5D().z;
        }
        switch (this.seqType) {
            case UBYTE: 
            case BYTE: {
                return TypeUtil.toDouble((byte)((byte[][][])this.volumeData)[z][c][x + y * this.seqSize[0]], (boolean)this.seqType.isSigned());
            }
            case USHORT: 
            case SHORT: {
                return TypeUtil.toDouble((short)((short[][][])this.volumeData)[z][c][x + y * this.seqSize[0]], (boolean)this.seqType.isSigned());
            }
            case UINT: 
            case INT: {
                return TypeUtil.toDouble((int)((int[][][])this.volumeData)[z][c][x + y * this.seqSize[0]], (boolean)this.seqType.isSigned());
            }
            case FLOAT: {
                return ((float[][][])this.volumeData)[z][c][x + y * this.seqSize[0]];
            }
            case DOUBLE: {
                return ((double[][][])this.volumeData)[z][c][x + y * this.seqSize[0]];
            }
        }
        throw new RuntimeException("Unsupported data type: " + this.seqType);
    }

    public synchronized void set(int x, int y, int z, int c, double val) {
        if (this.tChanged.get()) {
            this.setVolume(this.t);
        }
        switch (this.seqType) {
            case UBYTE: 
            case BYTE: {
                ((byte[][][])this.volumeData)[z][c][x + y * this.seqSize[0]] = (byte)val;
                break;
            }
            case USHORT: 
            case SHORT: {
                ((short[][][])this.volumeData)[z][c][x + y * this.seqSize[0]] = (short)val;
                break;
            }
            case UINT: 
            case INT: {
                ((int[][][])this.volumeData)[z][c][x + y * this.seqSize[0]] = (int)val;
                break;
            }
            case FLOAT: {
                ((float[][][])this.volumeData)[z][c][x + y * this.seqSize[0]] = (float)val;
                break;
            }
            case DOUBLE: {
                ((double[][][])this.volumeData)[z][c][x + y * this.seqSize[0]] = val;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported data type");
            }
        }
        this.volumeChanged.set(true);
    }

    public synchronized void setSafe(int x, int y, int z, int c, double val) {
        if (this.tChanged.get()) {
            this.setVolume(this.t);
        }
        switch (this.seqType) {
            case UBYTE: 
            case BYTE: {
                ((byte[][][])this.volumeData)[z][c][x + y * this.seqSize[0]] = (byte)this.getSafeValue(val);
                break;
            }
            case USHORT: 
            case SHORT: {
                ((short[][][])this.volumeData)[z][c][x + y * this.seqSize[0]] = (short)this.getSafeValue(val);
                break;
            }
            case UINT: 
            case INT: {
                ((int[][][])this.volumeData)[z][c][x + y * this.seqSize[0]] = (int)this.getSafeValue(val);
                break;
            }
            case FLOAT: {
                ((float[][][])this.volumeData)[z][c][x + y * this.seqSize[0]] = (float)this.getSafeValue(val);
                break;
            }
            case DOUBLE: {
                ((double[][][])this.volumeData)[z][c][x + y * this.seqSize[0]] = val;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported data type");
            }
        }
        this.volumeChanged.set(true);
    }

    private double getSafeValue(double val) {
        return Math.min(Math.max(val, this.seqType.getMaxValue()), this.seqType.getMinValue());
    }

    public synchronized void commitChanges() {
        this.seq.dataChanged();
    }
}

