/*
 * Decompiled with CFR 0.152.
 */
package impl.danyfel80.segmentation.hysteresis;

import api.danyfel80.segmentation.hysteresis.IHysteresisThresholder;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.sequence.VolumetricImage;
import icy.type.DataType;
import impl.danyfel80.sequence.volume.icyBufferedImage.util.IcyBufferedImageCursor;
import impl.danyfel80.sequence.volume.util.VolumetricImageCursor;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.naming.TimeLimitExceededException;

public class HysteresisThresholder2D
implements IHysteresisThresholder,
Callable<Sequence> {
    Sequence _inSequence;
    int[] _sequenceSize;
    double _inLowThreshold;
    double _inHighThreshold;

    public HysteresisThresholder2D(Sequence s, double lowThresh, double highThresh) throws IllegalArgumentException {
        if (s == null || s.isEmpty()) {
            throw new IllegalArgumentException("Input sequence is null or empty.");
        }
        if (lowThresh >= highThresh) {
            throw new IllegalArgumentException(String.format("Low threshold is equal or higher than high theshold (%f >= %f)", lowThresh, highThresh));
        }
        this._inSequence = s;
        this._inLowThreshold = lowThresh;
        this._inHighThreshold = highThresh;
    }

    @Override
    public Sequence execute() throws InterruptedException, TimeLimitExceededException, ExecutionException {
        this._sequenceSize = new int[]{this._inSequence.getSizeX(), this._inSequence.getSizeY(), this._inSequence.getSizeZ(), this._inSequence.getSizeT()};
        Sequence result = new Sequence(String.valueOf(this._inSequence.getName()) + "_Hysteresis2D(" + this._inLowThreshold + ", " + this._inHighThreshold + ")");
        ThreadPoolExecutor tpFrame = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        Future[] futureFrames = new Future[this._sequenceSize[3]];
        int t = 0;
        while (t < this._sequenceSize[3]) {
            futureFrames[t] = tpFrame.submit(new FrameThresholdingTask(t));
            ++t;
        }
        tpFrame.shutdown();
        try {
            result.beginUpdate();
            t = 0;
            while (t < this._sequenceSize[3]) {
                result.addVolumetricImage(t, (VolumetricImage)futureFrames[t].get());
                ++t;
            }
            result.endUpdate();
        }
        catch (InterruptedException | ExecutionException e) {
            tpFrame.shutdownNow();
            boolean success = tpFrame.awaitTermination(3L, TimeUnit.SECONDS);
            if (!success) {
                TimeLimitExceededException tl = new TimeLimitExceededException("timeout while time frame shutdown");
                tl.setRootCause(e);
                throw tl;
            }
            throw e;
        }
        return result;
    }

    @Override
    public Sequence call() throws Exception {
        return this.execute();
    }

    public class FrameThresholdingTask
    implements Callable<VolumetricImage> {
        private int _t;

        public FrameThresholdingTask(int t) {
            this._t = t;
        }

        @Override
        public VolumetricImage call() throws Exception {
            VolumetricImage result = new VolumetricImage();
            ThreadPoolExecutor tpPlane = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            Future[] futurePlanes = new Future[HysteresisThresholder2D.this._sequenceSize[2]];
            int z = 0;
            while (z < HysteresisThresholder2D.this._sequenceSize[2]) {
                futurePlanes[z] = tpPlane.submit(new PlaneThresholdingTask(z));
                ++z;
            }
            tpPlane.shutdown();
            try {
                z = 0;
                while (z < HysteresisThresholder2D.this._sequenceSize[2]) {
                    IcyBufferedImage plane = (IcyBufferedImage)futurePlanes[z].get();
                    result.setImage(z, plane);
                    ++z;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                tpPlane.shutdownNow();
                boolean success = tpPlane.awaitTermination(3L, TimeUnit.SECONDS);
                if (!success) {
                    TimeLimitExceededException tl = new TimeLimitExceededException("timeout while plane shutdown");
                    tl.setRootCause(e);
                    throw tl;
                }
                throw e;
            }
            return result;
        }

        public class PlaneThresholdingTask
        implements Callable<IcyBufferedImage> {
            private int _z;

            public PlaneThresholdingTask(int z) {
                this._z = z;
            }

            @Override
            public IcyBufferedImage call() throws Exception {
                int x;
                IcyBufferedImage result = new IcyBufferedImage(((FrameThresholdingTask)FrameThresholdingTask.this).HysteresisThresholder2D.this._sequenceSize[0], ((FrameThresholdingTask)FrameThresholdingTask.this).HysteresisThresholder2D.this._sequenceSize[1], 1, DataType.UBYTE);
                IcyBufferedImageCursor resultCursor = new IcyBufferedImageCursor(result);
                VolumetricImageCursor cursor = new VolumetricImageCursor(((FrameThresholdingTask)FrameThresholdingTask.this).HysteresisThresholder2D.this._inSequence, FrameThresholdingTask.this._t);
                int y = 0;
                while (y < ((FrameThresholdingTask)FrameThresholdingTask.this).HysteresisThresholder2D.this._sequenceSize[1]) {
                    int x2 = 0;
                    while (x2 < ((FrameThresholdingTask)FrameThresholdingTask.this).HysteresisThresholder2D.this._sequenceSize[0]) {
                        double value = cursor.get(x2, y, this._z, 0);
                        if (value < ((FrameThresholdingTask)FrameThresholdingTask.this).HysteresisThresholder2D.this._inLowThreshold) {
                            resultCursor.set(x2, y, 0, 0.0);
                        } else if (((FrameThresholdingTask)FrameThresholdingTask.this).HysteresisThresholder2D.this._inHighThreshold <= value) {
                            resultCursor.set(x2, y, 0, DataType.UBYTE.getMaxValue());
                        } else {
                            resultCursor.set(x2, y, 0, 127.0);
                        }
                        ++x2;
                    }
                    ++y;
                }
                ArrayDeque<int[]> qPos = new ArrayDeque<int[]>(10000);
                int y2 = 0;
                while (y2 < ((FrameThresholdingTask)FrameThresholdingTask.this).HysteresisThresholder2D.this._sequenceSize[1]) {
                    x = 0;
                    while (x < ((FrameThresholdingTask)FrameThresholdingTask.this).HysteresisThresholder2D.this._sequenceSize[0]) {
                        if (resultCursor.get(x, y2, 0) == DataType.UBYTE.getMaxValue()) {
                            int[] pos = new int[]{x, y2};
                            qPos.push(pos);
                            while (!qPos.isEmpty()) {
                                pos = (int[])qPos.pop();
                                resultCursor.set(pos[0], pos[1], 0, DataType.UBYTE.getMaxValue());
                                pos[0] = pos[0] + 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], 0, 128.0);
                                }
                                pos[1] = pos[1] + 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], 0, 128.0);
                                }
                                pos[0] = pos[0] - 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], 0, 128.0);
                                }
                                pos[0] = pos[0] - 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], 0, 128.0);
                                }
                                pos[1] = pos[1] - 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], 0, 128.0);
                                }
                                pos[1] = pos[1] - 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], 0, 128.0);
                                }
                                pos[0] = pos[0] + 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], 0, 128.0);
                                }
                                pos[0] = pos[0] + 1;
                                if (!this.isInside(pos) || resultCursor.get(pos[0], pos[1], 0) != 127.0) continue;
                                qPos.push(Arrays.copyOf(pos, pos.length));
                                resultCursor.set(pos[0], pos[1], 0, 128.0);
                            }
                        }
                        ++x;
                    }
                    ++y2;
                }
                y2 = 0;
                while (y2 < ((FrameThresholdingTask)FrameThresholdingTask.this).HysteresisThresholder2D.this._sequenceSize[1]) {
                    x = 0;
                    while (x < ((FrameThresholdingTask)FrameThresholdingTask.this).HysteresisThresholder2D.this._sequenceSize[0]) {
                        if (resultCursor.get(x, y2, 0) == 127.0) {
                            resultCursor.set(x, y2, 0, 0.0);
                        }
                        ++x;
                    }
                    ++y2;
                }
                resultCursor.commitChanges();
                return result;
            }

            private boolean isInside(int[] pos) {
                if (pos[0] < 0 || pos[0] >= ((FrameThresholdingTask)FrameThresholdingTask.this).HysteresisThresholder2D.this._sequenceSize[0]) {
                    return false;
                }
                return pos[1] >= 0 && pos[1] < ((FrameThresholdingTask)FrameThresholdingTask.this).HysteresisThresholder2D.this._sequenceSize[1];
            }
        }
    }
}

