/*
 * Decompiled with CFR 0.152.
 */
package impl.danyfel80.segmentation.hysteresis;

import api.danyfel80.segmentation.hysteresis.IHysteresisThresholder;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.sequence.VolumetricImage;
import icy.type.DataType;
import impl.danyfel80.sequence.util.SequenceVolumeCursor;
import impl.danyfel80.sequence.volume.util.VolumetricImageCursor;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.naming.TimeLimitExceededException;

public class HysteresisThresholder3D
implements IHysteresisThresholder,
Callable<Sequence> {
    Sequence _inSequence;
    int[] _sequenceSize;
    double _inLowThreshold;
    double _inHighThreshold;

    public HysteresisThresholder3D(Sequence s, double lowThresh, double highThresh) throws IllegalArgumentException {
        if (s == null || s.isEmpty()) {
            throw new IllegalArgumentException("Input sequence is null or empty.");
        }
        if (lowThresh >= highThresh) {
            throw new IllegalArgumentException(String.format("Low threshold is equal or higher than high theshold (%f >= %f)", lowThresh, highThresh));
        }
        this._inSequence = s;
        this._inLowThreshold = lowThresh;
        this._inHighThreshold = highThresh;
    }

    @Override
    public Sequence execute() throws InterruptedException, TimeLimitExceededException, ExecutionException {
        this._sequenceSize = new int[]{this._inSequence.getSizeX(), this._inSequence.getSizeY(), this._inSequence.getSizeZ(), this._inSequence.getSizeT()};
        Sequence result = new Sequence(String.valueOf(this._inSequence.getName()) + "_Hysteresis3D(" + this._inLowThreshold + ", " + this._inHighThreshold + ")");
        ThreadPoolExecutor tpFrame = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        Future[] futureFrames = new Future[this._sequenceSize[3]];
        int t = 0;
        while (t < this._sequenceSize[3]) {
            futureFrames[t] = tpFrame.submit(new FrameThresholdingTask(t));
            ++t;
        }
        tpFrame.shutdown();
        try {
            result.beginUpdate();
            t = 0;
            while (t < this._sequenceSize[3]) {
                result.addVolumetricImage(t, (VolumetricImage)futureFrames[t].get());
                ++t;
            }
            result.endUpdate();
        }
        catch (InterruptedException | ExecutionException e) {
            tpFrame.shutdownNow();
            boolean success = tpFrame.awaitTermination(3L, TimeUnit.SECONDS);
            if (!success) {
                TimeLimitExceededException tl = new TimeLimitExceededException("timeout while time frame shutdown");
                tl.setRootCause(e);
                throw tl;
            }
            throw e;
        }
        return result;
    }

    @Override
    public Sequence call() throws Exception {
        return this.execute();
    }

    public class FrameThresholdingTask
    implements Callable<VolumetricImage> {
        private int _t;

        public FrameThresholdingTask(int t) {
            this._t = t;
        }

        @Override
        public VolumetricImage call() throws Exception {
            int x;
            VolumetricImage result = new VolumetricImage();
            int z = 0;
            while (z < HysteresisThresholder3D.this._sequenceSize[2]) {
                result.setImage(z, new IcyBufferedImage(HysteresisThresholder3D.this._sequenceSize[0], HysteresisThresholder3D.this._sequenceSize[1], 1, DataType.UBYTE));
                ++z;
            }
            VolumetricImageCursor resultCursor = new VolumetricImageCursor(result);
            SequenceVolumeCursor cursor = new SequenceVolumeCursor(HysteresisThresholder3D.this._inSequence, this._t);
            int z2 = 0;
            while (z2 < HysteresisThresholder3D.this._sequenceSize[2]) {
                int y = 0;
                while (y < HysteresisThresholder3D.this._sequenceSize[1]) {
                    int x2 = 0;
                    while (x2 < HysteresisThresholder3D.this._sequenceSize[0]) {
                        double value = cursor.get(x2, y, z2, 0, false);
                        if (value < HysteresisThresholder3D.this._inLowThreshold) {
                            resultCursor.set(x2, y, z2, 0, 0.0);
                        } else if (HysteresisThresholder3D.this._inHighThreshold <= value) {
                            resultCursor.set(x2, y, z2, 0, DataType.UBYTE.getMaxValue());
                        } else {
                            resultCursor.set(x2, y, z2, 0, 127.0);
                        }
                        ++x2;
                    }
                    ++y;
                }
                ++z2;
            }
            ArrayDeque<int[]> qPos = new ArrayDeque<int[]>(10000);
            int z3 = 0;
            while (z3 < HysteresisThresholder3D.this._sequenceSize[2]) {
                int y = 0;
                while (y < HysteresisThresholder3D.this._sequenceSize[1]) {
                    x = 0;
                    while (x < HysteresisThresholder3D.this._sequenceSize[0]) {
                        if (resultCursor.get(x, y, z3, 0) == DataType.UBYTE.getMaxValue()) {
                            int[] pos = new int[]{x, y, z3};
                            qPos.push(pos);
                            while (!qPos.isEmpty()) {
                                pos = (int[])qPos.pop();
                                resultCursor.set(pos[0], pos[1], pos[2], 0, DataType.UBYTE.getMaxValue());
                                pos[2] = pos[2] + 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[0] = pos[0] + 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[1] = pos[1] + 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[0] = pos[0] - 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[0] = pos[0] - 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[1] = pos[1] - 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[1] = pos[1] - 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[0] = pos[0] + 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[0] = pos[0] + 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[2] = pos[2] - 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[1] = pos[1] + 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[1] = pos[1] + 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[0] = pos[0] - 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[0] = pos[0] - 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[1] = pos[1] - 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[1] = pos[1] - 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[0] = pos[0] + 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[2] = pos[2] - 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[0] = pos[0] + 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[1] = pos[1] + 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[1] = pos[1] + 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[0] = pos[0] - 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[0] = pos[0] - 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[1] = pos[1] - 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[1] = pos[1] - 1;
                                if (this.isInside(pos) && resultCursor.get(pos[0], pos[1], pos[2], 0) == 127.0) {
                                    qPos.push(Arrays.copyOf(pos, pos.length));
                                    resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                                }
                                pos[0] = pos[0] + 1;
                                pos[1] = pos[1] + 1;
                                if (!this.isInside(pos) || resultCursor.get(pos[0], pos[1], pos[2], 0) != 127.0) continue;
                                qPos.push(Arrays.copyOf(pos, pos.length));
                                resultCursor.set(pos[0], pos[1], pos[2], 0, 128.0);
                            }
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z3;
            }
            z3 = 0;
            while (z3 < HysteresisThresholder3D.this._sequenceSize[2]) {
                int y = 0;
                while (y < HysteresisThresholder3D.this._sequenceSize[1]) {
                    x = 0;
                    while (x < HysteresisThresholder3D.this._sequenceSize[0]) {
                        if (resultCursor.get(x, y, z3, 0) == 127.0) {
                            resultCursor.set(x, y, z3, 0, 0.0);
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z3;
            }
            resultCursor.commitChanges();
            return result;
        }

        private boolean isInside(int[] pos) {
            if (pos[0] < 0 || pos[0] >= HysteresisThresholder3D.this._sequenceSize[0]) {
                return false;
            }
            if (pos[1] < 0 || pos[1] >= HysteresisThresholder3D.this._sequenceSize[1]) {
                return false;
            }
            return pos[2] >= 0 && pos[2] < HysteresisThresholder3D.this._sequenceSize[2];
        }
    }
}

