/*
 * Decompiled with CFR 0.152.
 */
package impl.danyfel80.sequence.volume.util;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.sequence.VolumetricImage;
import icy.type.DataType;
import icy.type.TypeUtil;
import java.util.concurrent.atomic.AtomicBoolean;

public class VolumetricImageCursor {
    VolumetricImage vol;
    int[] volSize;
    DataType volType;
    AtomicBoolean volumeChanged;
    Object volumeData;

    public VolumetricImageCursor(VolumetricImage vol) {
        Object volumeData;
        this.vol = vol;
        IcyBufferedImage firstPlane = vol.getFirstImage();
        this.volSize = new int[]{firstPlane.getSizeX(), firstPlane.getSizeY(), vol.getImages().size()};
        this.volType = firstPlane.getDataType_();
        switch (this.volType) {
            case UBYTE: 
            case BYTE: {
                volumeData = new byte[vol.getImages().size()][][];
                break;
            }
            case USHORT: 
            case SHORT: {
                volumeData = new short[vol.getImages().size()][][];
                break;
            }
            case UINT: 
            case INT: {
                volumeData = new int[vol.getImages().size()][][];
                break;
            }
            case FLOAT: {
                volumeData = new float[vol.getImages().size()][][];
                break;
            }
            case DOUBLE: {
                volumeData = new double[vol.getImages().size()][][];
                break;
            }
            default: {
                throw new RuntimeException("Unsupported data type: " + this.volType);
            }
        }
        int i = 0;
        for (IcyBufferedImage plane : vol.getImages().values()) {
            switch (this.volType) {
                case UBYTE: 
                case BYTE: {
                    ((byte[][][])volumeData)[i++] = (byte[][])plane.getDataXYC();
                    break;
                }
                case USHORT: 
                case SHORT: {
                    ((short[][][])volumeData)[i++] = (short[][])plane.getDataXYC();
                    break;
                }
                case UINT: 
                case INT: {
                    ((int[][][])volumeData)[i++] = (int[][])plane.getDataXYC();
                    break;
                }
                case FLOAT: {
                    ((float[][][])volumeData)[i++] = (float[][])plane.getDataXYC();
                    break;
                }
                case DOUBLE: {
                    ((double[][][])volumeData)[i++] = (double[][])plane.getDataXYC();
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported data type: " + this.volType);
                }
            }
        }
        this.volumeData = volumeData;
        this.volumeChanged = new AtomicBoolean(false);
    }

    public VolumetricImageCursor(Sequence seq, int t) {
        this(seq.getVolumetricImage(t));
    }

    public synchronized double get(int x, int y, int z, int c) {
        switch (this.volType) {
            case UBYTE: 
            case BYTE: {
                return TypeUtil.toDouble((byte)((byte[][][])this.volumeData)[z][c][x + y * this.volSize[0]], (boolean)this.volType.isSigned());
            }
            case USHORT: 
            case SHORT: {
                return TypeUtil.toDouble((short)((short[][][])this.volumeData)[z][c][x + y * this.volSize[0]], (boolean)this.volType.isSigned());
            }
            case UINT: 
            case INT: {
                return TypeUtil.toDouble((int)((int[][][])this.volumeData)[z][c][x + y * this.volSize[0]], (boolean)this.volType.isSigned());
            }
            case FLOAT: {
                return ((float[][][])this.volumeData)[z][c][x + y * this.volSize[0]];
            }
            case DOUBLE: {
                return ((double[][][])this.volumeData)[z][c][x + y * this.volSize[0]];
            }
        }
        throw new RuntimeException("Unsupported data type: " + this.volType);
    }

    public synchronized void set(int x, int y, int z, int c, double val) {
        switch (this.volType) {
            case UBYTE: 
            case BYTE: {
                ((byte[][][])this.volumeData)[z][c][x + y * this.volSize[0]] = (byte)val;
                break;
            }
            case USHORT: 
            case SHORT: {
                ((short[][][])this.volumeData)[z][c][x + y * this.volSize[0]] = (short)val;
                break;
            }
            case UINT: 
            case INT: {
                ((int[][][])this.volumeData)[z][c][x + y * this.volSize[0]] = (int)val;
                break;
            }
            case FLOAT: {
                ((float[][][])this.volumeData)[z][c][x + y * this.volSize[0]] = (float)val;
                break;
            }
            case DOUBLE: {
                ((double[][][])this.volumeData)[z][c][x + y * this.volSize[0]] = val;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported data type");
            }
        }
        this.volumeChanged.set(true);
    }

    public synchronized void setSafe(int x, int y, int z, int c, double val) {
        switch (this.volType) {
            case UBYTE: 
            case BYTE: {
                ((byte[][][])this.volumeData)[z][c][x + y * this.volSize[0]] = (byte)this.getSafeValue(val);
                break;
            }
            case USHORT: 
            case SHORT: {
                ((short[][][])this.volumeData)[z][c][x + y * this.volSize[0]] = (short)this.getSafeValue(val);
                break;
            }
            case UINT: 
            case INT: {
                ((int[][][])this.volumeData)[z][c][x + y * this.volSize[0]] = (int)this.getSafeValue(val);
                break;
            }
            case FLOAT: {
                ((float[][][])this.volumeData)[z][c][x + y * this.volSize[0]] = (float)this.getSafeValue(val);
                break;
            }
            case DOUBLE: {
                ((double[][][])this.volumeData)[z][c][x + y * this.volSize[0]] = val;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported data type");
            }
        }
        this.volumeChanged.set(true);
    }

    private double getSafeValue(double val) {
        return Math.min(Math.max(val, this.volType.getMaxValue()), this.volType.getMinValue());
    }

    public synchronized void commitChanges() {
        for (IcyBufferedImage plane : this.vol.getImages().values()) {
            plane.dataChanged();
        }
    }
}

