/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.segmentation.hysteresis;

import icy.gui.dialog.MessageDialog;
import icy.sequence.Sequence;
import impl.danyfel80.segmentation.hysteresis.HysteresisThresholder2D;
import impl.danyfel80.segmentation.hysteresis.HysteresisThresholder3D;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;

public class HysteresisThresholding
extends EzPlug
implements Block,
EzStoppable {
    EzVarSequence varInSequence;
    EzVarDouble varInThreshold1;
    EzVarDouble varInThreshold2;
    EzVarBoolean varInIs3DProcessing;
    EzVarSequence varOutSequence;
    ExecutorService execution;

    protected void initialize() {
        this.varInSequence = new EzVarSequence("Sequence");
        this.varInThreshold1 = new EzVarDouble("Low threshold", 50.0, -1.7976931348623157E308, Double.MAX_VALUE, 0.01);
        this.varInThreshold2 = new EzVarDouble("High threshold", 100.0, -1.7976931348623157E308, Double.MAX_VALUE, 0.01);
        this.varInIs3DProcessing = new EzVarBoolean("3D Processing", true);
        this.varInSequence.setToolTipText("Sequence to be thresholded. This sequence is not modified.");
        this.varInThreshold1.setToolTipText("Lower threshold. Any pixel below this value is considered out of the segmentation.");
        this.varInThreshold2.setToolTipText("Upper threshold. Any pixel below this value, and above the lower threshold, is considered a candidate for the segmentation. Any pixel above this value, is considered as part of the segmentation.");
        this.varInIs3DProcessing.setToolTipText("If checked, the sequence is processed as a volume even if it is a single plane. If not checked, the sequence is processed plane by plane.");
        this.addEzComponent((EzComponent)this.varInSequence);
        this.addEzComponent((EzComponent)this.varInThreshold1);
        this.addEzComponent((EzComponent)this.varInThreshold2);
        this.addEzComponent((EzComponent)this.varInIs3DProcessing);
        this.varInSequence.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> source, Sequence newValue) {
                if (newValue != null && !newValue.isEmpty()) {
                    if (newValue.getSizeZ() > 1) {
                        HysteresisThresholding.this.varInIs3DProcessing.setEnabled(true);
                        HysteresisThresholding.this.varInIs3DProcessing.setValue((Object)true);
                    } else {
                        HysteresisThresholding.this.varInIs3DProcessing.setEnabled(false);
                        HysteresisThresholding.this.varInIs3DProcessing.setValue((Object)false);
                    }
                } else {
                    HysteresisThresholding.this.varInIs3DProcessing.setEnabled(false);
                }
            }
        });
        this.varInSequence.valueChanged((Var)this.varInSequence.getVariable(), (Object)((Sequence)this.varInSequence.getValue()), (Object)((Sequence)this.varInSequence.getValue()));
        this.varOutSequence = new EzVarSequence("Thresholded Sequence");
    }

    protected void execute() {
        this.execution = Executors.newSingleThreadExecutor();
        long startTime = System.currentTimeMillis();
        try {
            this.validateInput();
        }
        catch (RuntimeException e) {
            MessageDialog.showDialog((String)"Input Error", (String)e.getMessage(), (int)0);
            return;
        }
        Future<Sequence> futureResult = null;
        try {
            futureResult = ((Boolean)this.varInIs3DProcessing.getValue()).booleanValue() && ((Sequence)this.varInSequence.getValue()).getSizeZ() > 1 ? this.execution.submit(new HysteresisThresholder3D((Sequence)this.varInSequence.getValue(), (Double)this.varInThreshold1.getValue(), (Double)this.varInThreshold2.getValue())) : this.execution.submit(new HysteresisThresholder2D((Sequence)this.varInSequence.getValue(), (Double)this.varInThreshold1.getValue(), (Double)this.varInThreshold2.getValue()));
        }
        catch (IllegalArgumentException e) {
            MessageDialog.showDialog((String)"Input Error", (String)e.getMessage(), (int)0);
            return;
        }
        try {
            try {
                this.varOutSequence.setValue(futureResult.get());
                long endTime = System.currentTimeMillis();
                System.out.println("Hysteresis thresholding finished. It took " + (endTime - startTime) + " millis.");
                if (this.getUI() != null) {
                    this.addSequence((Sequence)this.varOutSequence.getValue());
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                MessageDialog.showDialog((String)"Error", (String)"Process interrupted", (int)0);
                this.execution.shutdown();
                return;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                MessageDialog.showDialog((String)"Error", (String)e.getMessage(), (int)0);
                this.execution.shutdown();
                return;
            }
        }
        finally {
            this.execution.shutdown();
        }
    }

    private void validateInput() throws RuntimeException {
        if (this.varInSequence.getValue() == null || ((Sequence)this.varInSequence.getValue()).isEmpty()) {
            throw new RuntimeException("Input sequence is null or empty.");
        }
    }

    public void clean() {
    }

    public void stopExecution() {
        this.execution.shutdownNow();
        try {
            this.execution.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        super.stopExecution();
    }

    public void declareInput(VarList inputMap) {
        this.varInSequence = new EzVarSequence("Sequence");
        this.varInThreshold1 = new EzVarDouble("Low threshold", 50.0, -1.7976931348623157E308, Double.MAX_VALUE, 0.01);
        this.varInThreshold2 = new EzVarDouble("High threshold", 100.0, -1.7976931348623157E308, Double.MAX_VALUE, 0.01);
        this.varInIs3DProcessing = new EzVarBoolean("3D processing", true);
        inputMap.add(this.varInSequence.name, (Var)this.varInSequence.getVariable());
        inputMap.add(this.varInThreshold1.name, this.varInThreshold1.getVariable());
        inputMap.add(this.varInThreshold2.name, this.varInThreshold2.getVariable());
        inputMap.add(this.varInIs3DProcessing.name, this.varInIs3DProcessing.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        this.varOutSequence = new EzVarSequence("Thresholded Sequence");
        outputMap.add(this.varOutSequence.name, (Var)this.varOutSequence.getVariable());
    }
}

