/*
 * Decompiled with CFR 0.152.
 */
package algorithms.danyfel80.bigimage;

import icy.file.FileUtil;
import icy.image.IcyBufferedImage;
import icy.sequence.MetaDataUtil;
import icy.type.DataType;
import icy.util.OMEUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import loci.common.services.ServiceException;
import loci.formats.FormatException;
import loci.formats.IFormatWriter;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.ome.OMEXMLMetadataImpl;
import loci.formats.out.OMETiffWriter;
import loci.formats.out.TiffWriter;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffCompression;

public class BigImageSaver {
    private File outFile;
    private int sizeX;
    private int sizeY;
    private int sizeC;
    private DataType dataType;
    private int tileSizeX;
    private int tileSizeY;
    private IFD ifd;
    private boolean isSeparateChannels;
    private boolean isLittleEndian;
    private TiffWriter writer;

    public BigImageSaver(File outFile, Dimension tgtDim, int sizeC, DataType dataType, Dimension tileSize) throws ServiceException, FormatException, IOException {
        this.outFile = outFile;
        this.sizeX = tgtDim.width;
        this.sizeY = tgtDim.height;
        this.sizeC = sizeC;
        this.dataType = dataType;
        this.tileSizeX = tileSize.width;
        this.tileSizeY = tileSize.height;
        this.initializeWriter();
        this.writer.setSeries(0);
    }

    private void initializeWriter() throws ServiceException, FormatException, IOException {
        this.writer = new OMETiffWriter();
        this.writer.setCompression(TiffCompression.LZW.getCodecName());
        OMEXMLMetadataImpl mdi = OMEUtil.createOMEMetadata();
        this.isSeparateChannels = BigImageSaver.getSeparateChannelFlag((IFormatWriter)this.writer, this.sizeC, this.dataType);
        MetaDataUtil.setMetaData((OMEXMLMetadata)mdi, (int)this.sizeX, (int)this.sizeY, (int)this.sizeC, (int)1, (int)1, (DataType)this.dataType, (boolean)this.isSeparateChannels);
        this.writer.setMetadataRetrieve((MetadataRetrieve)mdi);
        this.writer.setWriteSequentially(true);
        this.writer.setInterleaved(false);
        this.writer.setBigTiff(true);
        if (FileUtil.exists((String)this.outFile.getAbsolutePath())) {
            FileUtil.delete((File)this.outFile, (boolean)true);
        }
        this.writer.setId(this.outFile.getAbsolutePath());
        this.writer.setSeries(0);
        this.isLittleEndian = this.writer.getMetadataRetrieve().getPixelsBinDataBigEndian(0, 0) == false;
        this.ifd = new IFD();
        long[] rowPerStrip = new long[]{this.tileSizeY};
        this.ifd.put((Object)322, (Object)this.tileSizeX);
        this.ifd.put((Object)323, (Object)this.tileSizeY);
        this.ifd.put((Object)278, (Object)rowPerStrip);
    }

    private static boolean getSeparateChannelFlag(IFormatWriter writer, int numChannel, DataType dataType) {
        return false;
    }

    public void closeWriter() throws IOException {
        this.writer.close();
    }

    public synchronized void saveTile(IcyBufferedImage srcIBI, Point tgtPoint) throws ServiceException, IOException, FormatException {
        byte[] data = null;
        if (this.isSeparateChannels) {
            int c = 0;
            while (c < this.sizeC) {
                if (srcIBI != null) {
                    data = srcIBI.getRawData(c, this.isLittleEndian);
                    this.writer.saveBytes(c, data, this.ifd, tgtPoint.x, tgtPoint.y, srcIBI.getSizeX(), srcIBI.getSizeY());
                }
                ++c;
            }
        } else if (srcIBI != null) {
            data = srcIBI.getRawData(this.isLittleEndian);
            this.writer.saveBytes(0, data, this.ifd, tgtPoint.x, tgtPoint.y, srcIBI.getSizeX(), srcIBI.getSizeY());
        }
    }
}

