/*
 * Decompiled with CFR 0.152.
 */
package algorithms.danyfel80.registration.bunwarp;

import algorithms.danyfel80.registration.bunwarp.BSplineModel;
import algorithms.danyfel80.registration.bunwarp.ProgressBar;
import algorithms.danyfel80.registration.bunwarp.RegistrationModeEnum;
import algorithms.danyfel80.registration.bunwarp.Transformation;
import icy.image.IcyBufferedImage;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.DataType;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import loci.common.services.ServiceException;
import loci.formats.FormatException;
import plugins.danyfel80.registration.bunwarp.BUnwarp;
import plugins.kernel.roi.roi2d.ROI2DPoint;

public class BUnwarpper
implements Runnable {
    private Sequence sourceSeq;
    private Sequence targetSeq;
    private BSplineModel sourceModel;
    private BSplineModel targetModel;
    private List<ROI2DPoint> sourceLandmarks;
    private List<ROI2DPoint> targetLandmarks;
    private ROI2D sourceMask;
    private ROI2D targetMask;
    private int maxImageSubsamplingFactor;
    private int minScaleDeformation;
    private int maxScaleDeformation;
    private int minScaleImage;
    private int outputLevel;
    private boolean showMarquardtOptim;
    private double divWeight;
    private double curlWeight;
    private double landmarkWeight;
    private double imageWeight;
    private double consistencyWeight;
    private double stopThreshold;
    private int accurateMode;
    private int imagePyramidDepth;
    private Transformation warp;
    private BUnwarp plugin;

    public BUnwarpper(Sequence sourceSequence, Sequence targetSequence, List<ROI2DPoint> sourceLandmarks, List<ROI2DPoint> targetLandmarks, ROI2D sourceMask, ROI2D targetMask, int maxImageSubsamplingFactor, int minScaleDeformation, int maxScaleDeformation, int minScaleImage, double divWeight, double curlWeight, double landmarkWeight, double imageWeight, double consistencyWeight, double stopThreshold, int outputLevel, boolean showMarquardtOptim, int accurateMode, BUnwarp plugin) {
        this.sourceSeq = sourceSequence;
        this.targetSeq = targetSequence;
        this.sourceLandmarks = sourceLandmarks;
        this.targetLandmarks = targetLandmarks;
        this.sourceMask = sourceMask;
        this.targetMask = targetMask;
        this.maxImageSubsamplingFactor = maxImageSubsamplingFactor;
        this.minScaleDeformation = minScaleDeformation;
        this.maxScaleDeformation = maxScaleDeformation;
        this.minScaleImage = minScaleImage;
        this.divWeight = divWeight;
        this.curlWeight = curlWeight;
        this.landmarkWeight = landmarkWeight;
        this.imageWeight = imageWeight;
        this.consistencyWeight = consistencyWeight;
        this.stopThreshold = stopThreshold;
        this.outputLevel = outputLevel;
        this.showMarquardtOptim = showMarquardtOptim;
        this.accurateMode = accurateMode;
        this.plugin = plugin;
        ProgressBar.setPlugin(this.plugin);
        this.createSourceImage(this.accurateMode < RegistrationModeEnum.MONO.getNumber());
        this.createTargetImage();
    }

    private void createSourceImage(boolean isReverse) {
        this.sourceModel = new BSplineModel(this.sourceSeq.getFirstImage(), isReverse, (int)Math.pow(2.0, this.maxImageSubsamplingFactor));
        this.computeImagePyramidDepth();
        this.sourceModel.setPyramidDepth(this.imagePyramidDepth + this.minScaleImage);
    }

    private void computeImagePyramidDepth() {
        this.imagePyramidDepth = this.maxScaleDeformation - this.minScaleDeformation + 1;
    }

    private void createTargetImage() {
        this.targetModel = new BSplineModel(this.targetSeq.getFirstImage(), true, (int)Math.pow(2.0, this.maxImageSubsamplingFactor));
        this.computeImagePyramidDepth();
        this.targetModel.setPyramidDepth(this.imagePyramidDepth + this.minScaleImage);
    }

    @Override
    public void run() {
        ProgressBar.setProgressBarMessage("Starting image pyramids...");
        if (this.targetModel.getWidth() > 1024 || this.targetModel.getHeight() > 1024 || this.sourceModel.getWidth() > 1024 || this.sourceModel.getHeight() > 1024) {
            System.out.println("Starting image pyramids...");
        }
        this.sourceModel.startPyramids();
        this.targetModel.startPyramids();
        try {
            this.sourceModel.join();
            this.targetModel.join();
        }
        catch (InterruptedException e) {
            System.err.println("Unhandled interruption: " + e);
        }
        Sequence[] outputSeqs = this.initializeOutputSeqs();
        if (this.accurateMode == RegistrationModeEnum.MONO.getNumber()) {
            this.consistencyWeight = 0.0;
        }
        this.warp = new Transformation(this.sourceSeq, this.targetSeq, this.sourceModel, this.targetModel, this.sourceLandmarks, this.targetLandmarks, this.sourceMask, this.targetMask, this.minScaleDeformation, this.maxScaleDeformation, this.minScaleImage, this.divWeight, this.curlWeight, this.landmarkWeight, this.imageWeight, this.consistencyWeight, this.stopThreshold, this.outputLevel, this.showMarquardtOptim, this.accurateMode, outputSeqs[0], outputSeqs[1], this.plugin);
        ProgressBar.setProgressBarMessage("Registering...");
        long start = System.currentTimeMillis();
        if (this.accurateMode == RegistrationModeEnum.MONO.getNumber()) {
            this.warp.doUnidirectionalRegistration();
            if (this.sourceModel.isSubOutput()) {
                System.out.println("Calculating final transformed source image");
            }
            this.warp.showDirectResults();
        } else {
            this.warp.doBidirectionalRegistration();
            if (this.sourceModel.isSubOutput()) {
                System.out.println("Calculating final transformed source image");
            }
            this.warp.showDirectResults();
            if (this.targetModel.isSubOutput()) {
                System.out.println("Calculating final transformed target image");
            }
            this.warp.showInverseResults();
        }
        System.out.println("Intervals: " + this.warp.getIntervals());
        long stop = System.currentTimeMillis();
        if (this.outputLevel == 2) {
            System.out.println("\nRegistration time: " + (stop - start) + "ms");
        }
        this.plugin.restoreAll();
    }

    private Sequence[] initializeOutputSeqs() {
        int Xdimt = this.targetModel.getWidth();
        int Ydimt = this.targetModel.getHeight();
        int Xdims = this.sourceModel.getWidth();
        int Ydims = this.sourceModel.getHeight();
        double[] tImage = this.targetModel.isSubOutput() ? this.targetModel.getSubImage() : this.targetModel.getImage();
        double[] sImage = this.sourceModel.isSubOutput() ? this.sourceModel.getSubImage() : this.sourceModel.getImage();
        int sSubFactorX = 1;
        int sSubFactorY = 1;
        int tSubFactorX = 1;
        int tSubFactorY = 1;
        Sequence[] outputSeqs = new Sequence[2];
        String extraTitleS = "";
        String extraTitleT = "";
        if (this.targetModel.isSubOutput() || this.sourceModel.isSubOutput()) {
            System.out.println("Initializing output windows...");
        }
        if (this.targetModel.isSubOutput()) {
            tSubFactorX = Xdimt / this.targetModel.getSubWidth();
            tSubFactorY = Ydimt / this.targetModel.getSubHeight();
            extraTitleT = " (Subsampled)";
            Xdimt = this.targetModel.getSubWidth();
            Ydimt = this.targetModel.getSubHeight();
        }
        if (this.sourceModel.isSubOutput()) {
            sSubFactorX = Xdims / this.sourceModel.getSubWidth();
            sSubFactorY = Ydims / this.sourceModel.getSubHeight();
            extraTitleS = " (Subsampled)";
            Xdims = this.sourceModel.getSubWidth();
            Ydims = this.sourceModel.getSubHeight();
        }
        IcyBufferedImage ibi = new IcyBufferedImage(Xdimt, Ydimt, 1, DataType.FLOAT);
        float[] ibiData = ibi.getDataXYAsFloat(0);
        int i = 0;
        while (i < Ydimt) {
            int i_offset_t = i * Xdimt;
            int i_offset_s = i * Xdims;
            int i_s_sub = i * sSubFactorY;
            int i_t_sub = i * tSubFactorY;
            int j = 0;
            while (j < Xdimt) {
                ibiData[j + i_offset_t] = (this.sourceMask == null || this.targetMask == null || this.sourceMask.contains((double)(j * sSubFactorX), (double)i_s_sub) && this.targetMask.contains((double)(j * tSubFactorX), (double)i_t_sub)) && j < Xdims && i < Ydims ? (float)(tImage[i_offset_t + j] - sImage[i_offset_s + j]) : 0.0f;
                ++j;
            }
            ++i;
        }
        ibi.dataChanged();
        Sequence seq1 = new Sequence("Output Source-Target" + extraTitleS, ibi);
        this.plugin.addSequence(seq1);
        outputSeqs[0] = seq1;
        if (this.accurateMode != RegistrationModeEnum.MONO.getNumber()) {
            IcyBufferedImage ibi2 = new IcyBufferedImage(Xdims, Ydims, 1, DataType.FLOAT);
            float[] ibi2Data = ibi2.getDataXYAsFloat(0);
            int i2 = 0;
            while (i2 < Ydims) {
                int i_offset_t = i2 * Xdimt;
                int i_offset_s = i2 * Xdims;
                int i_s_sub = i2 * sSubFactorY;
                int i_t_sub = i2 * tSubFactorY;
                int j = 0;
                while (j < Xdims) {
                    ibi2Data[j + i_offset_s] = (this.targetMask == null || this.sourceMask != null || this.targetMask.contains((double)(j * tSubFactorX), (double)i_t_sub) && this.sourceMask.contains((double)(j * sSubFactorX), (double)i_s_sub)) && i2 < Ydimt && j < Xdimt ? (float)(sImage[i_offset_s + j] - tImage[i_offset_t + j]) : 0.0f;
                    ++j;
                }
                ++i2;
            }
            ibi2.dataChanged();
            Sequence seq2 = new Sequence("Output Target-Source" + extraTitleT, ibi2);
            this.plugin.addSequence(seq2);
            outputSeqs[1] = seq2;
        } else {
            outputSeqs[1] = null;
        }
        return outputSeqs;
    }

    public void getRegisteredSource(Sequence srcTgtSeq) {
        this.warp.getRegisteredSource(srcTgtSeq);
    }

    public void getRegisteredTarget(Sequence tgtTgtSeq) {
        this.warp.getRegisteredTarget(tgtTgtSeq);
    }

    public Sequence getRegisteredSource(String srcResultPath, String srcPath, String transformedSrcPath, String tgtPath) {
        return this.warp.getRegisteredSource(srcResultPath, srcPath, transformedSrcPath, tgtPath);
    }

    public Sequence getRegisteredTarget(String tgtResultPath, String srcPath, String tgtPath, String transformedTgtPath) {
        return this.warp.getRegisteredTarget(tgtResultPath, srcPath, tgtPath, transformedTgtPath);
    }

    public double[][] getCxSourceToTarget() {
        return this.warp.getCxSourceToTarget();
    }

    public double[][] getCySourceToTarget() {
        return this.warp.getCySourceToTarget();
    }

    public double[][] getCxTargetToSource() {
        return this.warp.getCxTargetToSource();
    }

    public double[][] getCyTargetToSource() {
        return this.warp.getCyTargetToSource();
    }

    public int getIntervals() {
        return this.warp.getIntervals();
    }

    public void saveBigRegisteredSource(String srcResultPath, String transformedSrcResultPath, String srcPath, String transformedSrcPath, String tgtPath, Rectangle tile) throws ServiceException, IOException, FormatException, InterruptedException, ExecutionException {
        this.warp.saveBigRegisteredSource(srcResultPath, transformedSrcResultPath, srcPath, transformedSrcPath, tgtPath, tile);
    }

    public void saveBigRegisteredTarget(String tgtResultPath, String transformedTgtResultPath, String tgtPath, String transformedTgtPath, String srcPath, Rectangle tile) throws ServiceException, IOException, FormatException, InterruptedException, ExecutionException {
        this.warp.saveBigRegisteredTarget(tgtResultPath, transformedTgtResultPath, tgtPath, transformedTgtPath, srcPath, tile);
    }
}

