/*
 * Decompiled with CFR 0.152.
 */
package algorithms.danyfel80.registration.bunwarp;

import algorithms.danyfel80.registration.bunwarp.BSplineModel;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array2DUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class MiscTools {
    public static void extractImage(IcyBufferedImage ibi, double[] outData) {
        int width = ibi.getWidth();
        int height = ibi.getHeight();
        int channels = ibi.getSizeC();
        IcyBufferedImage ibiD = IcyBufferedImageUtil.convertToType((IcyBufferedImage)ibi, (DataType)DataType.DOUBLE, (boolean)false);
        double[][] ibiDData = ibiD.getDataXYCAsDouble();
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                double val = 0.0;
                int c = 0;
                while (c < channels) {
                    val += ibiDData[c][x + y * width];
                    ++c;
                }
                outData[x + y * width] = val / (double)channels;
                ++y;
            }
            ++x;
        }
    }

    public static IcyBufferedImage scale(IcyBufferedImage ibi, float scaleFactor) {
        return IcyBufferedImageUtil.scale((IcyBufferedImage)ibi, (int)((int)Math.round((double)scaleFactor * (double)ibi.getWidth())), (int)((int)Math.round((double)scaleFactor * (double)ibi.getHeight())));
    }

    public static void drawLine(double[][] canvas, int x1, int y1, int x2, int y2, double color) {
        int temp;
        int dy_neg = 1;
        int dx_neg = 1;
        boolean switch_x_y = false;
        boolean neg_slope = false;
        int dx = x2 - x1;
        if (dx == 0) {
            if (y1 > y2) {
                int n = y2;
                while (n <= y1) {
                    MiscTools.drawPoint(canvas, n, x1, color);
                    ++n;
                }
                return;
            }
            int n = y1;
            while (n <= y2) {
                MiscTools.drawPoint(canvas, n, x1, color);
                ++n;
            }
            return;
        }
        int dy = y2 - y1;
        if (dy == 0) {
            if (x1 > x2) {
                int n = x2;
                while (n <= x1) {
                    MiscTools.drawPoint(canvas, y1, n, color);
                    ++n;
                }
                return;
            }
            int n = x1;
            while (n <= x2) {
                MiscTools.drawPoint(canvas, y1, n, color);
                ++n;
            }
            return;
        }
        float m = (float)dy / (float)dx;
        if (m > 1.0f || m < -1.0f) {
            temp = x1;
            x1 = y1;
            y1 = temp;
            temp = x2;
            x2 = y2;
            y2 = temp;
            dx = x2 - x1;
            dy = y2 - y1;
            m = (float)dy / (float)dx;
            switch_x_y = true;
        }
        if (x1 > x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
            temp = y1;
            y1 = y2;
            y2 = temp;
            dx = x2 - x1;
            dy = y2 - y1;
            m = (float)dy / (float)dx;
        }
        if (m < 0.0f) {
            if (dy < 0) {
                dy_neg = -1;
                dx_neg = 1;
            } else {
                dy_neg = 1;
                dx_neg = -1;
            }
            neg_slope = true;
        }
        int d = 2 * (dy * dy_neg) - dx * dx_neg;
        int incrH = 2 * dy * dy_neg;
        int incrHV = 2 * (dy * dy_neg - dx * dx_neg);
        int x = x1;
        int y = y1;
        int tempx = x;
        int tempy = y;
        if (switch_x_y) {
            temp = x;
            x = y;
            y = temp;
        }
        MiscTools.drawPoint(canvas, y, x, color);
        x = tempx;
        y = tempy;
        while (x < x2) {
            if (d <= 0) {
                d += incrH;
            } else {
                d += incrHV;
                ++x;
                if (neg_slope) {
                    --y;
                }
            }
            tempx = ++x;
            tempy = ++y;
            if (switch_x_y) {
                temp = x;
                x = y;
                y = temp;
            }
            MiscTools.drawPoint(canvas, y, x, color);
            x = tempx;
            y = tempy;
        }
    }

    public static void drawPoint(double[][] canvas, int y, int x, double color) {
        if (y < 0 || y >= canvas.length) {
            return;
        }
        if (x < 0 || x >= canvas[0].length) {
            return;
        }
        canvas[y][x] = color;
    }

    public static void drawArrow(double[][] canvas, int x1, int y1, int x2, int y2, double color, int arrowSize) {
        MiscTools.drawLine(canvas, x1, y1, x2, y2, color);
        int arrow_size2 = 2 * arrowSize;
        if ((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) < arrowSize * arrowSize) {
            return;
        }
        if (x2 == x1) {
            if (y2 > y1) {
                MiscTools.drawLine(canvas, x2, y2, x2 - arrowSize, y2 - arrow_size2, color);
                MiscTools.drawLine(canvas, x2, y2, x2 + arrowSize, y2 - arrow_size2, color);
            } else {
                MiscTools.drawLine(canvas, x2, y2, x2 - arrowSize, y2 + arrow_size2, color);
                MiscTools.drawLine(canvas, x2, y2, x2 + arrowSize, y2 + arrow_size2, color);
            }
        } else if (y2 == y1) {
            if (x2 > x1) {
                MiscTools.drawLine(canvas, x2, y2, x2 - arrow_size2, y2 - arrowSize, color);
                MiscTools.drawLine(canvas, x2, y2, x2 - arrow_size2, y2 + arrowSize, color);
            } else {
                MiscTools.drawLine(canvas, x2, y2, x2 + arrow_size2, y2 - arrowSize, color);
                MiscTools.drawLine(canvas, x2, y2, x2 + arrow_size2, y2 + arrowSize, color);
            }
        } else {
            double t1 = Math.abs(new Integer(y2 - y1).doubleValue());
            double t2 = Math.abs(new Integer(x2 - x1).doubleValue());
            double theta = Math.atan(t1 / t2);
            if (x2 < x1) {
                theta = y2 < y1 ? (theta += Math.PI) : -(Math.PI + theta);
            } else if (x2 > x1 && y2 < y1) {
                theta = Math.PI * 2 - theta;
            }
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            Point p2 = new Point(-arrow_size2, -arrowSize);
            Point p3 = new Point(-arrow_size2, arrowSize);
            int x = new Long(Math.round(cosTheta * (double)p2.x - sinTheta * (double)p2.y)).intValue();
            p2.y = new Long(Math.round(sinTheta * (double)p2.x + cosTheta * (double)p2.y)).intValue();
            p2.x = x;
            x = new Long(Math.round(cosTheta * (double)p3.x - sinTheta * (double)p3.y)).intValue();
            p3.y = new Long(Math.round(sinTheta * (double)p3.x + cosTheta * (double)p3.y)).intValue();
            p3.x = x;
            p2.translate(x2, y2);
            p3.translate(x2, y2);
            MiscTools.drawLine(canvas, x2, y2, p2.x, p2.y, color);
            MiscTools.drawLine(canvas, x2, y2, p3.x, p3.y, color);
        }
    }

    public static void applyTransformationToSourceMT(Sequence source, Sequence target, int intervals, double[][] cx, double[][] cy) {
        IcyBufferedImage result_imp = MiscTools.applyTransformationMT(source, target, intervals, cx, cy);
        source.beginUpdate();
        source.setImage(0, 0, (BufferedImage)result_imp);
        source.dataChanged();
        source.endUpdate();
    }

    public static IcyBufferedImage applyTransformationMT(Sequence sourceSeq, Sequence targetSeq, int intervals, double[][] cx, double[][] cy) {
        int targetHeight = targetSeq.getHeight();
        int targetWidth = targetSeq.getWidth();
        BSplineModel swx = new BSplineModel(cx);
        BSplineModel swy = new BSplineModel(cy);
        BSplineModel[] sourceModels = new BSplineModel[sourceSeq.getSizeC()];
        int c = 0;
        while (c < sourceSeq.getSizeC()) {
            sourceModels[c] = new BSplineModel(IcyBufferedImageUtil.extractChannel((IcyBufferedImage)sourceSeq.getFirstImage(), (int)c), false, 1);
            sourceModels[c].setPyramidDepth(0);
            sourceModels[c].startPyramids();
            ++c;
        }
        try {
            c = 0;
            while (c < sourceSeq.getSizeC()) {
                sourceModels[c].join();
                ++c;
            }
        }
        catch (InterruptedException e) {
            System.out.println("Unexpected interruption exception " + e);
        }
        IcyBufferedImage cp = new IcyBufferedImage(targetWidth, targetHeight, sourceSeq.getSizeC(), sourceSeq.getDataType_());
        int nproc = Runtime.getRuntime().availableProcessors();
        int blockHeight = targetHeight / nproc;
        if (targetHeight % 2 != 0) {
            ++blockHeight;
        }
        int nThreads = nproc;
        Thread[] threads = new Thread[nThreads];
        Rectangle[] rects = new Rectangle[nThreads];
        IcyBufferedImage[] fpTiles = new IcyBufferedImage[nThreads];
        int i = 0;
        while (i < nThreads) {
            int y_start = i * blockHeight;
            if (nThreads - 1 == i) {
                blockHeight = targetHeight - i * blockHeight;
            }
            rects[i] = new Rectangle(0, y_start, targetWidth, blockHeight);
            fpTiles[i] = new IcyBufferedImage(rects[i].width, rects[i].height, sourceSeq.getSizeC(), sourceSeq.getDataType_());
            threads[i] = new Thread(new ColorApplyTransformTile(swx, swy, sourceModels, targetWidth, targetHeight, intervals, rects[i], fpTiles[i]));
            threads[i].start();
            ++i;
        }
        i = 0;
        while (i < nThreads) {
            try {
                threads[i].join();
                threads[i] = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        cp.beginUpdate();
        i = 0;
        while (i < nThreads) {
            int c2 = 0;
            while (c2 < cp.getSizeC()) {
                cp.copyData(fpTiles[i], null, new Point(rects[i].x, rects[i].y), c2, c2);
                ++c2;
            }
            fpTiles[i] = null;
            rects[i] = null;
            ++i;
        }
        cp.dataChanged();
        cp.endUpdate();
        return cp;
    }

    private static class ColorApplyTransformTile
    implements Runnable {
        final BSplineModel swx;
        final BSplineModel swy;
        final BSplineModel[] sourceModels;
        final int targetCurrentWidth;
        final int targetCurrentHeight;
        final int intervals;
        final Rectangle rect;
        private final IcyBufferedImage ibi;

        ColorApplyTransformTile(BSplineModel swx, BSplineModel swy, BSplineModel[] sourceModels, int targetCurrentWidth, int targetCurrentHeight, int intervals, Rectangle rect, IcyBufferedImage ibi) {
            this.swx = swx;
            this.swy = swy;
            this.sourceModels = sourceModels;
            this.targetCurrentWidth = targetCurrentWidth;
            this.targetCurrentHeight = targetCurrentHeight;
            this.intervals = intervals;
            this.rect = rect;
            this.ibi = ibi;
        }

        @Override
        public void run() {
            int auxTargetHeight = this.rect.y + this.rect.height;
            int auxTargetWidth = this.rect.x + this.rect.width;
            double[][] ibiArray = Array2DUtil.arrayToDoubleArray((Object)this.ibi.getDataXYC(), (boolean)this.ibi.isSignedDataType());
            int sourceWidth = this.sourceModels[0].getWidth();
            int sourceHeight = this.sourceModels[0].getHeight();
            Rectangle srcLimits = new Rectangle();
            boolean firstLim = true;
            int v_rect = 0;
            int v = this.rect.y;
            while (v < auxTargetHeight) {
                int v_offset = v_rect * this.rect.width;
                double tv = (double)(v * this.intervals) / (double)(this.targetCurrentHeight - 1) + 1.0;
                int u_rect = 0;
                int u = this.rect.x;
                while (u < auxTargetWidth) {
                    int c;
                    double tu = (double)(u * this.intervals) / (double)(this.targetCurrentWidth - 1) + 1.0;
                    double x = this.swx.prepareForInterpolationAndInterpolateI(tu, tv, false, false);
                    double y = this.swy.prepareForInterpolationAndInterpolateI(tu, tv, false, false);
                    if (firstLim) {
                        firstLim = false;
                        srcLimits.x = (int)x;
                        srcLimits.y = (int)y;
                        srcLimits.width = (int)x;
                        srcLimits.height = (int)y;
                    } else {
                        srcLimits.x = Math.min(srcLimits.x, (int)x);
                        srcLimits.y = Math.min(srcLimits.y, (int)y);
                        srcLimits.width = Math.max(srcLimits.width, (int)x);
                        srcLimits.height = Math.max(srcLimits.height, (int)y);
                    }
                    if (x >= 0.0 && x < (double)sourceWidth && y >= 0.0 && y < (double)sourceHeight) {
                        c = 0;
                        while (c < this.ibi.getSizeC()) {
                            ibiArray[c][u_rect + v_offset] = this.sourceModels[c].prepareForInterpolationAndInterpolateI(x, y, false, false);
                            ++c;
                        }
                    } else {
                        c = 0;
                        while (c < this.ibi.getSizeC()) {
                            ibiArray[c][u_rect + v_offset] = 0.0;
                            ++c;
                        }
                    }
                    ++u;
                    ++u_rect;
                }
                ++v;
                ++v_rect;
            }
            System.out.println("limits: " + srcLimits);
            Array2DUtil.doubleArrayToSafeArray((double[][])ibiArray, (Object)this.ibi.getDataXYC(), (boolean)this.ibi.isSignedDataType());
            this.ibi.dataChanged();
        }
    }
}

