/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.bigimage;

import algorithms.danyfel80.bigimage.BigImageLoader;
import icy.common.exception.UnsupportedFormatException;
import icy.sequence.Sequence;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;

public class LoadBigImage
extends EzPlug
implements Block,
EzStoppable {
    private EzVarFile inFile = new EzVarFile("Image path", "");
    private EzVarInteger inMaxWidth = new EzVarInteger("Max width");
    private EzVarInteger inMaxHeight = new EzVarInteger("Max height");
    private EzVarBoolean inIsTiled = new EzVarBoolean("Load Tile", false);
    private EzVarInteger inTileX = new EzVarInteger("Tile x");
    private EzVarInteger inTileY = new EzVarInteger("Tile y");
    private EzVarInteger inTileW = new EzVarInteger("Tile width");
    private EzVarInteger inTileH = new EzVarInteger("Tile height");
    private boolean isStopped;
    BigImageLoader loader;

    public void declareInput(VarList inputMap) {
        inputMap.add(this.inFile.name, this.inFile.getVariable());
        inputMap.add(this.inMaxWidth.name, this.inMaxWidth.getVariable());
        inputMap.add(this.inMaxHeight.name, this.inMaxHeight.getVariable());
        inputMap.add(this.inIsTiled.name, this.inIsTiled.getVariable());
        inputMap.add(this.inTileX.name, this.inTileX.getVariable());
        inputMap.add(this.inTileY.name, this.inTileY.getVariable());
        inputMap.add(this.inTileW.name, this.inTileW.getVariable());
        inputMap.add(this.inTileH.name, this.inTileH.getVariable());
    }

    public void declareOutput(VarList outputMap) {
    }

    public void clean() {
    }

    protected void execute() {
        this.isStopped = false;
        String path = ((File)this.inFile.getValue()).getAbsolutePath();
        int maxWidth = (Integer)this.inMaxWidth.getValue();
        int maxHeight = (Integer)this.inMaxHeight.getValue();
        boolean isTiled = (Boolean)this.inIsTiled.getValue();
        int tileX = (Integer)this.inTileX.getValue();
        int tileY = (Integer)this.inTileY.getValue();
        int tileW = (Integer)this.inTileW.getValue();
        int tileH = (Integer)this.inTileH.getValue();
        try {
            long startTime = System.nanoTime();
            this.loader = new BigImageLoader();
            this.loader.setPluginGUI(this.getUI());
            Sequence s = this.loader.loadDownsampledImage(path, isTiled ? new Rectangle(tileX, tileY, tileW, tileH) : null, maxWidth, maxHeight, true);
            long endTime = System.nanoTime();
            this.addSequence(s);
            System.out.println("Loaded in " + (endTime - startTime) / 1000000L + "msecs.");
        }
        catch (UnsupportedFormatException | IOException e) {
            e.printStackTrace();
        }
        if (this.getUI() != null) {
            this.getUI().setProgressBarValue(0.0);
        }
    }

    protected void initialize() {
        this.addEzComponent((EzComponent)this.inFile);
        EzGroup downsamplingGroup = new EzGroup("Downsampling", new EzComponent[]{this.inMaxWidth, this.inMaxHeight});
        this.addEzComponent((EzComponent)downsamplingGroup);
        this.inMaxWidth.setValue((Object)2000);
        this.inMaxHeight.setValue((Object)2000);
        this.inIsTiled.addVarChangeListener((EzVarListener)new EzVarListener<Boolean>(){

            public void variableChanged(EzVar<Boolean> source, Boolean newValue) {
                LoadBigImage.this.inTileX.setVisible(newValue.booleanValue());
                LoadBigImage.this.inTileY.setVisible(newValue.booleanValue());
                LoadBigImage.this.inTileW.setVisible(newValue.booleanValue());
                LoadBigImage.this.inTileH.setVisible(newValue.booleanValue());
            }
        });
        EzGroup tileGroup = new EzGroup("Tiles", new EzComponent[]{this.inIsTiled, this.inTileX, this.inTileY, this.inTileW, this.inTileH});
        this.addEzComponent((EzComponent)tileGroup);
        this.inIsTiled.setValue((Object)false);
    }

    public void stopExecution() {
        this.isStopped = true;
        this.loader.interrupt();
    }

    public boolean isStopped() {
        return this.isStopped;
    }
}

